/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.lock;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.protocol.codec.FencedLockGetLockOwnershipCodec;
import com.hazelcast.client.impl.protocol.codec.FencedLockLockCodec;
import com.hazelcast.client.impl.protocol.codec.FencedLockTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.FencedLockUnlockCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.lock.LockOwnershipState;
import com.hazelcast.cp.internal.datastructures.lock.proxy.AbstractFencedLockProxy;
import com.hazelcast.cp.internal.session.AbstractProxySessionManager;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class FencedLockProxy
extends ClientProxy
implements FencedLock {
    private static final ClientMessageDecoder GET_LOCK_OWNERSHIP_STATE_RESPONSE_DECODER = clientMessage -> {
        FencedLockGetLockOwnershipCodec.ResponseParameters params = FencedLockGetLockOwnershipCodec.decodeResponse(clientMessage);
        return new LockOwnershipState(params.fence, params.lockCount, params.sessionId, params.threadId);
    };
    private final FencedLockImpl lock;

    public FencedLockProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:lockService", proxyName, context);
        this.lock = new FencedLockImpl(this.getClient().getProxySessionManager(), groupId, proxyName, objectName);
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public long lockAndGetFence() {
        return this.lock.lockAndGetFence();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public long tryLockAndGetFence() {
        return this.lock.tryLockAndGetFence();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        return this.lock.tryLock(time, unit);
    }

    @Override
    public long tryLockAndGetFence(long time, TimeUnit unit) {
        return this.lock.tryLockAndGetFence(time, unit);
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public long getFence() {
        return this.lock.getFence();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public boolean isLockedByCurrentThread() {
        return this.lock.isLockedByCurrentThread();
    }

    @Override
    public int getLockCount() {
        return this.lock.getLockCount();
    }

    @Override
    public CPGroupId getGroupId() {
        return this.lock.getGroupId();
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }

    @Override
    public void onDestroy() {
        ClientMessage msg = CPGroupDestroyCPObjectCodec.encodeRequest((RaftGroupId)this.lock.getGroupId(), this.getServiceName(), this.lock.getObjectName());
        new ClientInvocation(this.getClient(), msg, this.name).invoke().joinInternal();
    }

    @Override
    protected void postDestroy() {
        super.postDestroy();
        this.lock.destroy();
    }

    private class FencedLockImpl
    extends AbstractFencedLockProxy {
        FencedLockImpl(AbstractProxySessionManager sessionManager, RaftGroupId groupId, String proxyName, String objectName) {
            super(sessionManager, groupId, proxyName, objectName);
        }

        @Override
        protected InternalCompletableFuture<Long> doLock(long sessionId, long threadId, UUID invocationUid) {
            ClientMessage request = FencedLockLockCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid);
            ClientInvocationFuture future = new ClientInvocation(FencedLockProxy.this.getClient(), request, FencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<Long>(future, FencedLockProxy.this.getSerializationService(), FencedLockLockCodec::decodeResponse);
        }

        @Override
        protected InternalCompletableFuture<Long> doTryLock(long sessionId, long threadId, UUID invocationUid, long timeoutMillis) {
            ClientMessage request = FencedLockTryLockCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid, timeoutMillis);
            ClientInvocationFuture future = new ClientInvocation(FencedLockProxy.this.getClient(), request, FencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<Long>(future, FencedLockProxy.this.getSerializationService(), FencedLockTryLockCodec::decodeResponse);
        }

        @Override
        protected InternalCompletableFuture<Boolean> doUnlock(long sessionId, long threadId, UUID invocationUid) {
            ClientMessage request = FencedLockUnlockCodec.encodeRequest(this.groupId, this.objectName, sessionId, threadId, invocationUid);
            ClientInvocationFuture future = new ClientInvocation(FencedLockProxy.this.getClient(), request, FencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<Boolean>(future, FencedLockProxy.this.getSerializationService(), FencedLockUnlockCodec::decodeResponse);
        }

        @Override
        protected InternalCompletableFuture<LockOwnershipState> doGetLockOwnershipState() {
            ClientMessage request = FencedLockGetLockOwnershipCodec.encodeRequest(this.groupId, this.objectName);
            ClientInvocationFuture future = new ClientInvocation(FencedLockProxy.this.getClient(), request, FencedLockProxy.this.name).invoke();
            return new ClientDelegatingFuture<LockOwnershipState>(future, FencedLockProxy.this.getSerializationService(), GET_LOCK_OWNERSHIP_STATE_RESPONSE_DECODER);
        }
    }
}

