/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.zkforge.ckez.CKeditor;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Div;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;

public class FilebrowserController
extends GenericForwardComposer {
    private static final String[] EXCLUDE_FOLDERS = new String[]{"WEB-INF", "META-INF"};
    private static final String[] EXCLUDE_FILES = new String[0];
    private static final String[] IMAGES = new String[]{"gif", "jpg", "jpeg", "png"};
    private static final String[] FILES = new String[]{"htm", "html", "php", "php3", "php5", "phtml", "asp", "aspx", "ascx", "jsp", "cfm", "cfc", "pl", "bat", "exe", "dll", "reg", "cgi", "asmx"};
    private static final String[] FLASH = new String[]{"swf"};
    private static final String[] MEDIA = new String[]{"swf", "fla", "jpg", "gif", "jpeg", "png", "avi", "mpg", "mpeg"};
    private static final String swfPath = "~./ckez/img/flashIcon.jpg";
    private Set<String> _fileWhiteList;
    private Set<String> _folderBlackList = new HashSet<String>(Arrays.asList(EXCLUDE_FOLDERS));
    private Tree tree;
    private Div cntDiv;
    private Toolbarbutton selBtn;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        Object t = this.param.get("Type");
        if (t == null) {
            return;
        }
        String type = ((String[])t)[0];
        this._fileWhiteList = this.initFileWhiteList(type);
        String url = FilebrowserController.getFolderUrl(this.getUrl(this.param, type));
        if (Strings.isBlank((String)url)) {
            return;
        }
        if (this.application.getResourcePaths(url) == null) {
            throw new UiException("Folder not found: " + url);
        }
        TreeMap rootFolderMap = new TreeMap();
        TreeMap map = new TreeMap();
        rootFolderMap.put(url, map);
        this.parseFolders(url, map);
        this.tree.setItemRenderer((TreeitemRenderer)new ExplorerTreeitemRenderer());
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)new DefaultTreeNode((Object)"ROOT", (Collection)this.initTreeModel(rootFolderMap, new ArrayList()))));
        this.showImages(map);
    }

    private String getUrl(Map param, String type) {
        Object d = param.get("dtid");
        if (d == null) {
            return null;
        }
        String dtid = ((String[])d)[0];
        Object u = param.get("uuid");
        if (u == null) {
            return null;
        }
        String uuid = ((String[])u)[0];
        Session sess = Sessions.getCurrent((boolean)false);
        if (sess == null) {
            return null;
        }
        Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            return null;
        }
        CKeditor ckez = (CKeditor)desktop.getComponentByUuidIfAny(uuid);
        if (ckez == null) {
            return null;
        }
        if ("Images".equals(type)) {
            return ckez.getFilebrowserImageBrowseUrl();
        }
        if ("Flash".equals(type)) {
            return ckez.getFilebrowserFlashBrowseUrl();
        }
        if ("Files".equals(type)) {
            return ckez.getFilebrowserBrowseUrl();
        }
        return null;
    }

    private Set<String> initFileWhiteList(String type) {
        if ("Images".equals(type)) {
            return new HashSet<String>(Arrays.asList(IMAGES));
        }
        if ("Flash".equals(type)) {
            return new HashSet<String>(Arrays.asList(FLASH));
        }
        if ("Files".equals(type)) {
            return new HashSet<String>(Arrays.asList(FILES));
        }
        return new HashSet<String>();
    }

    static String getFolderUrl(String url) {
        if (Strings.isBlank((String)url)) {
            return "";
        }
        if (url.startsWith("./")) {
            url = url.substring(1);
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url;
    }

    private List initTreeModel(Map parentFolderMap, List list) {
        for (Map.Entry o : parentFolderMap.entrySet()) {
            Map.Entry entry = o;
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            list.add(new DefaultTreeNode(entry, (Collection)this.initTreeModel((Map)value, new ArrayList())));
        }
        return list;
    }

    private Map parseFolders(String path, Map parentFolderMap) {
        for (Object o : this.application.getResourcePaths(path)) {
            String pagePath = String.valueOf(o);
            if (pagePath.endsWith("/")) {
                String folderName = pagePath.substring(0, pagePath.length() - 1);
                if (!this.shallShowFolder(folderName = folderName.substring(folderName.lastIndexOf("/") + 1))) continue;
                parentFolderMap.put(folderName, this.parseFolders(pagePath, new TreeMap()));
                continue;
            }
            String fileName = pagePath.substring(pagePath.lastIndexOf("/") + 1);
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (!this.shallShowFile(fileName) && !this.shallShowFile(extension)) continue;
            parentFolderMap.put(fileName, pagePath);
        }
        return parentFolderMap;
    }

    private boolean shallShowFolder(String folderName) {
        return !this._folderBlackList.contains(folderName);
    }

    private boolean shallShowFile(String fileName) {
        return !Strings.isEmpty((String)fileName) && this._fileWhiteList.contains(fileName.toLowerCase());
    }

    public void onSelect$tree() {
        this.cntDiv.getChildren().clear();
        Treeitem item = this.tree.getSelectedItem();
        Map map = (Map)item.getValue();
        this.showImages(map);
    }

    private void showImages(Map map) {
        for (Map.Entry o : map.entrySet()) {
            Map.Entry me = o;
            Object value = me.getValue();
            if (value instanceof Map) continue;
            String path = String.valueOf(value);
            Toolbarbutton tb = new Toolbarbutton(String.valueOf(me.getKey()), path.endsWith("swf") ? swfPath : path);
            tb.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    if (FilebrowserController.this.selBtn != null) {
                        FilebrowserController.this.selBtn.setSclass(null);
                    }
                    FilebrowserController.this.selBtn = (Toolbarbutton)event.getTarget();
                    FilebrowserController.this.selBtn.setSclass("sel");
                }
            });
            int CKEditorFuncNum = Integer.parseInt(((String[])this.param.get("CKEditorFuncNum"))[0]);
            String script = "window.opener.CKEDITOR.tools.callFunction(" + CKEditorFuncNum + ", '" + this.execution.encodeURL(path) + "'); window.close(); ";
            tb.setWidgetListener("onDoubleClick", script);
            this.cntDiv.appendChild((Component)tb);
        }
    }

    private class ExplorerTreeitemRenderer
    implements TreeitemRenderer {
        private ExplorerTreeitemRenderer() {
        }

        public void render(Treeitem item, Object data) throws Exception {
            Map.Entry entry = (Map.Entry)((DefaultTreeNode)data).getData();
            item.setLabel(String.valueOf(entry.getKey()));
            Object value = entry.getValue();
            item.setValue(value);
            item.setOpen(true);
            if (item.getParentItem() == null) {
                item.setSelected(true);
            }
        }

        public void render(Treeitem item, Object data, int index) throws Exception {
            this.render(item, data);
        }
    }
}

