/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MImage;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.image.AImage;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;

public class WImageDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -5048907034691374834L;
    private MImage m_mImage = null;
    private static final CLogger log = CLogger.getCLogger(WImageDialog.class);
    private Borderlayout mainLayout = new Borderlayout();
    private Panel parameterPanel = new Panel();
    private Button fileButton = new Button();
    private Button captureButton = new Button();
    private Iframe image = new Iframe();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false);
    private boolean cancel = false;
    private Textbox fileNameTextbox = new Textbox();
    private Div captureDiv;
    private String defaultNameForCaptureImage = "CapturedImage";
    private Button cancelCaptureButton;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private static List<String> autoPreviewList = new ArrayList<String>();

    static {
        autoPreviewList.add("image/jpeg");
        autoPreviewList.add("image/png");
        autoPreviewList.add("image/gif");
        autoPreviewList.add("image/tiff");
        autoPreviewList.add("image/bmp");
        autoPreviewList.add("image/x-icon");
    }

    public WImageDialog(MImage mImage) {
        this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"AD_Image_ID"));
        log.info("MImage=" + String.valueOf(mImage));
        this.m_mImage = mImage;
        try {
            this.init();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        if (this.m_mImage == null) {
            this.m_mImage = new MImage(Env.getCtx(), 0, null);
        } else if (this.m_mImage.getData() != null) {
            try {
                AImage aImage = new AImage(this.m_mImage.getName(), this.m_mImage.getData());
                this.image.setContent((Media)aImage);
                this.image.setClientAttribute("sandbox", "");
                this.image.setVisible(true);
                this.image.invalidate();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "load image", (Throwable)e);
            }
        }
        this.fileNameTextbox.setValue(this.m_mImage.getName());
        AEnv.showCenterScreen(this);
    }

    protected void init() throws Exception {
        this.setSclass("popup-dialog image-dialog");
        this.setBorder("normal");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 640);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 540);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
        this.setSizable(true);
        this.setStyle("position: relative;");
        this.captureDiv = new Div();
        this.appendChild((Component)this.captureDiv);
        this.captureDiv.setStyle("position: absolute;");
        if (ClientInfo.maxHeight(539)) {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this.captureDiv, ClientInfo.get().desktopHeight - 60 + "px");
        } else {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this.captureDiv, "480px");
        }
        if (ClientInfo.maxWidth(639)) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.captureDiv, ClientInfo.get().desktopWidth + "px");
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.captureDiv, "640px");
        }
        this.captureDiv.setVisible(false);
        this.captureDiv.addEventListener("onCaptureImage", (EventListener)this);
        this.cancelCaptureButton = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Cancel")));
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.cancelCaptureButton);
        this.cancelCaptureButton.setStyle("position: absolute; bottom: 5px; right: 3px;");
        this.appendChild((Component)this.cancelCaptureButton);
        this.cancelCaptureButton.addEventListener("onClick", this);
        this.cancelCaptureButton.setVisible(false);
        this.mainLayout.setParent((Component)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mainLayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.mainLayout, "1");
        this.fileButton.setLabel("Upload");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.fileButton);
        this.captureButton.setLabel("Capture");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.captureButton);
        North north = new North();
        north.setParent((Component)this.mainLayout);
        north.appendChild((Component)this.parameterPanel);
        Hbox hbox = new Hbox();
        hbox.setAlign("center");
        hbox.setPack("start");
        hbox.appendChild((Component)this.fileButton);
        hbox.appendChild((Component)new Space());
        hbox.appendChild((Component)this.captureButton);
        hbox.appendChild((Component)new Space());
        hbox.appendChild((Component)this.fileNameTextbox);
        this.parameterPanel.setStyle("padding: 5px");
        this.parameterPanel.appendChild((Component)hbox);
        Separator separator = new Separator();
        separator.setOrient("horizontal");
        separator.setBar(true);
        this.parameterPanel.appendChild((Component)separator);
        Center center = new Center();
        center.setSclass("dialog-content");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.image, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.image, "true");
        center.setParent((Component)this.mainLayout);
        this.image.setSclass("image-fit-contain");
        center.appendChild((Component)this.image);
        South south = new South();
        south.setSclass("dialog-footer");
        south.setParent((Component)this.mainLayout);
        south.appendChild((Component)this.confirmPanel);
        this.fileButton.setUpload(AdempiereWebUI.getUploadSetting());
        this.fileButton.addEventListener("onUpload", this);
        this.captureButton.addEventListener("onClick", this);
        this.confirmPanel.addActionListener("onClick", this);
        this.addEventListener("onUpload", this);
        this.addEventListener("onSave", this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public void onEvent(Event e) throws Exception {
        if (e instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)e;
            this.processUploadMedia(ue.getMedia());
        } else if (e.getTarget().getId().equals("Ok")) {
            Clients.showBusy((Component)this, (String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
            Events.echoEvent((String)"onSave", (Component)this, null);
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (e.getTarget().getId().equals("Reset")) {
            Media img = null;
            this.image.setContent(img);
            this.image.setClientAttribute("sandbox", "");
            this.image.setVisible(true);
            this.image.invalidate();
            this.fileNameTextbox.setValue(null);
        } else if (e.getTarget() == this.captureButton) {
            this.captureDiv.setVisible(true);
            this.cancelCaptureButton.setVisible(true);
            this.cancelCaptureButton.setEnabled(true);
            this.mainLayout.setVisible(false);
            String script = "(function(){let wgt = zk.Widget.$('#" + this.captureDiv.getUuid() + "');";
            script = script + "let cancelBtn=zk.Widget.$('#" + this.cancelCaptureButton.getUuid() + "');";
            script = script + "jq(wgt).photobooth(); ";
            script = script + "jq(wgt).bind( 'image', function( event, dataUrl ){ cancelBtn.setVisible(false);zAu.send(new zk.Event(wgt, 'onCaptureImage', dataUrl, {toServer:true})); });";
            script = script + "})()";
            Clients.evalJavaScript((String)script);
        } else if (e.getName().equals("onCaptureImage")) {
            this.captureDiv.setVisible(false);
            this.cancelCaptureButton.setVisible(false);
            this.mainLayout.setVisible(true);
            String dataUrl = (String)e.getData();
            if (!Util.isEmpty((String)dataUrl)) {
                String encodingPrefix = "base64,";
                int contentStartIndex = dataUrl.indexOf(encodingPrefix) + encodingPrefix.length();
                byte[] imageData = Base64.decodeBase64((byte[])dataUrl.substring(contentStartIndex).getBytes());
                AImage img = new AImage(this.defaultNameForCaptureImage, imageData);
                this.image.setContent((Media)img);
                this.image.setClientAttribute("sandbox", "");
                this.image.setVisible(true);
                this.image.invalidate();
                if (this.m_mImage == null) {
                    this.m_mImage = new MImage(Env.getCtx(), 0, null);
                }
                this.m_mImage.setName(this.defaultNameForCaptureImage);
                this.m_mImage.setBinaryData(imageData);
                this.fileNameTextbox.setValue(this.defaultNameForCaptureImage);
            }
            String script = "(function(){let wgt = zk.Widget.$('#" + this.captureDiv.getUuid() + "');";
            script = script + "jq(wgt).data( 'photobooth').destroy();})() ";
            Clients.evalJavaScript((String)script);
        } else if (e.getTarget() == this.cancelCaptureButton) {
            this.captureDiv.setVisible(false);
            this.cancelCaptureButton.setVisible(false);
            this.mainLayout.setVisible(true);
            String script = "(function(){let wgt = zk.Widget.$('#" + this.captureDiv.getUuid() + "');";
            script = script + "jq(wgt).data( 'photobooth').destroy();})() ";
            Clients.evalJavaScript((String)script);
        } else if (e.getName().equals("onSave")) {
            try {
                this.onSave();
            }
            finally {
                Clients.clearBusy((Component)this);
            }
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.cancel = true;
        this.detach();
    }

    private void onSave() {
        if (this.image.getContent() != null) {
            if (!Util.isEmpty((String)this.fileNameTextbox.getValue())) {
                this.m_mImage.setName(this.fileNameTextbox.getValue());
            }
            this.m_mImage.saveEx();
        } else if (this.m_mImage != null && this.m_mImage.getAD_Image_ID() > 0) {
            this.m_mImage.setBinaryData(null);
            this.m_mImage.setName("-");
            this.m_mImage.saveEx();
        }
        this.detach();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private void processUploadMedia(Media imageFile) {
        if (imageFile == null) {
            return;
        }
        String fileName = imageFile.getName();
        String mimeType = MimeType.getMimeType((String)fileName);
        if (!autoPreviewList.contains(mimeType)) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"UploadImageTypeNotAllowed"));
        }
        try {
            InputStream is = imageFile.getStreamData();
            AImage aImage = new AImage(fileName, is);
            if (autoPreviewList.contains(mimeType)) {
                this.image.setContent((Media)aImage);
                this.image.setClientAttribute("sandbox", "");
                this.image.setVisible(true);
                this.image.invalidate();
            } else {
                this.image.setSrc(null);
                this.image.setVisible(false);
            }
            is.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "load image", (Throwable)e);
            return;
        }
        this.fileNameTextbox.setValue(imageFile.getName());
        this.mainLayout.invalidate();
        if (this.m_mImage == null) {
            this.m_mImage = new MImage(Env.getCtx(), 0, null);
        }
        this.m_mImage.setName(fileName);
        this.m_mImage.setImageURL(fileName);
        if (this.image.getContent() != null) {
            this.m_mImage.setBinaryData(this.image.getContent().getByteData());
        } else {
            this.m_mImage.setBinaryData(null);
        }
    }

    public int getAD_Image_ID() {
        if (this.m_mImage != null) {
            return this.m_mImage.getAD_Image_ID();
        }
        return 0;
    }

    public String getDefaultNameForCaptureImage() {
        return this.defaultNameForCaptureImage;
    }

    public void setDefaultNameForCaptureImage(String defaultNameForCaptureImage) {
        this.defaultNameForCaptureImage = defaultNameForCaptureImage;
    }

    public void focus() {
        super.focus();
        if (this.fileButton != null) {
            this.fileButton.focus();
        }
    }
}

