/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

@Process
public class ProjectGenOrder
extends SvrProcess {
    private int m_C_Project_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameter() != null) {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.m_C_Project_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Project_ID=" + this.m_C_Project_ID);
        }
        if (this.m_C_Project_ID == 0) {
            throw new IllegalArgumentException("C_Project_ID == 0");
        }
        MProject fromProject = ProjectGenOrder.getProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        Env.setSOTrx((Properties)this.getCtx(), (boolean)true);
        MOrder order = new MOrder(fromProject, true, "WI");
        if (!order.save()) {
            throw new Exception("Could not create Order");
        }
        int count = 0;
        if ("S".equals(fromProject.getProjectCategory())) {
            throw new Exception("Service Charge Projects are on the TODO List");
        }
        MProjectLine[] lines = fromProject.getLines();
        int i = 0;
        while (i < lines.length) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(lines[i].getLine());
            ol.setDescription(lines[i].getDescription());
            ol.setM_Product_ID(lines[i].getM_Product_ID(), true);
            ol.setQty(lines[i].getPlannedQty().subtract(lines[i].getInvoicedQty()));
            ol.setPrice();
            if (lines[i].getPlannedPrice() != null && lines[i].getPlannedPrice().compareTo(Env.ZERO) != 0) {
                ol.setPrice(lines[i].getPlannedPrice());
            }
            ol.setDiscount();
            ol.setTax();
            if (ol.save()) {
                ++count;
            }
            ++i;
        }
        if (lines.length != count) {
            this.log.log(Level.SEVERE, "Lines difference - ProjectLines=" + lines.length + " <> Saved=" + count);
        }
        StringBuilder msgreturn = new StringBuilder("@C_Order_ID@ ").append(order.getDocumentNo()).append(" (").append(count).append(")");
        return msgreturn.toString();
    }

    protected static MProject getProject(Properties ctx, int C_Project_ID, String trxName) {
        MProject fromProject = new MProject(ctx, C_Project_ID, trxName);
        if (fromProject.getC_Project_ID() == 0) {
            throw new IllegalArgumentException("Project not found C_Project_ID=" + C_Project_ID);
        }
        if (fromProject.getM_PriceList_Version_ID() == 0) {
            throw new IllegalArgumentException("Project has no Price List");
        }
        if (fromProject.getM_Warehouse_ID() == 0) {
            throw new IllegalArgumentException("Project has no Warehouse");
        }
        if (fromProject.getC_BPartner_ID() == 0 || fromProject.getC_BPartner_Location_ID() == 0) {
            throw new IllegalArgumentException("Project has no Business Partner/Location");
        }
        return fromProject;
    }
}

