/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeline;

import java.io.IOException;
import org.zkforge.json.simple.JSONArray;
import org.zkforge.timeline.Bandinfo;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Timeline
extends XulElement {
    private String _orient = "horizontal";
    private String _height = "150px";
    private String _width = "100%";

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", orient);
        }
    }

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        if (!Objects.equals((Object)this._height, (Object)height)) {
            this._height = height;
            this.smartUpdate("height", height);
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (!Objects.equals((Object)this._width, (Object)width)) {
            this._width = width;
            this.smartUpdate("width", width);
        }
    }

    public void performFiltering(String filterText) {
        this.smartUpdate("filter", filterText);
    }

    public void clearFilter() {
        this.performFiltering("");
    }

    public void performHighlitht(String[] highlightText) {
        JSONArray matchers = new JSONArray();
        for (int i = 0; i < highlightText.length; ++i) {
            matchers.add(highlightText[i]);
        }
        this.smartUpdate("highlight", matchers.toString());
    }

    public void clearHighlight() {
        String[] highlightText = new String[]{""};
        this.performHighlitht(highlightText);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Bandinfo)) {
            throw new UiException("Unsupported child for timeline: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        if (!"150px".equals(this._height)) {
            this.render(renderer, "height", this._height);
        }
        if (!"100%".equals(this._width)) {
            this.render(renderer, "width", this._width);
        }
    }
}

