/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MStyle;
import org.compiere.model.MStyleLine;
import org.compiere.model.MTest;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class ModelForeignKeyTest
extends AbstractTestCase {
    @Test
    public void testModelCascadeRecordId() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MColumn col_test_record_id = new MColumn(ctx, MColumn.getColumn_ID((String)"Test", (String)"Record_ID"), trxName);
        col_test_record_id.setFKConstraintType("M");
        col_test_record_id.saveCrossTenantSafeEx();
        MTest test1 = new MTest(ctx, 0, trxName);
        test1.setName("Test 1");
        test1.saveEx();
        MTest test2 = new MTest(ctx, 0, trxName);
        test2.setName("Test 2");
        test2.saveEx();
        test1.setAD_Table_ID(135);
        test1.setRecord_ID(test2.getTest_ID());
        test1.saveEx();
        CacheMgt.get().reset();
        test2.deleteEx(true);
        test1.load(trxName, new String[0]);
        Assertions.assertTrue((test1.get_ID() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testModelSetNullRecordId() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MColumn col_test_record_id = new MColumn(ctx, MColumn.getColumn_ID((String)"Test", (String)"Record_ID"), trxName);
        col_test_record_id.setFKConstraintType("T");
        col_test_record_id.saveCrossTenantSafeEx();
        CacheMgt.get().reset();
        MTest test1 = new MTest(ctx, 0, trxName);
        test1.setName("Test 1");
        test1.saveEx();
        MTest test2 = new MTest(ctx, 0, trxName);
        test2.setName("Test 2");
        test2.saveEx();
        test1.setAD_Table_ID(135);
        test1.setRecord_ID(test2.getTest_ID());
        test1.saveEx();
        test2.deleteEx(true);
        test1.load(trxName, new String[0]);
        Assertions.assertTrue((test1.get_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((test1.getRecord_ID() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testModelNoActionRecordId() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MColumn col_test_record_id = new MColumn(ctx, MColumn.getColumn_ID((String)"Test", (String)"Record_ID"), trxName);
        col_test_record_id.setFKConstraintType("O");
        col_test_record_id.saveCrossTenantSafeEx();
        CacheMgt.get().reset();
        MTest test1 = new MTest(ctx, 0, trxName);
        test1.setName("Test 1");
        test1.saveEx();
        MTest test2 = new MTest(ctx, 0, trxName);
        test2.setName("Test 2");
        test2.saveEx();
        test1.setAD_Table_ID(135);
        test1.setRecord_ID(test2.getTest_ID());
        test1.saveEx();
        Assertions.assertThrows(AdempiereException.class, () -> test2.deleteEx(true));
    }

    @Test
    public void testDBNoAction() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        CacheMgt.get().reset();
        MColumn col_styleline_style = new MColumn(ctx, MColumn.getColumn_ID((String)"AD_StyleLine", (String)"AD_Style_ID"), trxName);
        Assertions.assertTrue((boolean)"N".equals(col_styleline_style.getFKConstraintType()));
        MStyle style = new MStyle(ctx, 0, trxName);
        style.setName("Test");
        style.saveEx();
        MStyleLine styleLine = new MStyleLine(ctx, 0, trxName);
        styleLine.setAD_Style_ID(style.getAD_Style_ID());
        styleLine.setLine(10);
        styleLine.setInlineStyle("Test");
        styleLine.saveEx();
        style.deleteEx(true);
        Assertions.assertThrows(Exception.class, () -> {
            boolean bl = Trx.get((String)trxName, (boolean)false).commit(true);
        }, (String)"Expected Trx.commit to throw Exception, but it didn't");
    }

    @Test
    public void testModelNoAction() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MColumn col_styleline_style = new MColumn(ctx, MColumn.getColumn_ID((String)"AD_StyleLine", (String)"AD_Style_ID"), trxName);
        col_styleline_style.setFKConstraintType("M");
        col_styleline_style.saveCrossTenantSafeEx();
        CacheMgt.get().reset();
        MStyle style = new MStyle(ctx, 0, trxName);
        style.setName("Test");
        style.saveEx();
        MStyleLine styleLine = new MStyleLine(ctx, 0, trxName);
        styleLine.setAD_Style_ID(style.getAD_Style_ID());
        styleLine.setLine(10);
        styleLine.setInlineStyle("Test");
        styleLine.saveEx();
        style.deleteEx(true);
        styleLine.load(trxName, new String[0]);
        Assertions.assertTrue((styleLine.get_ID() == 0 ? 1 : 0) != 0);
    }
}

