/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.sql.ResultSet;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.IModelFactory;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.X_Test;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.idempiere.model.IMappedModelFactory;
import org.idempiere.model.MappedModelFactory;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.TestActivator;
import org.idempiere.test.model.annotated.MyAnnotatedColorModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class MappedModelFactoryTest
extends AbstractTestCase {
    @Test
    @Order(value=1)
    public void testDefaultMappedModelFactory() {
        IMappedModelFactory mappedFactory = Core.getMappedModelFactory();
        mappedFactory.addMapping("Test", () -> MyTest.class, (id, trxName) -> new MyTest(Env.getCtx(), (int)id, (String)trxName), (rs, trxName) -> new MyTest(Env.getCtx(), (ResultSet)rs, (String)trxName));
        PO po = MTable.get((int)135).getPO(0, this.getTrxName());
        Assertions.assertTrue((boolean)(po instanceof MyTest), (String)("PO not instanceof MyTest. PO.className=" + po.getClass().getName()));
        mappedFactory.removeMapping("Test");
        CacheMgt.get().reset();
    }

    @Test
    @Order(value=2)
    public void testCustomMappedModelFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 2);
        ServiceRegistration registration = bc.registerService(IModelFactory.class, (Object)new MyFactory(), properties);
        CacheMgt.get().reset();
        PO po = MTable.get((int)135).getPO(0, this.getTrxName());
        Assertions.assertTrue((boolean)(po instanceof MyTest2), (String)("PO not instanceof MyTest2. PO.className=" + po.getClass().getName()));
        registration.unregister();
        CacheMgt.get().reset();
    }

    @Test
    @Order(value=3)
    public void testAnnotatedModelMapping() {
        BundleContext bc = TestActivator.context;
        Core.getMappedModelFactory().scan(bc, new String[]{"org.idempiere.test.model.annotated"});
        CacheMgt.get().reset();
        PO po = MTable.get((int)457).getPO(0, this.getTrxName());
        Assertions.assertTrue((boolean)(po instanceof MyAnnotatedColorModel), (String)("PO not instanceof MyAnnotatedColorModel. PO.className=" + po.getClass().getName()));
        Core.getMappedModelFactory().removeMapping("AD_Color");
        CacheMgt.get().reset();
    }

    private static final class MyFactory
    extends MappedModelFactory {
        public MyFactory() {
            this.addMapping("Test", () -> MyTest2.class, (id, trxName) -> new MyTest2(Env.getCtx(), (int)id, (String)trxName), (rs, trxName) -> new MyTest2(Env.getCtx(), (ResultSet)rs, (String)trxName));
        }
    }

    private static final class MyTest
    extends X_Test {
        private static final long serialVersionUID = 6598731099622814068L;

        public MyTest(Properties ctx, int Test_ID, String trxName) {
            super(ctx, Test_ID, trxName);
        }

        public MyTest(Properties ctx, String Test_UU, String trxName) {
            super(ctx, Test_UU, trxName);
        }

        public MyTest(Properties ctx, ResultSet rs, String trxName) {
            super(ctx, rs, trxName);
        }
    }

    private static final class MyTest2
    extends X_Test {
        private static final long serialVersionUID = 7420832191690522686L;

        public MyTest2(Properties ctx, int Test_ID, String trxName) {
            super(ctx, Test_ID, trxName);
        }

        public MyTest2(Properties ctx, String Test_UU, String trxName) {
            super(ctx, Test_UU, trxName);
        }

        public MyTest2(Properties ctx, ResultSet rs, String trxName) {
            super(ctx, rs, trxName);
        }
    }
}

