/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MStorageOnHandTest
extends AbstractTestCase {
    @Test
    public void testGetAll() {
        MProduct product = new MProduct(Env.getCtx(), 0, null);
        product.setName("testGetAll");
        product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        product.setIsStocked(true);
        product.setProductType("I");
        product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
        product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product.saveEx();
        try {
            Timestamp today = TimeUtil.getDay(null);
            Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product.get_ID(), (int)0, (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.STORE.id, (int)product.get_ID(), (int)0, (BigDecimal)new BigDecimal("2"), (Timestamp)tomorrow, (String)this.getTrxName());
            MStorageOnHand[] onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)DictionaryIDs.M_Locator.HQ.id, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertNotNull((Object)onhands);
            Assertions.assertEquals((int)1, (int)onhands.length);
            Assertions.assertEquals((int)DictionaryIDs.M_Locator.HQ.id, (int)onhands[0].getM_Locator_ID());
            Assertions.assertEquals((int)1, (int)onhands[0].getQtyOnHand().intValue());
            onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)DictionaryIDs.M_Locator.STORE.id, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertNotNull((Object)onhands);
            Assertions.assertEquals((int)1, (int)onhands.length);
            Assertions.assertEquals((int)DictionaryIDs.M_Locator.STORE.id, (int)onhands[0].getM_Locator_ID());
            Assertions.assertEquals((int)2, (int)onhands[0].getQtyOnHand().intValue());
            onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)0, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertNotNull((Object)onhands);
            Assertions.assertEquals((int)2, (int)onhands.length);
            MLocator locator = new MLocator(Env.getCtx(), DictionaryIDs.M_Locator.STORE.id, this.getTrxName());
            locator.setPriorityNo(Integer.MAX_VALUE);
            locator.saveEx();
            onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)0, (boolean)true, (boolean)true, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertNotNull((Object)onhands);
            Assertions.assertEquals((int)2, (int)onhands.length);
            Assertions.assertEquals((int)DictionaryIDs.M_Locator.STORE.id, (int)onhands[0].getM_Locator_ID());
            Assertions.assertEquals((int)2, (int)onhands[0].getQtyOnHand().intValue());
            onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)0, (boolean)false, (boolean)true, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertNotNull((Object)onhands);
            Assertions.assertEquals((int)2, (int)onhands.length);
            Assertions.assertEquals((int)DictionaryIDs.M_Locator.HQ.id, (int)onhands[0].getM_Locator_ID());
            Assertions.assertEquals((int)1, (int)onhands[0].getQtyOnHand().intValue());
            onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)0, (boolean)false, (boolean)false, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertNotNull((Object)onhands);
            Assertions.assertEquals((int)2, (int)onhands.length);
            Assertions.assertEquals((int)DictionaryIDs.M_Locator.STORE.id, (int)onhands[0].getM_Locator_ID());
            Assertions.assertEquals((int)2, (int)onhands[0].getQtyOnHand().intValue());
            onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)0, (boolean)false, (boolean)true, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertEquals((int)DictionaryIDs.M_Locator.HQ.id, (int)onhands[0].getM_Locator_ID());
            Assertions.assertEquals((int)1, (int)onhands[0].getQtyOnHand().intValue());
            MAttributeSet as = new MAttributeSet(Env.getCtx(), DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id, null);
            try {
                as.setUseGuaranteeDateForMPolicy(true);
                as.saveEx();
                MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
                asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
                asi1.setGuaranteeDate(tomorrow);
                asi1.saveEx();
                DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET M_AttributeSetInstance_ID=? WHERE M_StorageOnHand_UU=?", (Object[])new Object[]{asi1.get_ID(), onhands[0].getM_StorageOnHand_UU()}, (String)this.getTrxName());
                MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
                asi2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
                asi2.setGuaranteeDate(today);
                asi2.saveEx();
                DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET M_AttributeSetInstance_ID=? WHERE M_StorageOnHand_UU=?", (Object[])new Object[]{asi2.get_ID(), onhands[1].getM_StorageOnHand_UU()}, (String)this.getTrxName());
                CacheMgt.get().reset("M_Product", product.get_ID());
                onhands = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)0, (boolean)false, (boolean)true, (String)this.getTrxName(), (boolean)false, (int)0);
                Assertions.assertEquals((int)asi2.get_ID(), (int)onhands[0].getM_AttributeSetInstance_ID());
                Assertions.assertEquals((int)DictionaryIDs.M_Locator.STORE.id, (int)onhands[0].getM_Locator_ID());
                Assertions.assertEquals((int)2, (int)onhands[0].getQtyOnHand().intValue());
            }
            finally {
                as.setUseGuaranteeDateForMPolicy(false);
                as.saveEx();
            }
        }
        finally {
            this.rollback();
            product.deleteEx(true);
        }
    }

    @Test
    public void testGetM_Locator_ID() {
        MLocator hqLocator = new MLocator(Env.getCtx(), DictionaryIDs.M_Locator.HQ.id, this.getTrxName());
        MLocator hqLocator1 = new MLocator(Env.getCtx(), 0, this.getTrxName());
        hqLocator1.setM_Warehouse_ID(hqLocator.getM_Warehouse_ID());
        hqLocator1.setValue("HQ Locator 1");
        hqLocator1.setPriorityNo(hqLocator.getPriorityNo());
        hqLocator1.setX("x");
        hqLocator1.setY("y");
        hqLocator1.setZ("z");
        hqLocator1.saveEx();
        MProduct product = new MProduct(Env.getCtx(), 0, this.getTrxName());
        product.setName("testGetM_Locator_ID");
        product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        product.setIsStocked(true);
        product.setProductType("I");
        product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
        product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product.saveEx();
        Timestamp today = TimeUtil.getDay(null);
        MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product.get_ID(), (int)0, (BigDecimal)new BigDecimal("2"), (Timestamp)today, (String)this.getTrxName());
        MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
        asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        asi1.setLot("Lot1");
        asi1.saveEx();
        MStorageOnHand.add((Properties)Env.getCtx(), (int)hqLocator1.get_ID(), (int)product.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
        int M_Locator_ID = MStorageOnHand.getM_Locator_ID((int)hqLocator.getM_Warehouse_ID(), (int)product.get_ID(), (int)0, (BigDecimal)new BigDecimal("1"), (String)this.getTrxName());
        Assertions.assertEquals((int)DictionaryIDs.M_Locator.HQ.id, (int)M_Locator_ID);
        M_Locator_ID = MStorageOnHand.getM_Locator_ID((int)hqLocator.getM_Warehouse_ID(), (int)product.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("1"), (String)this.getTrxName());
        Assertions.assertEquals((int)hqLocator1.get_ID(), (int)M_Locator_ID);
        M_Locator_ID = MStorageOnHand.getM_Locator_ID((int)hqLocator.getM_Warehouse_ID(), (int)product.get_ID(), (int)-1, (BigDecimal)new BigDecimal("1"), (String)this.getTrxName());
        Assertions.assertEquals((int)DictionaryIDs.M_Locator.HQ.id, (int)M_Locator_ID);
        MStorageOnHand.add((Properties)Env.getCtx(), (int)hqLocator1.get_ID(), (int)product.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("2"), (Timestamp)today, (String)this.getTrxName());
        M_Locator_ID = MStorageOnHand.getM_Locator_ID((int)hqLocator.getM_Warehouse_ID(), (int)product.get_ID(), (int)-1, (BigDecimal)new BigDecimal("1"), (String)this.getTrxName());
        Assertions.assertEquals((int)hqLocator1.get_ID(), (int)M_Locator_ID);
    }
}

