/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.json.JSONAware;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.CloneableEventListener;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.PageableModel;
import org.zkoss.zul.Paging;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treefoot;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.event.PageSizeEvent;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.event.RenderEvent;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.ext.TreeSelectableModel;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.Utils;

public class Tree
extends MeshElement {
    private static final Logger log = LoggerFactory.getLogger(Tree.class);
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.Tree.onInitLaterPosted";
    private static final int DEFAULT_THROTTLE_MILLIS = 300;
    private transient Treecols _treecols;
    private transient Treefoot _treefoot;
    private transient Frozen _frozen;
    private transient Treechildren _treechildren;
    private transient Set<Treeitem> _selItems;
    private transient Treeitem _sel;
    private transient Collection<Component> _heads;
    private int _rows = 0;
    private String _name;
    private boolean _multiple;
    private boolean _checkmark;
    private boolean _vflex;
    private String _innerWidth = "100%";
    private transient TreeModel<Object> _model;
    private transient TreeitemRenderer<?> _renderer;
    private transient TreeDataListener _dataListener;
    private transient Paginal _pgi;
    private String _nonselTags;
    private transient Paging _paging;
    private EventListener<Event> _pgListener;
    private EventListener<Event> _pgImpListener;
    private EventListener<Event> _modelInitListener;
    private int _currentTop = 0;
    private int _currentLeft = 0;
    private int _anchorTop = 0;
    private int _anchorLeft = 0;
    private static final int INIT_LIMIT = -1;
    private int _preloadsz = 50;
    private transient LinkedList<Integer> _rodPagingIndex;
    private static final TreeitemRenderer _defRend;
    private static Boolean _ckDeselectOther;

    public Tree() {
        this.init();
    }

    private void init() {
        this._selItems = new LinkedHashSet<Treeitem>(4);
        this._heads = new AbstractCollection<Component>(){

            @Override
            public int size() {
                int sz = Tree.this.getChildren().size();
                if (Tree.this._treechildren != null) {
                    --sz;
                }
                if (Tree.this._treefoot != null) {
                    --sz;
                }
                if (Tree.this._paging != null) {
                    --sz;
                }
                if (Tree.this._frozen != null) {
                    --sz;
                }
                return sz;
            }

            @Override
            public Iterator<Component> iterator() {
                return new Iter();
            }
        };
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (oldpage == null) {
            this._modelInitListener = new ModelInitListener();
            this.addEventListener("onInitModel", (EventListener)this._modelInitListener);
            Events.postEvent((int)20000, (Event)new Event("onInitModel", (Component)this));
        }
        if (this._model != null) {
            this.postOnInitRender();
            if (this._dataListener != null) {
                this._model.removeTreeDataListener(this._dataListener);
                this._model.addTreeDataListener(this._dataListener);
            }
        }
        if (this._model instanceof PageableModel && this._pgListener != null) {
            ((PageableModel)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
            ((PageableModel)((Object)this._model)).addPagingEventListener((PagingListener)this._pgListener);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeTreeDataListener(this._dataListener);
        }
        if (this._model instanceof PageableModel && this._pgListener != null) {
            ((PageableModel)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
        }
    }

    void addVisibleItemCount(int count) {
        if (this.inPagingMold()) {
            int maxPageIndex;
            Pageable p;
            int actpg;
            Paginal pgi = this.getPaginal();
            int totalSize = pgi.getTotalSize() + count;
            if (count < 0 && this._model instanceof Pageable && (actpg = (p = (Pageable)((Object)this._model)).getActivePage()) > 0 && actpg > (maxPageIndex = p.getPageCount() - 1)) {
                p.setActivePage(maxPageIndex);
            }
            pgi.setTotalSize(totalSize);
            this.invalidate();
        }
    }

    Map<Treeitem, Boolean> getVisibleItems() {
        HashMap<Treeitem, Boolean> map = new HashMap<Treeitem, Boolean>();
        Paginal pgi = this.getPaginal();
        int pgsz = pgi.getPageSize();
        int ofs = pgi.getActivePage() * pgsz;
        int[] data = new int[]{pgsz, ofs, 0, 0, 0};
        this.getVisibleItemsDFS(this.getChildren(), map, data);
        return map;
    }

    private <T extends Component> boolean getVisibleItemsDFS(List<T> list, Map<Treeitem, Boolean> map, int[] data) {
        for (Component cmp : list) {
            if (cmp instanceof Treeitem) {
                if (data[4] >= data[0]) {
                    return false;
                }
                Treeitem item = (Treeitem)cmp;
                if (!item.isRealVisible()) continue;
                int count = item.isOpen() && item.getTreechildren() != null ? item.getTreechildren().getVisibleItemCount() : 0;
                boolean shoulbBeVisited = data[1] < data[2] + 1 + count;
                data[2] = data[2] + (shoulbBeVisited ? 1 : count + 1);
                data[3] = data[3] + (count + 1);
                if (!shoulbBeVisited) continue;
                if (data[1] < data[2]) {
                    data[4] = data[4] + 1;
                    map.put(item, Boolean.TRUE);
                }
                if (!item.isOpen()) continue;
                if (!this.getVisibleItemsDFS(item.getChildren(), map, data)) {
                    return false;
                }
                map.put(item, Boolean.TRUE);
                continue;
            }
            if (!(cmp instanceof Treechildren) || this.getVisibleItemsDFS(cmp.getChildren(), map, data)) continue;
            return false;
        }
        return true;
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this.setFixedLayout(true);
                this.resetPosition(true);
                if (this._model instanceof Pageable) {
                    Pageable m = (Pageable)((Object)this._model);
                    if (m.getPageSize() > 0) {
                        this._pgi.setPageSize(m.getPageSize());
                    } else {
                        m.setPageSize(this._pgi.getPageSize());
                    }
                    if (m.getActivePage() >= 0) {
                        this._pgi.setActivePage(m.getActivePage());
                    } else {
                        m.setActivePage(this._pgi.getActivePage());
                    }
                }
            }
        }
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this.getItemCount());
                    this.addPagingListener(this._pgi);
                    if (this._pgi instanceof Component) {
                        this.smartUpdate("paginal", this._pgi);
                    }
                }
                if (this._model instanceof Pageable) {
                    Pageable m = (Pageable)((Object)this._model);
                    m.setPageSize(this._pgi.getPageSize());
                    m.setActivePage(this._pgi.getActivePage());
                }
            }
        }
    }

    private void newInternalPaging() {
        MeshElement.InternalPaging paging = new MeshElement.InternalPaging(this);
        paging.setDetailed(true);
        paging.applyProperties();
        if (this._model instanceof Pageable && ((Pageable)((Object)this._model)).getPageSize() > 0) {
            paging.setPageSize(((Pageable)((Object)this._model)).getPageSize());
        }
        paging.setTotalSize(this.getVisibleItemCount());
        if (this._model instanceof Pageable && ((Pageable)((Object)this._model)).getActivePage() >= 0) {
            paging.setActivePage(((Pageable)((Object)this._model)).getActivePage());
        }
        paging.setParent((Component)this);
        if (this._pgi != null) {
            this.addPagingListener(this._pgi);
        }
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new PGListener();
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new PGImpListener();
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        if (this._model instanceof PageableModel) {
            ((PageableModel)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
        }
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public Paging getPagingChild() {
        return this._paging;
    }

    @Override
    public int getPageSize() {
        return this.inPagingMold() ? this.pgi().getPageSize() : 0;
    }

    @Override
    public void setPageSize(int pgsz) throws WrongValueException {
        if (pgsz < 0 || !this.inPagingMold()) {
            return;
        }
        this.pgi().setPageSize(pgsz);
        if (this._model instanceof Pageable) {
            ((Pageable)((Object)this._model)).setPageSize(pgsz);
        }
    }

    @Override
    protected Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    private int getVisibleItemCount() {
        return this._treechildren != null ? this._treechildren.getVisibleItemCount() : 0;
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public Treecols getTreecols() {
        return this._treecols;
    }

    public Treefoot getTreefoot() {
        return this._treefoot;
    }

    public Frozen getFrozen() {
        return this._frozen;
    }

    public Treechildren getTreechildren() {
        return this._treechildren;
    }

    public Collection<Component> getHeads() {
        return this._heads;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        this.checkBeforeSetRows();
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("rows", this._rows);
        }
    }

    public void setHeight(String height) {
        if (this._rows != 0) {
            throw new UiException("Not allowed to set height and rows at the same time");
        }
        super.setHeight(height);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    public void setNonselectableTags(String tags) {
        if (!Objects.equals((Object)this._nonselTags, (Object)tags)) {
            this._nonselTags = tags;
            this.smartUpdate("nonselectableTags", tags);
        }
    }

    public String getNonselectableTags() {
        return this._nonselTags;
    }

    public boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.smartUpdate("checkmark", checkmark);
        }
    }

    public boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            this.smartUpdate("vflex", this._vflex);
        }
    }

    public void setVflex(String flex) {
        if (this._rows != 0) {
            throw new UiException("Not allowed to set vflex and rows at the same time");
        }
        super.setVflex(flex);
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                Treeitem item = this.getSelectedItem();
                Iterator<Treeitem> it = this._selItems.iterator();
                while (it.hasNext()) {
                    Treeitem ti = it.next();
                    if (ti == item) continue;
                    ti.setSelectedDirectly(false);
                    it.remove();
                }
            }
            if (this._model != null) {
                ((TreeSelectableModel)((Object)this._model)).setMultiple(multiple);
            }
            this.smartUpdate("multiple", this._multiple);
        }
    }

    public void setActivePage(Treeitem item) {
        Paginal pgi;
        int pg;
        int index;
        if (item.isRealVisible() && item.getTree() == this && this.isVisible() && (index = this.getVisibleIndexOfItem(item)) != -1 && (pg = index / (pgi = this.getPaginal()).getPageSize()) != this.getActivePage()) {
            this.setActivePage(pg);
        }
    }

    @Override
    public void setActivePage(int pg) throws WrongValueException {
        if (this._model instanceof Pageable) {
            ((Pageable)((Object)this._model)).setActivePage(pg);
        }
        super.setActivePage(pg);
    }

    private int getVisibleIndexOfItem(Treeitem item) {
        int count = this.getVisibleIndexOfItem0(item, false);
        if (count <= 0) {
            return -1;
        }
        return --count;
    }

    private int getVisibleIndexOfItem0(Treeitem item, boolean inclusive) {
        Vector<Treeitem> items = new Vector<Treeitem>();
        int count = 0;
        items.add(item);
        while (!items.isEmpty()) {
            Component prev;
            item = (Treeitem)((Object)items.remove(0));
            if (item == null) continue;
            if (item.isRealVisible()) {
                ++count;
                Treechildren chdrn = item.getTreechildren();
                if (inclusive && item.isOpen() && chdrn != null) {
                    count += chdrn.getVisibleItemCount();
                }
            }
            if ((prev = item.getPreviousSibling()) != null && prev instanceof Treeitem) {
                items.add(0, (Treeitem)prev);
                inclusive = true;
                continue;
            }
            Component cmp = item.getParent().getParent();
            if (!(cmp instanceof Treeitem)) continue;
            Treeitem parent = (Treeitem)cmp;
            if (parent.isRealVisible()) {
                parent.setOpen(true);
                items.add(0, parent);
                inclusive = false;
                continue;
            }
            --count;
        }
        return count;
    }

    public void smartUpdate(String attr, Object value) {
        super.smartUpdate(attr, value);
    }

    public Collection<Treeitem> getItems() {
        if (this._treechildren != null) {
            return this._treechildren.getItems();
        }
        return Collections.emptyList();
    }

    public int getItemCount() {
        return this._treechildren != null ? this._treechildren.getItemCount() : 0;
    }

    public void selectItem(Treeitem item) {
        if (item == null) {
            this.clearSelection();
        } else {
            if (item.getTree() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            if (this._sel != item || this._multiple && this._selItems.size() > 1) {
                for (Treeitem ti : this._selItems) {
                    ti.setSelectedDirectly(false);
                }
                this._selItems.clear();
                this._sel = item;
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                this.smartUpdate("selectedItem", (Object)item);
            }
            if (this.inPagingMold()) {
                this.setActivePage(item);
            }
        }
    }

    public void addItemToSelection(Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this._sel == null) {
                    this._sel = this._selItems.iterator().next();
                }
                this.smartUpdateSelection();
            }
        }
    }

    public void removeItemFromSelection(Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                item.setSelectedDirectly(false);
                this._selItems.remove((Object)item);
                if (this._sel == item) {
                    this._sel = this._selItems.size() > 0 ? this._selItems.iterator().next() : null;
                }
                this.smartUpdateSelection();
            }
        }
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        for (Treeitem item : this._selItems) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(item.getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(Treeitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            for (Treeitem item : this._selItems) {
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._sel = null;
            this.smartUpdate("selectedItem", null);
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + this);
        }
        boolean first = true;
        for (Treeitem item : this.getItems()) {
            if (!item.isSelected()) {
                this._selItems.add(item);
                item.setSelectedDirectly(true);
            }
            if (!first) continue;
            this._sel = item;
            first = false;
        }
        this.smartUpdate("selectAll", true);
    }

    public Treeitem getSelectedItem() {
        return this._sel;
    }

    public void setSelectedItem(Treeitem item) {
        this.selectItem(item);
    }

    public Set<Treeitem> getSelectedItems() {
        return Collections.unmodifiableSet(this._selItems);
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public void clear() {
        if (this._treechildren != null) {
            this._treechildren.getChildren().clear();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-tree" : this._zclass;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof Treecols) {
            if (this._treecols != null && this._treecols != newChild) {
                throw new UiException("Only one treecols is allowed: " + this);
            }
        } else if (newChild instanceof Treefoot) {
            if (this._treefoot != null && this._treefoot != newChild) {
                throw new UiException("Only one treefoot is allowed: " + this);
            }
        } else if (newChild instanceof Frozen) {
            if (this._frozen != null && this._frozen != newChild) {
                throw new UiException("Only one frozen child is allowed: " + this);
            }
        } else if (newChild instanceof Treechildren) {
            if (this._treechildren != null && this._treechildren != newChild) {
                throw new UiException("Only one treechildren is allowed: " + this);
            }
        } else if (newChild instanceof Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported newChild: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Treecols) {
            if (super.insertBefore(newChild, refChild)) {
                this._treecols = (Treecols)newChild;
                return true;
            }
        } else if (newChild instanceof Treefoot) {
            refChild = this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this._treefoot = (Treefoot)newChild;
                return true;
            }
        } else if (newChild instanceof Frozen) {
            if (super.insertBefore(newChild, refChild)) {
                this._frozen = (Frozen)newChild;
                return true;
            }
        } else if (newChild instanceof Treechildren) {
            if (super.insertBefore(newChild, refChild)) {
                this._treechildren = (Treechildren)newChild;
                this.fixSelectedSet();
                return true;
            }
        } else if (newChild instanceof Paging) {
            refChild = null;
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    void onTreeitemAdded(Treeitem item) {
        this.fixNewChild(item);
        this.onTreechildrenAdded(item.getTreechildren());
    }

    void onTreeitemRemoved(Treeitem item) {
        boolean fixSel = false;
        if (item.isSelected()) {
            this._selItems.remove((Object)item);
            boolean bl = fixSel = this._sel == item;
            if (fixSel && !this._multiple) {
                this._sel = null;
            }
        }
        this.onTreechildrenRemoved(item.getTreechildren());
        if (fixSel) {
            this.fixSelected();
        }
    }

    void onTreechildrenAdded(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        for (Treeitem item : tchs.getItems()) {
            this.fixNewChild(item);
        }
    }

    private void fixNewChild(Treeitem item) {
        if (item.isSelected()) {
            if (this._sel != null && !this._multiple) {
                item.setSelectedDirectly(false);
                item.invalidate();
            } else {
                if (this._sel == null) {
                    this._sel = item;
                }
                this._selItems.add(item);
            }
        }
    }

    void onTreechildrenRemoved(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        boolean fixSel = false;
        for (Treeitem item : tchs.getItems()) {
            if (!item.isSelected()) continue;
            this._selItems.remove((Object)item);
            if (this._sel != item) continue;
            if (!this._multiple) {
                this._sel = null;
                return;
            }
            fixSel = true;
        }
        if (fixSel) {
            this.fixSelected();
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (child instanceof Treechildren) {
            this.addVisibleItemCount(((Treechildren)child).getVisibleItemCount());
        }
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Treecols) {
            this._treecols = null;
        } else if (child instanceof Treefoot) {
            this._treefoot = null;
        } else if (child instanceof Treechildren) {
            this._treechildren = null;
            this._selItems.clear();
            this._sel = null;
            this.addVisibleItemCount(-((Treechildren)child).getVisibleItemCount());
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        super.onChildRemoved(child);
    }

    private void fixSelectedSet() {
        this._sel = null;
        this._selItems.clear();
        for (Treeitem item : this.getItems()) {
            if (!item.isSelected()) continue;
            if (this._sel == null) {
                this._sel = item;
            } else if (!this._multiple) {
                item.setSelectedDirectly(false);
                continue;
            }
            this._selItems.add(item);
        }
    }

    private boolean fixSelected() {
        Treeitem sel = null;
        block0 : switch (this._selItems.size()) {
            case 1: {
                sel = this._selItems.iterator().next();
            }
            case 0: {
                break;
            }
            default: {
                for (Treeitem item : this.getItems()) {
                    if (!item.isSelected()) continue;
                    sel = item;
                    break block0;
                }
            }
        }
        if (sel != this._sel) {
            this._sel = sel;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        int cntSel = this._selItems.size();
        Tree clone = (Tree)super.clone();
        clone.init();
        clone._pgListener = null;
        clone._pgImpListener = null;
        int cnt = 0;
        if (this._treecols != null) {
            ++cnt;
        }
        if (this._treefoot != null) {
            ++cnt;
        }
        if (this._frozen != null) {
            ++cnt;
        }
        if (this._treechildren != null) {
            ++cnt;
        }
        if (this._paging != null) {
            ++cnt;
        }
        if (cnt > 0 || cntSel > 0) {
            clone.afterUnmarshal(cnt, cntSel);
        }
        if (clone._model != null) {
            TreeModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (TreeModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone.initDataListener();
            clone.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt, int cntSel) {
        if (cnt != 0) {
            for (Component child : this.getChildren()) {
                if (child instanceof Treecols) {
                    this._treecols = (Treecols)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (child instanceof Frozen) {
                    this._frozen = (Frozen)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (child instanceof Treefoot) {
                    this._treefoot = (Treefoot)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (child instanceof Treechildren) {
                    this._treechildren = (Treechildren)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (!(child instanceof Paging)) continue;
                this._paging = (Paging)child;
                this._pgi = this._paging;
                this.addPagingListener(this._pgi);
                if (--cnt != 0) continue;
                break;
            }
        }
        this._sel = null;
        this._selItems.clear();
        if (cntSel != 0) {
            for (Treeitem ti : this.getItems()) {
                if (!ti.isSelected()) continue;
                if (this._sel == null) {
                    this._sel = ti;
                }
                this._selItems.add(ti);
                if (--cntSel != 0) continue;
                break;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._renderer);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (TreeModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (TreeitemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        this.afterUnmarshal(-1, -1);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    private void onTreeDataChange(TreeDataEvent event) {
        int type = event.getType();
        int[] path = event.getPath();
        Component target = path != null ? this.getChildByPath(path) : null;
        switch (type) {
            case 3: {
                this.renderTree();
                if (this._model instanceof Sortable) {
                    Sortable smodel = (Sortable)Generics.cast(this._model);
                    List cols = Generics.cast((List)this._treecols.getChildren());
                    boolean found = false;
                    for (Treecol col : cols) {
                        if (found) {
                            col.setSortDirection("natural");
                            continue;
                        }
                        Comparator cmpr = (Comparator)Generics.cast(col.getSortAscending());
                        String dir = smodel.getSortDirection(cmpr);
                        boolean bl = found = !"natural".equals(dir);
                        if (!found) {
                            cmpr = (Comparator)Generics.cast(col.getSortDescending());
                            dir = smodel.getSortDirection(cmpr);
                            found = !"natural".equals(dir);
                        }
                        col.setSortDirection(dir);
                    }
                }
                return;
            }
            case 4: {
                if (target instanceof Treeitem) {
                    ((Treeitem)target).setSelected(((TreeSelectableModel)((Object)this._model)).isPathSelected(path));
                }
                return;
            }
            case 5: {
                if (this._model instanceof TreeOpenableModel && target instanceof Treeitem) {
                    ((Treeitem)target).setOpen(((TreeOpenableModel)((Object)this._model)).isPathOpened(path));
                }
                return;
            }
            case 6: {
                this.setMultiple(((TreeSelectableModel)((Object)this._model)).isMultiple());
                return;
            }
        }
        if (target != null) {
            Object node = this._model.getChild(path);
            int indexFrom = event.getIndexFrom();
            int indexTo = event.getIndexTo();
            if (!(type != 1 && type != 0 || this.isIgnoreSortWhenChanged())) {
                Tree.doSort(this);
            }
            switch (type) {
                case 1: {
                    for (int i = indexFrom; i <= indexTo; ++i) {
                        this.onTreeDataInsert(target, node, i);
                    }
                    break;
                }
                case 2: {
                    for (int i = indexTo; i >= indexFrom; --i) {
                        this.onTreeDataRemoved(target, node, i);
                    }
                    break;
                }
                case 0: {
                    for (int i = indexFrom; i <= indexTo; ++i) {
                        this.onTreeDataContentChange(target, node, i);
                    }
                    break;
                }
            }
        }
    }

    private static Treechildren treechildrenOf(Component parent) {
        Treechildren tc;
        Treechildren treechildren = tc = parent instanceof Tree ? ((Tree)parent).getTreechildren() : ((Treeitem)parent).getTreechildren();
        if (tc == null) {
            tc = new Treechildren();
            tc.setParent(parent);
        }
        return tc;
    }

    private void onTreeDataInsert(Component parent, Object node, int index) {
        Treeitem newTi = this.newUnloadedItem();
        Treechildren tc = Tree.treechildrenOf(parent);
        if (!(parent instanceof Treeitem) || ((Treeitem)parent).isLoaded()) {
            List siblings = tc.getChildren();
            tc.insertBefore((Component)newTi, (Component)(siblings.isEmpty() || index == siblings.size() ? null : (Treeitem)((Object)siblings.get(index))));
            this.renderChangedItem(newTi, this._model.getChild(node, index));
        }
    }

    private void onTreeDataRemoved(Component parent, Object node, int index) {
        Treechildren tc = Tree.treechildrenOf(parent);
        List items = tc.getChildren();
        if (items.size() > index) {
            ((Treeitem)((Object)items.get(index))).detach();
        } else if (!(parent instanceof Treeitem) || ((Treeitem)parent).isLoaded()) {
            tc.detach();
        }
    }

    private void onTreeDataContentChange(Component parent, Object node, int index) {
        List items = Tree.treechildrenOf(parent).getChildren();
        if (!items.isEmpty()) {
            this.renderChangedItem((Treeitem)((Object)items.get(index)), this._model.getChild(node, index));
        }
    }

    protected Component getChildByNode(Object node) {
        if (this._model == null) {
            throw new IllegalStateException("model required");
        }
        Object root = this._model.getRoot();
        if (Objects.equals((Object)root, (Object)node)) {
            return this;
        }
        return this.getChildByPath(this._model.getPath(node));
    }

    protected Component getChildByPath(int[] path) {
        if (path.length == 0) {
            return this;
        }
        Treeitem item = Tree.getChildTreeitem(this.getTreechildren(), path[0]);
        for (int j = 1; j < path.length && item != null; ++j) {
            item = Tree.getChildTreeitem(item.getTreechildren(), path[j]);
        }
        return item;
    }

    private static Treeitem getChildTreeitem(Treechildren tc, int i) {
        if (tc == null) {
            return null;
        }
        List cs = tc.getChildren();
        return i < 0 || i >= cs.size() ? null : (Treeitem)((Object)cs.get(i));
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new TreeDataListener(){

                @Override
                public void onChange(TreeDataEvent event) {
                    Tree.this.onTreeDataChange(event);
                }
            };
        }
        this._model.addTreeDataListener(this._dataListener);
    }

    public void setModel(TreeModel<?> model) {
        if (model != null) {
            if (!(model instanceof TreeSelectableModel)) {
                throw new UiException(model.getClass() + " must implement " + TreeSelectableModel.class);
            }
            if (this._model != model) {
                if (this._model != null) {
                    Treecols cols;
                    this._model.removeTreeDataListener(this._dataListener);
                    if (this._model instanceof PageableModel && this._pgListener != null) {
                        ((PageableModel)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
                    }
                    if (!this.isAutosort() && (cols = this.getTreecols()) != null) {
                        for (Component treecol : cols.getChildren()) {
                            ((Treecol)treecol).setSortDirection("natural");
                        }
                    }
                } else {
                    if (this._treechildren != null) {
                        this._treechildren.detach();
                    }
                    this.smartUpdate("model", true);
                }
                this.setModelDirectly(model);
                this.initDataListener();
                this.resetPosition(true);
                if (this.inPagingMold() && this._model instanceof Pageable) {
                    Pageable m = (Pageable)((Object)this._model);
                    if (m.getPageSize() <= 0) {
                        m.setPageSize(this._pgi.getPageSize());
                    }
                    if (m.getActivePage() < 0) {
                        m.setActivePage(this._pgi.getActivePage());
                    }
                }
            }
            Tree.doSort(this);
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeTreeDataListener(this._dataListener);
            if (this._model instanceof PageableModel && this._pgListener != null) {
                ((PageableModel)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
            }
            this._model = null;
            if (this._treechildren != null) {
                this._treechildren.detach();
            }
            this.smartUpdate("model", false);
            this.resetPosition(false);
        }
    }

    private final void setModelDirectly(TreeModel model) {
        this._model = model;
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.renderTree();
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public <T> TreeModel<T> getModel() {
        return this._model;
    }

    private static boolean doSort(Tree tree) {
        Treecols cols = tree.getTreecols();
        if (!tree.isAutosort() || cols == null) {
            return false;
        }
        for (Component c : cols.getChildren()) {
            Treecol hd = (Treecol)c;
            String dir = hd.getSortDirection();
            if ("natural".equals(dir)) continue;
            hd.doSort("ascending".equals(dir));
            return true;
        }
        return false;
    }

    public void setItemRenderer(TreeitemRenderer<?> renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                this.postOnInitRender();
            }
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((TreeitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public <T> TreeitemRenderer<T> getItemRenderer() {
        return this._renderer;
    }

    public void setTreeitemRenderer(TreeitemRenderer<?> renderer) {
        this.setItemRenderer(renderer);
    }

    public <T> TreeitemRenderer<T> getTreeitemRenderer() {
        return this.getItemRenderer();
    }

    private void renderTree() {
        if (this._treechildren == null) {
            Treechildren children = new Treechildren();
            children.setParent((Component)this);
        } else {
            this._treechildren.getChildren().clear();
        }
        if (this._model instanceof TreeSelectableModel) {
            this.setMultiple(((TreeSelectableModel)((Object)this._model)).isMultiple());
        }
        if (this._model instanceof PageableModel && this._pgListener != null) {
            ((PageableModel)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
            ((PageableModel)((Object)this._model)).addPagingEventListener((PagingListener)this._pgListener);
        }
        Renderer renderer = new Renderer();
        try {
            if (this._model != null) {
                this.renderChildren(renderer, this._treechildren, this._model.getRoot());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private int[] getPath0(Treechildren parent, int index) {
        LinkedList<Integer> path = new LinkedList<Integer>();
        path.add(index);
        Treechildren p = parent;
        while ((p = p.getParent()) instanceof Treeitem) {
            Component treechildren = p.getParent();
            if (treechildren == null) continue;
            path.add(0, treechildren.getChildren().indexOf((Object)p));
            p = treechildren;
        }
        int[] ipath = new int[path.size()];
        for (int j = 0; j < ipath.length; ++j) {
            ipath[j] = (Integer)path.get(j);
        }
        return ipath;
    }

    private void renderChildren0(Renderer renderer, Treechildren parent, Treeitem ti, Object childNode, int i) throws Throwable {
        Selectable smodel;
        SelectionControl control;
        Object model;
        boolean isLeaf;
        renderer.render(ti, childNode, i);
        Object v = ti.getAttribute("org.zkoss.zul.model.renderAs");
        if (v != null) {
            ti = (Treeitem)((Object)v);
            ti.setOpen(false);
        }
        ti.setRendered(true);
        int[] path = null;
        boolean bl = isLeaf = childNode != null && this._model.isLeaf(childNode);
        if (this._model instanceof TreeSelectableModel && !(model = (TreeSelectableModel)((Object)this._model)).isSelectionEmpty() && this.getSelectedCount() != model.getSelectionCount() && model.isPathSelected(path = this.getPath0(parent, i))) {
            this.addItemToSelection(ti);
        }
        if (this._model instanceof Selectable && (control = (smodel = (Selectable)((Object)this._model)).getSelectionControl()) != null) {
            ti.setSelectable(control.isSelectable(childNode));
        }
        if (this._model instanceof TreeOpenableModel && !(model = (TreeOpenableModel)((Object)this._model)).isOpenEmpty() && !isLeaf) {
            if (path == null) {
                path = this.getTreeitemPath((Component)this, (Component)ti);
            }
            ti.setOpen(model.isPathOpened(path));
        }
        if (!isLeaf && ti.getTreechildren() == null) {
            Treechildren tc = new Treechildren();
            tc.setParent((Component)ti);
            if (ti.isOpen()) {
                this.renderChildren(renderer, tc, childNode);
            }
        }
    }

    private void renderChildren(Renderer renderer, Treechildren parent, Object node) throws Throwable {
        int initSize = this.initRodSize();
        int j = this._model.getChildCount(node);
        for (int i = 0; i < j; ++i) {
            Treeitem ti = this.newUnloadedItem();
            ti.setParent((Component)parent);
            TreeOpenableModel model = (TreeOpenableModel)((Object)this._model);
            if (initSize < 0 || i < initSize || model.isPathOpened(this.toChildPath(node, i))) {
                Object childNode = this._model.getChild(node, i);
                this.renderChildren0(renderer, parent, ti, childNode, i);
                continue;
            }
            ti.appendChild((Component)new Treerow());
            ti.getTreerow().appendChild((Component)new Treecell());
        }
    }

    private int[] toChildPath(Object parentNode, int childIndex) {
        int[] parentPath = this._model.getPath(parentNode);
        int arrLength = parentPath.length;
        int[] path = new int[arrLength + 1];
        System.arraycopy(parentPath, 0, path, 0, arrLength);
        path[arrLength] = childIndex;
        return path;
    }

    private int preloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        int sz = size != null ? Integer.parseInt(size) : this._preloadsz;
        if ((sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.tree.preloadSize", sz, true)) < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private int maxRodPageSize() {
        if (WebApps.getFeature((String)"ee")) {
            return Utils.getIntAttribute((Component)this, "org.zkoss.zul.tree.maxRodPageSize", -1, true);
        }
        return -1;
    }

    private int initRodSize() {
        if (WebApps.getFeature((String)"ee")) {
            if (this.inPagingMold()) {
                return this.getPageSize();
            }
            return Utils.getIntAttribute((Component)this, "org.zkoss.zul.tree.initRodSize", -1, true);
        }
        return -1;
    }

    private int throttleMillis() {
        if (WebApps.getFeature((String)"ee")) {
            return Utils.getIntAttribute((Component)this, "org.zkoss.zul.tree.throttleMillis", 300, true);
        }
        return 300;
    }

    private Treeitem newUnloadedItem() {
        Treeitem ti = new Treeitem();
        ti.setOpen(false);
        return ti;
    }

    private TreeitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : _defRend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(Treeitem item) {
        if (this._model != null) {
            Renderer renderer = new Renderer();
            try {
                this.renderItem0(renderer, item);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(Treeitem item, Object node) {
        if (this._model != null) {
            Renderer renderer = new Renderer();
            try {
                this.renderItem0(renderer, item, node);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    private void renderItem0(Renderer renderer, Treeitem item) throws Throwable {
        this.renderItem0(renderer, item, this.getAssociatedNode(item, this));
    }

    private void renderItem0(Renderer renderer, Treeitem item, Object node) throws Throwable {
        Object v;
        if (item.isLoaded()) {
            return;
        }
        Treechildren tc = item.getTreechildren();
        if (this._model.isLeaf(node)) {
            if (tc != null) {
                tc.detach();
            }
        } else {
            if (tc != null) {
                tc.getChildren().clear();
            } else {
                tc = new Treechildren();
                tc.setParent((Component)item);
            }
            this.renderChildren(renderer, tc, node);
        }
        if ((v = item.getAttribute("org.zkoss.zul.model.renderAs")) != null) {
            item = (Treeitem)((Object)v);
            item.setOpen(false);
        }
        item.setLoaded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChangedItem(Treeitem item, Object node) {
        if (this._model != null) {
            Treechildren tc = item.getTreechildren();
            if (this._model.isLeaf(node)) {
                if (tc != null) {
                    tc.detach();
                }
            } else if (tc == null) {
                tc = new Treechildren();
                tc.setParent((Component)item);
            }
            Renderer renderer = new Renderer();
            try {
                renderer.renderChangedItem(item, node, item.getIndex());
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set<? extends Treeitem> items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            for (Treeitem treeitem : items) {
                this.renderItem0(renderer, treeitem);
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    protected Object getAssociatedNode(Treeitem ti, Tree t) {
        return this._model.getChild(this.getTreeitemPath((Component)t, (Component)ti));
    }

    int[] getTreeitemPath(Component root, Component lastNode) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        Component curNode = lastNode;
        while (!root.equals(curNode)) {
            if (curNode instanceof Treeitem) {
                l.add(0, new Integer(((Treeitem)curNode).getIndex()));
            }
            curNode = curNode.getParent();
        }
        Integer[] objs = l.toArray(new Integer[l.size()]);
        int[] path = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            path[i] = objs[i];
        }
        return path;
    }

    public Treeitem renderItemByNode(Object node) {
        return this.renderItemByPath(this._model.getPath(node));
    }

    public Treeitem renderItemByPath(int[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        Treeitem ti = null;
        List children = this.getTreechildren().getChildren();
        for (int i = 0; i < path.length; ++i) {
            if (path[i] < 0 || path[i] >= children.size()) {
                return null;
            }
            ti = (Treeitem)((Object)children.get(path[i]));
            if (i < path.length - 1) {
                TreeModel model = this.getModel();
                if (model instanceof TreeOpenableModel) {
                    ((TreeOpenableModel)((Object)model)).addOpenPath(Arrays.copyOf(path, i + 1));
                }
                ti.setOpen(true);
            }
            if (ti.getTreechildren() != null) {
                children = ti.getTreechildren().getChildren();
                continue;
            }
            if (i == path.length - 1) continue;
            return null;
        }
        return ti;
    }

    protected void redrawChildren(Writer out) throws IOException {
        super.redrawChildren(out);
        if (this.inPagingMold()) {
            this.removeAttribute("org.zkoss.zul.RenderedItemCount");
            this.removeAttribute("org.zkoss.zul.VisitedItemCount");
            this.removeAttribute("org.zkoss.zul.VisitedItemTotal");
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        int throttleMillis;
        int preloadSz;
        super.renderProperties(renderer);
        this.render(renderer, "name", this._name);
        if (this._rows > 0) {
            renderer.render("rows", this.getRows());
        }
        this.render(renderer, "multiple", this.isMultiple());
        this.render(renderer, "checkmark", this.isCheckmark());
        this.render(renderer, "vflex", this.isVflex());
        if (this._model != null) {
            Selectable smodel;
            SelectionControl control;
            this.render(renderer, "model", true);
            if (this._model instanceof Selectable && this.isMultiple() && (control = (smodel = (Selectable)((Object)this._model)).getSelectionControl()) != null) {
                renderer.render("$$selectAll", control.isSelectAll());
            }
        }
        if (this._nonselTags != null) {
            renderer.render("nonselectableTags", this._nonselTags);
        }
        if (this.isCheckmarkDeselectOther()) {
            renderer.render("_cdo", true);
        }
        if (!this.isRightSelect()) {
            renderer.render("rightSelect", false);
        }
        if (this.isSelectOnHighlightDisabled()) {
            renderer.render("selectOnHighlightDisabled", true);
        }
        if (this._pgi != null && this._pgi instanceof Component) {
            renderer.render("paginal", (Object)this._pgi);
            if (this._model == null) {
                renderer.render("_tree$noSelectAll", true);
            }
        }
        if (this._currentTop != 0) {
            renderer.render("_currentTop", this._currentTop);
        }
        if (this._currentLeft != 0) {
            renderer.render("_currentLeft", this._currentLeft);
        }
        if (this._anchorTop != 0) {
            renderer.render("_anchorTop", this._anchorTop);
        }
        if (this._anchorLeft != 0) {
            renderer.render("_anchorLeft", this._anchorLeft);
        }
        if ((preloadSz = this.preloadSize()) != this._preloadsz) {
            renderer.render("preloadSize", preloadSz);
        }
        if (this.initRodSize() == -1) {
            renderer.render("z$rod0", false);
        }
        if ((throttleMillis = this.throttleMillis()) != 300) {
            this.render(renderer, "throttleMillis", throttleMillis);
        }
    }

    private boolean isRightSelect() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.tree.rightSelect", true, true);
    }

    @Override
    protected boolean isAutohidePaging() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.tree.autohidePaging", true, true);
    }

    boolean isAutosort() {
        String attr = "org.zkoss.zul.tree.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val instanceof Boolean ? (Boolean)val : (val != null ? "true".equals(val) || "ignore.change".equals(val) : false);
    }

    private boolean isIgnoreSortWhenChanged() {
        String attr = "org.zkoss.zul.tree.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val == null ? true : "ignore.change".equals(val);
    }

    private boolean isCheckmarkDeselectOther() {
        if (_ckDeselectOther == null) {
            _ckDeselectOther = "true".equals(Library.getProperty((String)"org.zkoss.zul.tree.checkmarkDeselectOthers"));
        }
        return Utils.testAttribute((Component)this, "org.zkoss.zul.tree.checkmarkDeselectOthers", _ckDeselectOther, true);
    }

    protected boolean isSelectOnHighlightDisabled() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.tree.selectOnHighlight.disabled", false, true);
    }

    private <T> Set<T> collectUnselectedObjects(Set<T> previousSelection, Set<T> currentSelection) {
        LinkedHashSet<T> prevSeldItems;
        LinkedHashSet<Object> linkedHashSet = prevSeldItems = previousSelection != null ? new LinkedHashSet<T>(previousSelection) : new LinkedHashSet();
        if (currentSelection != null && prevSeldItems.size() > 0) {
            prevSeldItems.removeAll(currentSelection);
        }
        return prevSeldItems;
    }

    private void resetPosition(boolean shouldInvalidate) {
        this._currentTop = 0;
        this._currentLeft = 0;
        this._anchorTop = 0;
        this._anchorLeft = 0;
        if (shouldInvalidate) {
            this.invalidate();
        }
    }

    private boolean isAllRendered() {
        for (Treeitem item : this.getItems()) {
            if (item.isRendered() && item.isLoaded()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        boolean isSelModel = this._model instanceof Selectable;
        if (cmd.equals("onSelect")) {
            void var20_64;
            Set unselectedObjects;
            Set<Treeitem> unselectedItems;
            int to;
            int from;
            Desktop desktop = request.getDesktop();
            Map data = request.getData();
            List sitems = Generics.cast((List)((List)request.getData().get("items")));
            boolean selectAll = Boolean.parseBoolean(data.get("selectAll") + "");
            boolean paging = this.inPagingMold();
            LinkedHashSet<Treeitem> prevSeldItems = new LinkedHashSet<Treeitem>(this._selItems);
            Set curSeldItems = AuRequests.convertToItems((Desktop)desktop, (List)sitems);
            LinkedHashSet<Treeitem> realPrevSeldItems = new LinkedHashSet<Treeitem>(prevSeldItems);
            LinkedHashSet prevSeldObjects = this._model != null ? new LinkedHashSet(((Selectable)((Object)this._model)).getSelection()) : new LinkedHashSet();
            Selectable smodel = this._model != null ? (Selectable)((Object)this._model) : null;
            Paginal pgi = this.getPaginal();
            if (pgi != null) {
                int pgsz = pgi.getPageSize();
                from = pgi.getActivePage() * pgsz;
                to = from + pgsz;
            } else {
                from = 0;
                to = 0;
            }
            if (paging && (!this.isCheckmarkDeselectOther() || this.isCheckmarkDeselectOther() && selectAll)) {
                void var20_58;
                Object[] pgsz = realPrevSeldItems.toArray();
                int n = pgsz.length;
                boolean bl = false;
                while (var20_58 < n) {
                    Object item = pgsz[var20_58];
                    int index = ((Treeitem)((Object)item)).getIndex();
                    if (index >= to || index < from) {
                        realPrevSeldItems.remove(item);
                    }
                    ++var20_58;
                }
            }
            this.disableClientUpdate(true);
            try {
                if (AuRequests.getBoolean((Map)request.getData(), (String)"clearFirst")) {
                    this.clearSelection();
                    if (this._model instanceof TreeSelectableModel) {
                        ((TreeSelectableModel)((Object)this._model)).clearSelection();
                    }
                }
                if (!this._multiple || !paging && this.isAllRendered() && (curSeldItems == null || curSeldItems.size() <= 1)) {
                    Iterator item = curSeldItems != null && curSeldItems.size() > 0 ? (Treeitem)((Object)curSeldItems.iterator().next()) : null;
                    this.selectItem((Treeitem)((Object)item));
                    if (this._model instanceof TreeSelectableModel) {
                        TreeSelectableModel tsm = (TreeSelectableModel)((Object)this._model);
                        tsm.clearSelection();
                        if (item != null) {
                            tsm.addSelectionPath(this.getTreeitemPath((Component)this, (Component)item));
                        }
                    }
                } else {
                    for (Treeitem item : curSeldItems) {
                        if (this._selItems.contains((Object)item)) continue;
                        this.addItemToSelection(item);
                        if (!(this._model instanceof TreeSelectableModel)) continue;
                        ((TreeSelectableModel)((Object)this._model)).addSelectionPath(this.getTreeitemPath((Component)this, (Component)item));
                    }
                    for (Treeitem item : prevSeldItems) {
                        if (curSeldItems.contains((Object)item)) continue;
                        int n = this.getVisibleIndexOfItem(item);
                        if (paging && (n < from || n >= to)) continue;
                        this.removeItemFromSelection(item);
                        if (!(this._model instanceof TreeSelectableModel)) continue;
                        ((TreeSelectableModel)((Object)this._model)).removeSelectionPath(this.getTreeitemPath((Component)this, (Component)item));
                    }
                }
            }
            finally {
                this.disableClientUpdate(false);
            }
            if (this._model != null && paging) {
                prevSeldItems = null;
                unselectedItems = null;
            } else {
                unselectedItems = this.collectUnselectedObjects(realPrevSeldItems, curSeldItems);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            if (this._model == null) {
                prevSeldObjects = null;
                unselectedObjects = null;
            } else {
                Set set = smodel.getSelection();
                unselectedObjects = this.collectUnselectedObjects(prevSeldObjects, smodel.getSelection());
            }
            if (sitems == null || sitems.isEmpty() || this._model == null) {
                Object var20_63 = null;
            }
            SelectEvent evt = new SelectEvent("onSelect", (Component)this, curSeldItems, prevSeldItems, unselectedItems, (Set)var20_64, prevSeldObjects, unselectedObjects, desktop.getComponentByUuidIfAny((String)data.get("reference")), null, AuRequests.parseKeys((Map)data));
            Events.postEvent((Event)evt);
            return;
        }
        if (this.inPagingMold() && cmd.equals("onPageSize")) {
            int oldsize;
            Map data = request.getData();
            int size = AuRequests.getInt((Map)data, (String)"size", (int)(oldsize = this.getPageSize()));
            if (size == oldsize) return;
            int begin = this.getActivePage() * oldsize;
            int end = begin + oldsize;
            end = Math.min(this.getPaginal().getTotalSize(), end);
            Treeitem item = this.getSelectedItem();
            int sel = this.getVisibleIndexOfItem(item);
            if (sel < 0 || sel < begin || sel >= end) {
                sel = size > oldsize ? end - 1 : begin;
            }
            int newpg = sel / size;
            this.setPageSize(size);
            this.setActivePage(newpg);
            Events.postEvent((Event)new PageSizeEvent(cmd, (Component)this, this.pgi(), size));
            return;
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
            return;
        } else if (cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
            return;
        } else if (cmd.equals("onAnchorPos")) {
            Map data = request.getData();
            this._anchorTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._anchorLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
            return;
        } else if (cmd.equals("onCheckSelectAll") && isSelModel) {
            CheckEvent evt = CheckEvent.getCheckEvent((AuRequest)request);
            Selectable selectableModel = (Selectable)((Object)this._model);
            SelectionControl control = selectableModel.getSelectionControl();
            if (control == null) {
                throw new IllegalStateException("SelectionControl cannot be null, please implement SelectionControl interface for SelectablModel");
            }
            control.setSelectAll(evt.isChecked());
            Events.postEvent((Event)evt);
            return;
        } else if (cmd.equals("onUpdateSelectAll") && isSelModel) {
            Selectable selectableModel = (Selectable)((Object)this._model);
            final SelectionControl control = selectableModel.getSelectionControl();
            if (control == null) return;
            Clients.response((AuResponse)new AuInvoke((Component)this, "$doService", new Object[]{cmd, new JSONAware(){

                public String toJSONString() {
                    return String.valueOf(control.isSelectAll());
                }
            }}));
            return;
        } else if (cmd.equals("onRender")) {
            RenderEvent event = RenderEvent.getRenderEvent(request);
            Set items = event.getItems();
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            int preloadsz = this.preloadSize();
            Renderer renderer = new Renderer();
            try {
                Treeitem maxItem = null;
                int maxIndex = -1;
                ArrayList listItems = new ArrayList(items);
                for (int j = listItems.size() - 1; j >= 0; --j) {
                    Treeitem ti = (Treeitem)((Object)listItems.get(j));
                    if (ti.isRendered()) continue;
                    int i = ti.getIndex();
                    if (maxItem == null) {
                        maxItem = ti;
                        maxIndex = i;
                    }
                    if (i > maxIndex) {
                        maxItem = ti;
                        maxIndex = i;
                    }
                    ti.getChildren().clear();
                    Treechildren parent = (Treechildren)ti.getParent();
                    Object childNode = this.getAssociatedNode(ti, this);
                    this.renderChildren0(renderer, parent, ti, childNode, i);
                }
                if (preloadsz <= 0) return;
                while (maxItem != null && preloadsz-- > 0) {
                    if ((maxItem = (Treeitem)maxItem.getNextSibling()) == null || maxItem.isRendered()) continue;
                    maxItem.getChildren().clear();
                    Treechildren parent = (Treechildren)maxItem.getParent();
                    Object childNode = this.getAssociatedNode(maxItem, this);
                    this.renderChildren0(renderer, parent, maxItem, childNode, maxItem.getIndex());
                }
                return;
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
                return;
            }
            finally {
                renderer.doFinally();
            }
        } else {
            super.service(request, everError);
        }
    }

    @Override
    public int getActivePage() {
        if (this.hasAttribute(ATTR_ON_INIT_RENDER_POSTED) && this._model instanceof Pageable && ((Pageable)((Object)this._model)).getActivePage() >= 0) {
            return ((Pageable)((Object)this._model)).getActivePage();
        }
        return super.getActivePage();
    }

    public void onAfterRender() {
        if (this.inPagingMold() && this._model instanceof Pageable) {
            Pageable m = (Pageable)((Object)this._model);
            if (m.getPageSize() > 0) {
                this._pgi.setPageSize(m.getPageSize());
            } else {
                m.setPageSize(this._pgi.getPageSize());
            }
            this._pgi.setTotalSize(this.getVisibleItemCount());
            if (m.getActivePage() >= 0) {
                this._pgi.setActivePage(m.getActivePage());
            } else {
                m.setActivePage(this._pgi.getActivePage());
            }
        }
    }

    static {
        Tree.addClientEvent(Tree.class, (String)"onRender", (int)8195);
        Tree.addClientEvent(Tree.class, (String)"onInnerWidth", (int)8193);
        Tree.addClientEvent(Tree.class, (String)"onSelect", (int)8193);
        Tree.addClientEvent(Tree.class, (String)"onFocus", (int)8192);
        Tree.addClientEvent(Tree.class, (String)"onBlur", (int)8192);
        Tree.addClientEvent(Tree.class, (String)"onPageSize", (int)8195);
        Tree.addClientEvent(Tree.class, (String)"onScrollPos", (int)8193);
        Tree.addClientEvent(Tree.class, (String)"onAnchorPos", (int)8193);
        Tree.addClientEvent(Tree.class, (String)"onCheckSelectAll", (int)8193);
        _defRend = new TreeitemRenderer(){

            public void render(Treeitem ti, final Object node, final int index) {
                Tree tree = ti.getTree();
                Template tm = tree.getTemplate("model");
                if (tm == null) {
                    Treecell tc = new Treecell(Objects.toString((Object)node));
                    Treerow tr = null;
                    ti.setValue(node);
                    if (ti.getTreerow() == null) {
                        tr = new Treerow();
                        tr.setParent((Component)ti);
                    } else {
                        tr = ti.getTreerow();
                        tr.getChildren().clear();
                    }
                    tc.setParent((Component)tr);
                } else {
                    Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create(ti.getParent(), (Component)ti, new VariableResolver(){

                        public Object resolveVariable(String name) {
                            if ("each".equals(name)) {
                                return node;
                            }
                            if ("forEachStatus".equals(name)) {
                                return new ForEachStatus(){

                                    public ForEachStatus getPrevious() {
                                        return null;
                                    }

                                    public Object getEach() {
                                        return this.getCurrent();
                                    }

                                    public int getIndex() {
                                        return index;
                                    }

                                    public Integer getBegin() {
                                        return 0;
                                    }

                                    public Integer getEnd() {
                                        throw new UnsupportedOperationException("end not available");
                                    }

                                    public Object getCurrent() {
                                        return node;
                                    }

                                    public boolean isFirst() {
                                        return this.getCount() == 1;
                                    }

                                    public boolean isLast() {
                                        return this.getIndex() + 1 == this.getEnd();
                                    }

                                    public Integer getStep() {
                                        return null;
                                    }

                                    public int getCount() {
                                        return this.getIndex() + 1;
                                    }
                                };
                            }
                            return null;
                        }
                    }, null));
                    if (items.length != 1) {
                        throw new UiException("The model template must have exactly one item, not " + items.length);
                    }
                    Treeitem nti = (Treeitem)items[0];
                    if (nti.getValue() == null) {
                        nti.setValue(node);
                    }
                    ti.setAttribute("org.zkoss.zul.model.renderAs", (Object)nti);
                    ti.detach();
                }
            }
        };
    }

    private class Iter
    implements Iterator<Component> {
        private final ListIterator<? extends Component> _it;

        private Iter() {
            this._it = Tree.this.getChildren().listIterator();
        }

        @Override
        public boolean hasNext() {
            while (this._it.hasNext()) {
                Component o = this._it.next();
                if (!(o instanceof Treecols) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        @Override
        public Component next() {
            Component o;
            while (!((o = this._it.next()) instanceof Treecols) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Renderer
    implements Serializable {
        private final TreeitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Tree.this.getRealRenderer();
        }

        private void renderChangedItem(Treeitem item, Object node, int index) throws Throwable {
            block12: {
                if (!this._rendered && this._renderer instanceof RendererCtrl) {
                    ((RendererCtrl)((Object)this._renderer)).doTry();
                    this._ctrled = true;
                }
                try {
                    try {
                        if (item.getTreerow() != null) {
                            item.getTreerow().detach();
                        }
                        Treechildren tc = item.getTreechildren();
                        this._renderer.render(item, node, index);
                        Object newTreeitem = item.getAttribute("org.zkoss.zul.model.renderAs");
                        if (newTreeitem instanceof Treeitem) {
                            Treeitem newItem = (Treeitem)((Object)newTreeitem);
                            if (tc != null) {
                                newItem.appendChild((Component)tc);
                            }
                            if (Tree.this._model instanceof TreeOpenableModel) {
                                TreeOpenableModel model = (TreeOpenableModel)((Object)Tree.this._model);
                                newItem.setOpen(!model.isOpenEmpty() && model.isPathOpened(Tree.this.getPath0((Treechildren)newItem.getParent(), index)));
                                if (!item.isLoaded() && newItem.isOpen()) {
                                    Tree.this.renderChildren(this, tc, node);
                                }
                                newItem.setLoaded(item.isLoaded());
                                newItem.setRendered(item.isRendered());
                            }
                            break block12;
                        }
                        item.setRendered(true);
                    }
                    catch (AbstractMethodError ex) {
                        Method m = this._renderer.getClass().getMethod("render", Treeitem.class, Object.class);
                        m.setAccessible(true);
                        m.invoke((Object)this._renderer, new Object[]{item, node});
                    }
                }
                catch (Throwable ex) {
                    try {
                        item.setLabel(Exceptions.getMessage((Throwable)ex));
                    }
                    catch (Throwable t) {
                        log.error("", t);
                    }
                    throw ex;
                }
            }
            this._rendered = true;
        }

        private void render(Treeitem item, Object node, int index) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            try {
                try {
                    this._renderer.render(item, node, index);
                }
                catch (AbstractMethodError ex) {
                    Method m = this._renderer.getClass().getMethod("render", Treeitem.class, Object.class);
                    m.setAccessible(true);
                    m.invoke((Object)this._renderer, new Object[]{item, node});
                }
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }

    private class PGImpListener
    implements PagingListener {
        private PGImpListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(Event event) {
            if (Tree.this.inPagingMold() && event instanceof PagingEvent) {
                PagingEvent pe = (PagingEvent)event;
                if (Tree.this._model instanceof Pageable) {
                    ((Pageable)((Object)Tree.this._model)).setPageSize(pe.getPageable().getPageSize());
                    ((Pageable)((Object)Tree.this._model)).setActivePage(pe.getPageable().getActivePage());
                }
                if (WebApps.getFeature((String)"ee") && Tree.this.getModel() != null) {
                    if (Tree.this._rodPagingIndex == null) {
                        Tree.this._rodPagingIndex = new LinkedList();
                    }
                    int ap = pe.getActivePage();
                    int size = pe.getPageable().getPageSize();
                    int mps = Tree.this.maxRodPageSize();
                    if (mps >= 0 && !Tree.this._rodPagingIndex.contains(ap)) {
                        Tree.this._rodPagingIndex.add(ap);
                    }
                    if (mps >= 1 && mps < Tree.this._rodPagingIndex.size()) {
                        LinkedList<Integer> sortedIndex = new LinkedList<Integer>();
                        mps = Tree.this._rodPagingIndex.size() - mps;
                        while (mps-- > 0) {
                            sortedIndex.add((Integer)Tree.this._rodPagingIndex.removeFirst());
                        }
                        Collections.sort(sortedIndex);
                        int i = 0;
                        int start = (Integer)sortedIndex.removeFirst() * size;
                        int end = start + size;
                        for (Treeitem ti : new ArrayList<Treeitem>(Tree.this.getItems())) {
                            if (i < start) {
                                ++i;
                                continue;
                            }
                            if (i >= end) {
                                if (sortedIndex.isEmpty()) break;
                                start = (Integer)sortedIndex.removeFirst() * size;
                                end = start + size;
                            }
                            if (!ti.isOpen() && ti.getDesktop() != null) {
                                ti.getChildren().clear();
                                ti.setRendered(false);
                                ti.setLoaded(false);
                            }
                            ++i;
                        }
                    }
                    int start = ap * size;
                    int end = start + size;
                    int i = 0;
                    Renderer renderer = new Renderer();
                    try {
                        for (Treeitem ti : new ArrayList<Treeitem>(Tree.this.getItems())) {
                            if (i < start) {
                                ++i;
                                continue;
                            }
                            if (i >= end) {
                                break;
                            }
                            if (!ti.isRendered()) {
                                ti.getChildren().clear();
                                Treechildren parent = (Treechildren)ti.getParent();
                                int[] treeitemPath = Tree.this.getTreeitemPath((Component)Tree.this, (Component)ti);
                                Object childNode = Tree.this._model.getChild(treeitemPath);
                                Tree.this.renderChildren0(renderer, parent, ti, childNode, treeitemPath[treeitemPath.length - 1]);
                            }
                            ++i;
                        }
                    }
                    catch (Throwable ex) {
                        renderer.doCatch(ex);
                    }
                    finally {
                        renderer.doFinally();
                    }
                }
                Tree.this.invalidate();
            }
        }

        @Override
        public Object willClone(Component comp) {
            return null;
        }
    }

    private class PGListener
    implements PagingListener {
        private PGListener() {
        }

        @Override
        public void onEvent(Event event) {
            Tree.this._anchorTop = 0;
            Tree.this._anchorLeft = 0;
            if (event instanceof PagingEvent) {
                PagingEvent pe = (PagingEvent)event;
                int pgsz = pe.getPageable().getPageSize();
                int actpg = pe.getActivePage();
                if ("internalModelEvent".equals(pe.getName())) {
                    if (pgsz > 0) {
                        Tree.this._pgi.setPageSize(pgsz);
                    }
                    if (actpg >= 0) {
                        Tree.this._pgi.setActivePage(actpg);
                    }
                } else if (Tree.this._model instanceof Pageable) {
                    ((Pageable)((Object)Tree.this._model)).setActivePage(actpg);
                }
                Events.postEvent((Event)new PagingEvent(event.getName(), (Component)Tree.this, pe.getPageable(), actpg));
            }
        }

        @Override
        public Object willClone(Component comp) {
            return null;
        }
    }

    private class ModelInitListener
    implements SerializableEventListener<Event>,
    CloneableEventListener<Event> {
        private ModelInitListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (Tree.this._modelInitListener != null) {
                Tree.this.removeEventListener("onInitModel", Tree.this._modelInitListener);
                Tree.this._modelInitListener = null;
            }
            if (Tree.this._model != null && Tree.this.getAttribute(Tree.ATTR_ON_INIT_RENDER_POSTED) == null) {
                if (Tree.this._treechildren == null) {
                    Tree.this.renderTree();
                } else {
                    Tree.this.setModel(Tree.this._model);
                }
            }
        }

        public Object willClone(Component comp) {
            return null;
        }
    }
}

