/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.theme;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.web.theme.ThemeResolver;

public class CookieThemeResolver
implements ThemeResolver {
    private static final String THEME_COOKIE_KEY = "zktheme";

    public String getTheme(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        for (Cookie c : cookies) {
            String themeName;
            if (!THEME_COOKIE_KEY.equals(c.getName()) || (themeName = c.getValue()) == null) continue;
            return themeName;
        }
        return "";
    }

    public void setTheme(HttpServletRequest request, HttpServletResponse response, String themeName) {
        Cookie cookie = new Cookie(THEME_COOKIE_KEY, themeName);
        if (request.isSecure()) {
            cookie.setSecure(true);
        }
        cookie.setMaxAge(2592000);
        String cp = request.getContextPath();
        if (cp == null || "/".equals(cp)) {
            cp = "";
        }
        if (cp.length() == 0) {
            cp = "/";
        }
        cookie.setPath(cp);
        response.addCookie(cookie);
    }
}

