/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Generics;
import org.zkoss.util.UploadUtils;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;

public class UploadInfoService
implements AuService,
Serializable {
    private UploadInfoService() {
    }

    @Override
    public boolean service(AuRequest request, boolean everError) {
        if ("updateResult".equals(request.getCommand())) {
            Map<String, Object> data = request.getData();
            Desktop desktop = request.getDesktop();
            String uuid = (String)request.getData().get("wid");
            Component comp = desktop.getComponentByUuidIfAny(uuid);
            String sid = (String)request.getData().get("sid");
            if (comp == null) {
                Map percent = Generics.cast((Map)((Map)desktop.getAttribute("org.zkoss.zk.upload.percent")));
                Map size = Generics.cast((Map)((Map)desktop.getAttribute("org.zkoss.zk.upload.size")));
                String key = uuid + '_' + sid;
                if (percent != null) {
                    percent.remove(key);
                    size.put(key, "Upload Aborted");
                }
                return false;
            }
            List result = Generics.cast((List)((List)AuRequests.getUpdateResult(request)));
            Events.postEvent(new UploadEvent("onUpload", comp, UploadUtils.parseResult((List)result)));
            Map percent = (Map)desktop.getAttribute("org.zkoss.zk.upload.percent");
            Map size = (Map)desktop.getAttribute("org.zkoss.zk.upload.size");
            String key = uuid + '_' + sid;
            percent.remove(key);
            size.remove(key);
            return true;
        }
        return false;
    }

    public static class DesktopInit
    implements org.zkoss.zk.ui.util.DesktopInit {
        @Override
        public void init(Desktop desktop, Object request) {
            desktop.addListener(new UploadInfoService());
        }
    }
}

