/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuAppendChild;
import org.zkoss.zk.au.out.AuInsertAfter;
import org.zkoss.zk.au.out.AuInsertBefore;
import org.zkoss.zk.au.out.AuOuter;
import org.zkoss.zk.au.out.AuRemove;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.au.out.AuUuid;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.impl.VolatilePage;
import org.zkoss.zk.ui.sys.AbortingReason;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.StubComponent;
import org.zkoss.zk.ui.sys.Visualizer;

class UiVisualizer
implements Visualizer {
    private final UiVisualizer _parent;
    private final Execution _exec;
    private Set<Page> _pgInvalid;
    private Set<Page> _pgRemoved;
    private final Set<Component> _invalidated = new LinkedHashSet<Component>(32);
    private final Map<Component, Map<String, TimedValue>> _smartUpdated = new HashMap<Component, Map<String, TimedValue>>(64);
    private final Set<Component> _attached = new LinkedHashSet<Component>(32);
    private final Set<Component> _moved = new LinkedHashSet<Component>(32);
    private Set<Component> _updDisabled;
    private final Map<Component, Component> _detached = new LinkedHashMap<Component, Component>(32);
    private final Map<Component, String> _uuids = new HashMap<Component, String>(32);
    private Map<Component, String> _idChgd;
    private Map<Object, ResponseInfo> _responses;
    private Component _owner;
    private int _timed;
    private AbortingReason _aborting;
    private int _cntMultSU;
    private final boolean _1stau;
    private final boolean _recovering;
    private boolean _ending;
    private boolean _disabled;
    private static final Set<Component> EMPTY_CROP = new HashSet<Component>(1);

    public UiVisualizer(Execution exec, boolean asyncUpdate, boolean recovering) {
        this._exec = exec;
        this._parent = null;
        this._1stau = asyncUpdate;
        this._recovering = recovering;
    }

    public UiVisualizer(UiVisualizer parent, Execution exec) {
        this._exec = exec;
        this._parent = parent;
        this._1stau = parent._1stau;
        this._recovering = false;
    }

    @Override
    public final Execution getExecution() {
        return this._exec;
    }

    @Override
    public final boolean isEverAsyncUpdate() {
        return this._1stau;
    }

    @Override
    public final boolean addToFirstAsyncUpdate(List<AuResponse> responses) {
        if (!this._1stau) {
            return false;
        }
        UiVisualizer root = this.getRoot();
        for (AuResponse response : responses) {
            root.addResponse(null, response);
        }
        return true;
    }

    private UiVisualizer getRoot() {
        UiVisualizer uv = this;
        while (uv._parent != null) {
            uv = uv._parent;
        }
        return uv;
    }

    @Override
    public boolean isRecovering() {
        return this._recovering;
    }

    @Override
    public void disable() {
        this._disabled = true;
    }

    public boolean isInvalidated(Component comp) {
        return !this._exec.isAsyncUpdate(comp.getPage()) || this._invalidated.contains(comp) || this._attached.contains(comp) || this._moved.contains(comp) || this._detached.containsKey(comp);
    }

    public void addInvalidate(Page page) {
        if (this._recovering || this._disabled || page == null || page instanceof VolatilePage || !this._exec.isAsyncUpdate(page)) {
            return;
        }
        if (this._ending && this._pgRemoved != null && this._pgRemoved.contains(page)) {
            return;
        }
        if (this._pgInvalid == null) {
            this._pgInvalid = new LinkedHashSet<Page>(4);
        }
        this._pgInvalid.add(page);
    }

    public void addInvalidate(Component comp) {
        Page page = comp.getPage();
        if (this._recovering || this._disabled || page == null || page instanceof VolatilePage || !this._exec.isAsyncUpdate(page) || this.isCUDisabled(comp)) {
            return;
        }
        if (this._ending && this._pgRemoved != null && this._pgRemoved.contains(page)) {
            return;
        }
        if (this._ending) {
            throw new IllegalStateException("UI can't be modified in the rendering phase");
        }
        this.checkDesktop(comp);
        if (this._invalidated.add(comp)) {
            this._smartUpdated.remove(comp);
        }
    }

    private void checkDesktop(Component comp) {
        Desktop dt = comp.getDesktop();
        if (dt != null && dt != this._exec.getDesktop()) {
            throw new IllegalStateException("Access denied: component, " + comp + ", belongs to another desktop: " + dt);
        }
    }

    public final void addSmartUpdate(Component comp, String attr, Object value, boolean append) {
        this.addSmartUpdate0(comp, attr, value, append, 0);
    }

    public void addSmartUpdate(Component comp, String attr, Object value, int priority) {
        this.addSmartUpdate0(comp, attr, value, false, priority);
    }

    private void addSmartUpdate0(Component comp, String attr, Object value, boolean append, int priority) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (this._ending && (comp.getPage() == null || this._pgRemoved != null && this._pgRemoved.contains(comp.getPage()))) {
            return;
        }
        Map<String, TimedValue> respmap = this.getAttrRespMap(comp);
        if (respmap != null) {
            respmap.put(append ? attr + ":" + this._cntMultSU++ : attr, new TimedValue(this._timed++, comp, attr, value, priority));
        }
    }

    public boolean disableClientUpdate(Component comp, boolean disable) {
        boolean ret;
        if (disable) {
            if (this._updDisabled == null) {
                this._updDisabled = new HashSet<Component>(4);
            }
            return !this._updDisabled.add(comp);
        }
        boolean bl = ret = this._updDisabled != null && this._updDisabled.remove(comp);
        if (ret && this._updDisabled.isEmpty()) {
            this._updDisabled = null;
        }
        return ret;
    }

    private final boolean isCUDisabled(Component comp) {
        if (this._updDisabled != null) {
            while (comp != null) {
                if (this._updDisabled.contains(comp)) {
                    return true;
                }
                comp = comp.getParent();
            }
        }
        return false;
    }

    private Map<String, TimedValue> getAttrRespMap(Component comp) {
        Page page = comp.getPage();
        if (this._recovering || this._disabled || page == null || page instanceof VolatilePage || !this._exec.isAsyncUpdate(page) || this._invalidated.contains(comp) || this.isCUDisabled(comp)) {
            return null;
        }
        if (this._ending) {
            throw new IllegalStateException("UI can't be modified in the rendering phase");
        }
        this.checkDesktop(comp);
        Map<String, TimedValue> respmap = this._smartUpdated.get(comp);
        if (respmap == null) {
            respmap = new HashMap<String, TimedValue>();
            this._smartUpdated.put(comp, respmap);
        }
        return respmap;
    }

    public void addMoved(Component comp, Component oldparent, Page oldpg, Page newpg) {
        if (this._recovering || this._disabled || newpg == null && oldpg == null || newpg == null && (oldpg instanceof VolatilePage || !this._exec.isAsyncUpdate(oldpg)) || oldpg == null && (newpg instanceof VolatilePage || !this._exec.isAsyncUpdate(newpg)) || this.isCUDisabled(comp) || oldparent != null && this.isCUDisabled(oldparent)) {
            return;
        }
        if (this._ending) {
            throw new IllegalStateException("UI can't be modified in the rendering phase");
        }
        this.snapshotUuid(comp);
        if (oldpg == null && !this._moved.contains(comp) && !this._detached.containsKey(comp)) {
            this._attached.add(comp);
        } else if (newpg == null && !this._moved.contains(comp)) {
            if (!this._attached.remove(comp)) {
                this._detached.put(comp, oldparent);
            }
        } else {
            this._moved.add(comp);
            this._attached.remove(comp);
            this._detached.remove(comp);
        }
    }

    public void addUuidChanged(Component comp) {
        if (!(!this._exec.isAsyncUpdate(comp.getPage()) || this._idChgd != null && this._idChgd.containsKey(comp) || this.isCUDisabled(comp))) {
            if (this._idChgd == null) {
                this._idChgd = new LinkedHashMap<Component, String>(23);
            }
            this._idChgd.put(comp, comp.getUuid());
        }
    }

    public void addResponse(AuResponse response) {
        this.addResponse(response.getOverrideKey(), response);
    }

    public void addResponse(String key, AuResponse response) {
        this.addResponse(key, response, 0);
    }

    public void addResponse(String key, AuResponse response, int priority) {
        ResponseInfo ri;
        Object depends;
        if (response == null) {
            throw new IllegalArgumentException();
        }
        if (this._ending) {
            Component p;
            Object dps = response.getDepends();
            if (dps == null && this._owner == null) {
                return;
            }
            if (dps instanceof Page && this._pgRemoved != null && this._pgRemoved.contains((Page)dps)) {
                return;
            }
            if (dps instanceof Component && ((p = (Component)dps).getPage() == null || this._pgRemoved != null && this._pgRemoved.contains(p.getPage()))) {
                return;
            }
        }
        if ((depends = response.getDepends()) instanceof Component && this.isCUDisabled((Component)depends)) {
            return;
        }
        if (this._responses == null) {
            this._responses = new HashMap<Object, ResponseInfo>();
        }
        if ((ri = this._responses.get(depends)) == null) {
            ri = new ResponseInfo();
            this._responses.put(depends, ri);
        }
        TimedValue tval = new TimedValue(this._timed++, response, priority);
        if (key != null) {
            ri.values.put(key, tval);
        } else {
            ri.keyless.add(tval);
        }
    }

    private Map<Component, Set<? extends Component>> doCrop() {
        HashMap<Component, Set<? extends Component>> croppingInfos = new HashMap<Component, Set<? extends Component>>();
        this.crop(this._attached, croppingInfos, false);
        this.crop(this._smartUpdated.keySet(), croppingInfos, false);
        if (this._responses != null) {
            this.crop(this._responses.keySet(), croppingInfos, true);
        }
        this.crop(this._invalidated, croppingInfos, false);
        return croppingInfos;
    }

    private void crop(Set coll, Map<Component, Set<? extends Component>> croppingInfos, boolean bResponse) {
        Iterator it = coll.iterator();
        block0: while (it.hasNext()) {
            Component p;
            Object o = it.next();
            if (!(o instanceof Component)) continue;
            Component comp = (Component)o;
            Page page = comp.getPage();
            if (page == null || !this._exec.isAsyncUpdate(page)) {
                if (bResponse) continue;
                it.remove();
                continue;
            }
            Component c = comp;
            while ((p = c.getParent()) != null) {
                Set<? extends Component> avail = UiVisualizer.getAvailableAtClient(p, croppingInfos);
                if (avail != null) {
                    if (!avail.contains(c)) {
                        it.remove();
                        continue block0;
                    }
                    if ((p = ((Cropper)((ComponentCtrl)((Object)p)).getExtraCtrl()).getCropOwner()) == null) continue block0;
                }
                c = p;
            }
        }
    }

    private static Set<? extends Component> getAvailableAtClient(Component comp, Map<Component, Set<? extends Component>> croppingInfos) {
        Object xc = ((ComponentCtrl)((Object)comp)).getExtraCtrl();
        if (xc instanceof Cropper) {
            Set<? extends Component> crop = croppingInfos.get(comp);
            if (crop == EMPTY_CROP) {
                return null;
            }
            if (crop != null) {
                return crop;
            }
            crop = ((Cropper)xc).getAvailableAtClient();
            croppingInfos.put(comp, crop != null ? crop : EMPTY_CROP);
            return crop;
        }
        return null;
    }

    private void checkPageRemoved(Set<Component> removed) {
        boolean pgRemovedFound;
        Desktop desktop = this._exec.getDesktop();
        LinkedHashSet<Page> pages = null;
        for (Page page : desktop.getPages()) {
            Component owner = ((PageCtrl)((Object)page)).getOwner();
            if (owner == null) continue;
            Page ownerPage = owner.getPage();
            if (ownerPage == null || this._pgInvalid != null && this._pgInvalid.contains(ownerPage) || this.isAncestor(this._invalidated, owner, true) || this.isAncestor(this._attached, owner, true) || this.isAncestor(removed, owner, true)) {
                this.addPageRemoved(page);
                continue;
            }
            if (pages == null) {
                pages = new LinkedHashSet<Page>();
            }
            pages.add(page);
        }
        if (this._pgRemoved == null || pages == null) {
            return;
        }
        do {
            pgRemovedFound = false;
            Iterator it = pages.iterator();
            while (it.hasNext()) {
                Page page = (Page)it.next();
                Component owner = ((PageCtrl)((Object)page)).getOwner();
                if (!this._pgRemoved.contains(owner.getPage())) continue;
                it.remove();
                this.addPageRemoved(page);
                pgRemovedFound = true;
            }
        } while (pgRemovedFound);
    }

    private void addPageRemoved(Page page) {
        if (page == null || page instanceof VolatilePage) {
            return;
        }
        if (this._pgRemoved == null) {
            this._pgRemoved = new LinkedHashSet<Page>();
        }
        this._pgRemoved.add(page);
        if (this._pgInvalid != null) {
            this._pgInvalid.remove(page);
        }
    }

    private void clearInInvalidPage(Collection<Component> coll) {
        Iterator<Component> it = coll.iterator();
        while (it.hasNext()) {
            Component comp = it.next();
            Page page = comp.getPage();
            if (page == null || (this._pgRemoved == null || !this._pgRemoved.contains(page)) && (this._pgInvalid == null || !this._pgInvalid.contains(page))) continue;
            it.remove();
        }
    }

    private boolean isAncestor(Collection<Component> coll, Component comp, boolean includingEquals) {
        for (Component c : coll) {
            if (!includingEquals && c == comp || !Components.isAncestor(c, comp)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public List<AuResponse> getResponses(Collection<Component> renderedComps) throws IOException {
        AuResponse auResponse;
        this._ending = true;
        LinkedList<AuResponse> responses = new LinkedList<AuResponse>();
        if (this._idChgd != null) {
            for (Map.Entry<Component, String> me : this._idChgd.entrySet()) {
                Component component = me.getKey();
                if (this._attached.contains(component)) continue;
                responses.add(new AuUuid(component, me.getValue()));
            }
            this._idChgd = null;
        }
        this.doDetached();
        Set<Component> removed = this.doMoved(responses);
        this.removeRedundant();
        Map<Component, Set<? extends Component>> croppingInfos = this.doCrop();
        this.checkPageRemoved(removed);
        if (this._pgInvalid != null && this._pgInvalid.isEmpty()) {
            this._pgInvalid = null;
        }
        if (this._pgRemoved != null && this._pgRemoved.isEmpty()) {
            this._pgRemoved = null;
        }
        if (this._pgInvalid != null || this._pgRemoved != null) {
            this.clearInInvalidPage(this._invalidated);
            this.clearInInvalidPage(this._attached);
            this.clearInInvalidPage(this._smartUpdated.keySet());
        }
        if (this._pgRemoved != null) {
            Iterator<Component> dtctl = (DesktopCtrl)((Object)this._exec.getDesktop());
            for (Page page : this._pgRemoved) {
                dtctl.removePage(page);
            }
        }
        if (this._pgInvalid != null) {
            for (Page page : this._pgInvalid) {
                if (renderedComps != null) {
                    renderedComps.addAll(page.getRoots());
                }
                responses.add(new AuOuter(page, UiVisualizer.redraw(page)));
            }
        }
        for (Component component : this._invalidated) {
            if (renderedComps != null) {
                renderedComps.add(component);
            }
            responses.add(new AuOuter(component, UiVisualizer.redraw(component)));
        }
        LinkedList desktops = new LinkedList();
        Component[] componentArray = this._attached.toArray(new Component[this._attached.size()]);
        for (int j = 0; j < componentArray.length; ++j) {
            Page page;
            Component component = componentArray[j];
            if (component == null || (page = component.getPage()) == null || !this._exec.isAsyncUpdate(page)) continue;
            Component parent = component.getParent();
            LinkedHashSet<Component> newsibs = new LinkedHashSet<Component>(32);
            newsibs.add(component);
            desktops.add(newsibs);
            for (int k = j + 1; k < componentArray.length; ++k) {
                Component ck = componentArray[k];
                if (ck == null || ck.getParent() != parent) continue;
                newsibs.add(ck);
                componentArray[k] = null;
            }
        }
        for (Set set : desktops) {
            if (renderedComps != null) {
                renderedComps.addAll(set);
            }
            UiVisualizer.addResponsesForCreatedPerSiblings(responses, set, croppingInfos);
        }
        LinkedList<TimedValue> tvals = new LinkedList<TimedValue>();
        for (Map<String, TimedValue> map : this._smartUpdated.values()) {
            tvals.addAll(map.values());
        }
        if (this._responses != null) {
            for (Map.Entry<Object, ResponseInfo> entry : this._responses.entrySet()) {
                Component cd;
                Object depends = entry.getKey();
                if (depends instanceof Component && ((cd = (Component)depends).getPage() == null || this.isCUDisabled(cd))) continue;
                ResponseInfo ri = entry.getValue();
                tvals.addAll(ri.keyless);
                tvals.addAll(ri.values.values());
            }
        }
        if (!tvals.isEmpty()) {
            void var8_31;
            Object[] objectArray = tvals.toArray(new TimedValue[tvals.size()]);
            Arrays.sort(objectArray);
            boolean bl = false;
            while (var8_31 < objectArray.length) {
                responses.add(((TimedValue)objectArray[var8_31]).getResponse());
                ++var8_31;
            }
        }
        if (this._aborting != null && (auResponse = this._aborting.getResponse()) != null) {
            responses.add(auResponse);
        }
        this._invalidated.clear();
        this._smartUpdated.clear();
        this._attached.clear();
        this._uuids.clear();
        this._pgRemoved = null;
        this._pgInvalid = null;
        this._responses = null;
        return responses;
    }

    private void doDetached() {
        block0: for (Map.Entry<Component, Component> me : this._detached.entrySet()) {
            for (Component p = me.getValue(); p != null; p = p.getParent()) {
                if (this._moved.contains(p) || this._detached.containsKey(p) || this._invalidated.contains(p) || this._attached.contains(p)) continue block0;
            }
            this._moved.add(me.getKey());
        }
        this._detached.clear();
    }

    private Set<Component> doMoved(List<AuResponse> responses) {
        LinkedHashSet<Component> removed = new LinkedHashSet<Component>();
        for (Component comp : this._moved) {
            Page page = comp.getPage();
            if (page == null) {
                removed.add(comp);
                if (this._responses != null) {
                    this._responses.remove(comp);
                }
                this._invalidated.remove(comp);
                this._smartUpdated.remove(comp);
                responses.add(new AuRemove(this.uuid(comp)));
                continue;
            }
            if (this._exec.isAsyncUpdate(page)) {
                responses.add(new AuRemove(this.uuid(comp)));
            }
            this._attached.add(comp);
        }
        this._moved.clear();
        return removed;
    }

    private void snapshotUuid(Component comp) {
        if (!this._uuids.containsKey(comp)) {
            this._uuids.put(comp, comp.getUuid());
        }
    }

    private String uuid(Component comp) {
        String uuid = this._uuids.get(comp);
        return uuid != null ? uuid : comp.getUuid();
    }

    private static void addResponsesForCreatedPerSiblings(List<AuResponse> responses, Set<Component> newsibs, Map<Component, Set<? extends Component>> croppingInfos) throws IOException {
        List<Component> group;
        Set<? extends Component> sibs;
        Component comp = newsibs.iterator().next();
        Component parent = comp.getParent();
        Page page = comp.getPage();
        Set<? extends Component> set = sibs = parent != null ? UiVisualizer.getAvailableAtClient(parent, croppingInfos) : null;
        while ((group = UiVisualizer.nextGroupedSiblings(newsibs)) != null) {
            Component prv;
            Component first;
            List<String> contents = UiVisualizer.redrawComponents(group);
            Component last = group.get(group.size() - 1);
            Component nxt = last.getNextSibling();
            if (nxt == null || sibs != null && !sibs.contains(nxt)) {
                if (parent != null && !(parent instanceof Native) && !(parent instanceof StubComponent)) {
                    responses.add(new AuAppendChild(parent, contents));
                    continue;
                }
                first = group.get(0);
                prv = first.getPreviousSibling();
                if (!(prv == null || sibs != null && !sibs.contains(prv) || prv instanceof Native || prv instanceof StubComponent)) {
                    responses.add(new AuInsertAfter(prv, contents));
                    continue;
                }
                if (parent != null) {
                    throw new UiException("Adding child to native or stubs not allowed: " + parent);
                }
                responses.add(new AuAppendChild(page, contents));
                continue;
            }
            if (nxt instanceof Native || nxt instanceof StubComponent) {
                first = group.get(0);
                prv = first.getPreviousSibling();
                if (prv == null || sibs != null && !sibs.contains(prv)) {
                    throw new UiException("Inserting a component before a native one not allowed: " + nxt);
                }
                responses.add(new AuInsertAfter(prv, contents));
                continue;
            }
            responses.add(new AuInsertBefore(nxt, contents));
        }
    }

    private static List<Component> nextGroupedSiblings(Set<Component> newsibs) {
        if (newsibs.isEmpty()) {
            return null;
        }
        LinkedList<Component> group = new LinkedList<Component>();
        Iterator<Component> it = newsibs.iterator();
        Component first = it.next();
        it.remove();
        group.add(first);
        Component c = first;
        while ((c = c.getNextSibling()) != null && newsibs.remove(c)) {
            group.add(c);
        }
        c = first;
        while ((c = c.getPreviousSibling()) != null && newsibs.remove(c)) {
            group.add(0, c);
        }
        return group;
    }

    private void removeRedundant() {
        boolean removed;
        Component p;
        int initsz = (this._invalidated.size() + this._attached.size()) / 2 + 30;
        HashSet ins = new HashSet(initsz);
        HashSet outs = new HashSet(initsz);
        ArrayList<Component> ancs = new ArrayList<Component>(50);
        Iterator<Component> it = this._invalidated.iterator();
        while (it.hasNext()) {
            p = it.next();
            if (this._attached.contains(p)) {
                it.remove();
                continue;
            }
            removed = false;
            while ((p = p.getParent()) != null && !outs.contains(p)) {
                if (ins.contains(p) || this._invalidated.contains(p) || this._attached.contains(p)) {
                    it.remove();
                    removed = true;
                    break;
                }
                ancs.add(p);
            }
            if (removed) {
                ins.addAll(ancs);
            } else {
                outs.addAll(ancs);
            }
            ancs.clear();
        }
        it = this._attached.iterator();
        while (it.hasNext()) {
            p = it.next();
            removed = false;
            while ((p = p.getParent()) != null && !outs.contains(p)) {
                if (ins.contains(p) || this._invalidated.contains(p) || this._attached.contains(p)) {
                    it.remove();
                    removed = true;
                    break;
                }
                ancs.add(p);
            }
            if (removed) {
                ins.addAll(ancs);
            } else {
                outs.addAll(ancs);
            }
            ancs.clear();
        }
        it = this._smartUpdated.keySet().iterator();
        while (it.hasNext()) {
            removed = false;
            boolean first = true;
            for (p = it.next(); p != null && !outs.contains(p); p = p.getParent()) {
                if (ins.contains(p) || this._invalidated.contains(p) || this._attached.contains(p)) {
                    it.remove();
                    removed = true;
                    break;
                }
                if (first) {
                    first = false;
                    continue;
                }
                ancs.add(p);
            }
            if (removed) {
                ins.addAll(ancs);
            } else {
                outs.addAll(ancs);
            }
            ancs.clear();
        }
    }

    private static String redraw(Component comp) throws IOException {
        StringWriter out = new StringWriter(8192);
        ((ComponentCtrl)((Object)comp)).redraw(out);
        return out.toString();
    }

    private static String redraw(Page page) throws IOException {
        StringWriter out = new StringWriter(8192);
        ((PageCtrl)((Object)page)).redraw(out);
        return out.toString();
    }

    private static List<String> redrawComponents(Collection<Component> comps) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        for (Component comp : comps) {
            list.add(UiVisualizer.redraw(comp));
        }
        return list;
    }

    public Component setOwner(Component comp) {
        Component old = this._owner;
        if (comp != null && !(comp instanceof Includer)) {
            throw new IllegalArgumentException(comp.getClass() + " must implement " + Includer.class.getName());
        }
        this._owner = comp;
        return old;
    }

    @Override
    public Component getOwner() {
        return this._owner;
    }

    public void setAbortingReason(AbortingReason reason) {
        if (this._aborting != null && reason == null) {
            throw new IllegalStateException("Aborting reason is set and you cannot clear it");
        }
        this._aborting = reason;
    }

    public AbortingReason getAbortingReason() {
        return this._aborting;
    }

    public boolean isAborting() {
        return this._aborting != null && this._aborting.isAborting();
    }

    private static class ResponseInfo {
        private final List<TimedValue> keyless = new LinkedList<TimedValue>();
        private final Map<String, TimedValue> values = new HashMap<String, TimedValue>(4);

        private ResponseInfo() {
        }
    }

    private static class TimedValue
    implements Comparable {
        private final int _priority;
        private final int _timed;
        private final AuResponse _response;

        private TimedValue(int timed, AuResponse response, int priority) {
            this._timed = timed;
            this._response = response;
            this._priority = priority;
        }

        private TimedValue(int timed, Component comp, String name, Object value, int priority) {
            this._timed = timed;
            this._response = new AuSetAttribute(comp, name, value);
            this._priority = priority;
        }

        public String toString() {
            return 40 + this._timed + ":" + this._response + ')';
        }

        public int compareTo(Object o) {
            TimedValue tv = (TimedValue)o;
            return this._priority == tv._priority ? (this._timed > tv._timed ? 1 : (this._timed == tv._timed ? 0 : -1)) : (this._priority > tv._priority ? -1 : 1);
        }

        private AuResponse getResponse() {
            return this._response;
        }
    }
}

