/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.tablepartition.process;

import java.util.Properties;
import org.adempiere.base.annotation.Process;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_TablePartition;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class ChangePartitionStatus
extends SvrProcess {
    private int p_record_ID = 0;
    private MTable table = null;

    protected void prepare() {
        this.p_record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        ITablePartitionService service = DB.getDatabase().getTablePartitionService();
        if (service == null) {
            return "@Error@ " + Msg.getMsg((Properties)this.getCtx(), (String)"DBAdapterNoTablePartitionSupport");
        }
        if (this.p_record_ID <= 0) {
            return "@Error@ " + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory", (Object[])new Object[]{"Record ID"});
        }
        X_AD_TablePartition partition = new X_AD_TablePartition(Env.getCtx(), this.p_record_ID, this.get_TrxName());
        if (partition.get_ID() != this.p_record_ID) {
            return "@Error@ " + Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory", (Object[])new Object[]{"Record ID"});
        }
        this.table = new MTable(Env.getCtx(), partition.getAD_Table_ID(), this.get_TrxName());
        if (partition.isPartitionAttached()) {
            return this.detachPartition(partition, service);
        }
        return this.reattachPartition(partition, service);
    }

    private String reattachPartition(X_AD_TablePartition partition, ITablePartitionService service) {
        String partitionName = partition.getName();
        service.reattachPartition(this.table, partition, this.get_TrxName(), this.getProcessInfo());
        return Msg.getMsg((Properties)this.getCtx(), (String)"PartitionReAttachToTable", (Object[])new Object[]{partitionName, this.table.getTableName()});
    }

    private String detachPartition(X_AD_TablePartition partition, ITablePartitionService service) {
        String partitionName = partition.getName();
        service.detachPartition(this.table, partition, this.get_TrxName(), this.getProcessInfo());
        return Msg.getMsg((Properties)this.getCtx(), (String)"PartitionDetachFromTable", (Object[])new Object[]{partitionName, this.table.getTableName()});
    }

    protected void postProcess(boolean success) {
        ITablePartitionService service;
        if (success && (service = DB.getDatabase().getTablePartitionService()) != null) {
            service.runPostPartitionProcess(this.table, null, this.getProcessInfo());
        }
    }
}

