/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.impl.AbstractTag;
import org.zkoss.zhtml.impl.ContentTag;
import org.zkoss.zhtml.impl.TagRenderContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PageCtrl;

public class PageRenderer
implements org.zkoss.zk.ui.sys.PageRenderer {
    private static final String ATTR_RENDER_CONTEXT = "org.zkoss.zhtml.renderContext";

    public static TagRenderContext getTagRenderContext(Execution exec) {
        if (exec == null) {
            exec = Executions.getCurrent();
        }
        return exec != null ? (TagRenderContext)exec.getAttribute(ATTR_RENDER_CONTEXT) : null;
    }

    public void render(Page page, Writer out) throws IOException {
        Execution exec = Executions.getCurrent();
        String ctl = ExecutionsCtrl.getPageRedrawControl((Execution)exec);
        boolean au = exec.isAsyncUpdate(null);
        if (!au && (page.isComplete() || "complete".equals(ctl))) {
            this.renderComplete(exec, page, out);
            return;
        }
        boolean pageOnly = au;
        if (!pageOnly) {
            boolean bl = pageOnly = (exec.isIncluded() || "page".equals(ctl)) && !"desktop".equals(ctl);
        }
        if (pageOnly) {
            this.renderPage(exec, page, out, au);
        } else {
            exec.setAttribute("org.zkoss.zk.ui.page.redrawCtrl", (Object)"complete");
            this.renderComplete(exec, page, out);
        }
    }

    private static void write(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
        }
    }

    private static void writeln(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
            out.write(10);
        }
    }

    protected void renderPage(Execution exec, Page page, Writer out, boolean au) throws IOException {
        if (!au) {
            out.write(HtmlPageRenders.outLangStyleSheets((Execution)exec, null, null));
            out.write(HtmlPageRenders.outLangJavaScripts((Execution)exec, null, null));
        }
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)au);
        if (!au && ((PageCtrl)page).getOwner() == null) {
            PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        }
    }

    protected void renderComplete(Execution exec, Page page, Writer out) throws IOException {
        Object ret = PageRenderer.beforeRenderHtml(exec, page, out);
        Iterator it = page.getRoots().iterator();
        while (it.hasNext()) {
            ((ComponentCtrl)it.next()).redraw(out);
        }
        PageRenderer.afterRenderHtml(exec, page, out, ret);
    }

    public static Object beforeRenderHtml(Execution exec, Page page, Writer out) throws IOException {
        TagRenderContext rc = (TagRenderContext)PageRenderer.beforeRenderTag(exec);
        if (rc == null) {
            return null;
        }
        HtmlPageRenders.setContentType((Execution)exec, (Page)page);
        PageRenderer.write(out, HtmlPageRenders.outFirstLine((Execution)exec, (Page)page));
        PageRenderer.write(out, HtmlPageRenders.outDocType((Execution)exec, (Page)page));
        return rc;
    }

    public static void afterRenderHtml(Execution exec, Page page, Writer out, Object param) throws IOException {
        Object notice;
        if (param == null) {
            return;
        }
        TagRenderContext rc = (TagRenderContext)param;
        String rcs = rc.complete();
        WebApp webApp = exec.getDesktop().getWebApp();
        if (rcs.length() > 0) {
            notice = webApp.getAttribute("org.zkoss.zk.ui.client.notice");
            if (notice instanceof String) {
                rcs = rcs + '\n' + (String)notice;
            }
            if (out instanceof StringWriter) {
                StringBuffer buf = ((StringWriter)out).getBuffer();
                int j = buf.lastIndexOf("</body>");
                if (j < 0) {
                    j = buf.lastIndexOf("</html>");
                }
                if (j >= 0) {
                    buf.insert(j, rcs);
                } else {
                    buf.append(rcs);
                }
            } else {
                out.write(rcs);
            }
        }
        PageRenderer.write(out, HtmlPageRenders.outHeaderZkTags((Execution)exec, (Page)page));
        if (rcs.length() == 0 && (notice = webApp.getAttribute("org.zkoss.zk.ui.client.notice")) instanceof String) {
            out.write((String)notice);
        }
        PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        PageRenderer.afterRenderTag(exec, param);
    }

    public static Object beforeRenderTag(Execution exec) {
        TagRenderContext rc = PageRenderer.getTagRenderContext(exec);
        if (rc != null) {
            return null;
        }
        rc = new TagRenderContext();
        exec.setAttribute(ATTR_RENDER_CONTEXT, (Object)rc);
        return rc;
    }

    public static void afterRenderTag(Execution exec, Object param) {
        if (param != null) {
            exec.setAttribute(ATTR_RENDER_CONTEXT, null);
        }
    }

    public static String childrenToContent(Component comp) {
        Component c = comp.getFirstChild();
        if (c != null) {
            StringBuffer sb = new StringBuffer();
            while (c != null) {
                PageRenderer.childrenToContent(comp, c, sb);
                c = c.getNextSibling();
            }
            comp.getChildren().clear();
            return sb.toString();
        }
        return null;
    }

    private static final void childrenToContent(Component owner, Component comp, StringBuffer sb) {
        if (comp instanceof Text) {
            sb.append(((Text)comp).getValue());
            return;
        }
        if (!(comp instanceof AbstractTag)) {
            throw new UiException("Non-ZHTML components are not allowed, " + comp + ", for " + owner);
        }
        AbstractTag tag = (AbstractTag)comp;
        sb.append(tag.getPrologHalf(true));
        if (comp instanceof ContentTag) {
            sb.append(((ContentTag)comp).getContent());
        }
        for (Component c = tag.getFirstChild(); c != null; c = c.getNextSibling()) {
            PageRenderer.childrenToContent(owner, c, sb);
        }
        sb.append(tag.getEpilogHalf());
    }
}

