/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.validationtransformation;

import java.util.List;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.shared.faults.InvalidRepresentation;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTransformer;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTypeIdentifier;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTypeIdentifierResult;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceValidator;

public final class ValidAndTransformHelper {
    private ValidAndTransformHelper() {
    }

    public static void validationAndTransformation(List<ResourceTypeIdentifier> resourceTypeIdentifiers, Representation newRepresentation, Representation oldRepresentation) {
        if (resourceTypeIdentifiers != null && !resourceTypeIdentifiers.isEmpty()) {
            for (ResourceTypeIdentifier resourceIdentifier : resourceTypeIdentifiers) {
                ResourceTransformer transformer;
                ResourceValidator validator;
                ResourceTypeIdentifierResult valResult = resourceIdentifier.identify(newRepresentation);
                if (!valResult.isCorrect()) continue;
                if (valResult.getTransformer() != null && (validator = (transformer = valResult.getTransformer()).transform(newRepresentation, oldRepresentation)) != null && !validator.validate(newRepresentation, oldRepresentation)) {
                    throw new InvalidRepresentation();
                }
                return;
            }
            throw new InvalidRepresentation();
        }
    }
}

