/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndianOutput;

public final class EnhancedProtection {
    private static final BitField protObject = BitFieldFactory.getInstance(1);
    private static final BitField protScenarios = BitFieldFactory.getInstance(2);
    private static final BitField protFormatCells = BitFieldFactory.getInstance(4);
    private static final BitField protFormatColumns = BitFieldFactory.getInstance(8);
    private static final BitField protFormatRows = BitFieldFactory.getInstance(16);
    private static final BitField protInsertColumns = BitFieldFactory.getInstance(32);
    private static final BitField protInsertRows = BitFieldFactory.getInstance(64);
    private static final BitField protInsertHyperlinks = BitFieldFactory.getInstance(128);
    private static final BitField protDeleteColumns = BitFieldFactory.getInstance(256);
    private static final BitField protDeleteRows = BitFieldFactory.getInstance(512);
    private static final BitField protSelLockedCells = BitFieldFactory.getInstance(1024);
    private static final BitField protSort = BitFieldFactory.getInstance(2048);
    private static final BitField protAutoFilter = BitFieldFactory.getInstance(4096);
    private static final BitField protPivotTables = BitFieldFactory.getInstance(8192);
    private static final BitField protSelUnlockedCells = BitFieldFactory.getInstance(16384);
    int _bits;

    EnhancedProtection() {
        this.setSelectLockedCells(true);
        this.setSelectUnlockedCells(true);
        this.setObjects(true);
        this.setScenarios(true);
    }

    EnhancedProtection(RecordInputStream in) {
        this._bits = in.readInt();
    }

    public boolean isObjects() {
        return protObject.isSet(this._bits);
    }

    public boolean isScenarios() {
        return protScenarios.isSet(this._bits);
    }

    public boolean isFormatCells() {
        return protFormatCells.isSet(this._bits);
    }

    public boolean isFormatColumns() {
        return protFormatColumns.isSet(this._bits);
    }

    public boolean isFormatRows() {
        return protFormatRows.isSet(this._bits);
    }

    public boolean isInsertColumns() {
        return protInsertColumns.isSet(this._bits);
    }

    public boolean isInsertRows() {
        return protInsertRows.isSet(this._bits);
    }

    public boolean isInsertHyperlinks() {
        return protInsertHyperlinks.isSet(this._bits);
    }

    public boolean isDeleteColumns() {
        return protDeleteColumns.isSet(this._bits);
    }

    public boolean isDeleteRows() {
        return protDeleteRows.isSet(this._bits);
    }

    public boolean isSelectLockedCells() {
        return protSelLockedCells.isSet(this._bits);
    }

    public boolean isSort() {
        return protSort.isSet(this._bits);
    }

    public boolean isAutoFilter() {
        return protAutoFilter.isSet(this._bits);
    }

    public boolean isPivotTables() {
        return protPivotTables.isSet(this._bits);
    }

    public boolean isSelectUnlockedCells() {
        return protSelUnlockedCells.isSet(this._bits);
    }

    public void setObjects(boolean flag) {
        this._bits = protObject.setBoolean(this._bits, flag);
    }

    public void setScenarios(boolean flag) {
        this._bits = protScenarios.setBoolean(this._bits, flag);
    }

    public void setFormatCells(boolean flag) {
        this._bits = protFormatCells.setBoolean(this._bits, flag);
    }

    public void setFormatColumns(boolean flag) {
        this._bits = protFormatColumns.setBoolean(this._bits, flag);
    }

    public void setFormatRows(boolean flag) {
        this._bits = protFormatRows.setBoolean(this._bits, flag);
    }

    public void setInsertColumns(boolean flag) {
        this._bits = protInsertColumns.setBoolean(this._bits, flag);
    }

    public void setInsertRows(boolean flag) {
        this._bits = protInsertRows.setBoolean(this._bits, flag);
    }

    public void setInsertHyperlinks(boolean flag) {
        this._bits = protInsertHyperlinks.setBoolean(this._bits, flag);
    }

    public void setDeleteColumns(boolean flag) {
        this._bits = protDeleteColumns.setBoolean(this._bits, flag);
    }

    public void setDeleteRows(boolean flag) {
        this._bits = protDeleteRows.setBoolean(this._bits, flag);
    }

    public void setSelectLockedCells(boolean flag) {
        this._bits = protSelLockedCells.setBoolean(this._bits, flag);
    }

    public void setSort(boolean flag) {
        this._bits = protSort.setBoolean(this._bits, flag);
    }

    public void setAutoFilter(boolean flag) {
        this._bits = protAutoFilter.setBoolean(this._bits, flag);
    }

    public void setPivotTables(boolean flag) {
        this._bits = protPivotTables.setBoolean(this._bits, flag);
    }

    public void setSelectUnlockedCells(boolean flag) {
        this._bits = protSelUnlockedCells.setBoolean(this._bits, flag);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("    .bits       = ").append(Integer.toHexString(this._bits)).append("\n");
        buffer.append("       .protObjects         = ").append(this.isObjects()).append("\n");
        buffer.append("       .protScenarios       = ").append(this.isScenarios()).append("\n");
        buffer.append("       .protFormatCells     = ").append(this.isFormatCells()).append("\n");
        buffer.append("       .protFormatColumns   = ").append(this.isFormatColumns()).append("\n");
        buffer.append("       .protFormatRows      = ").append(this.isFormatRows()).append("\n");
        buffer.append("       .protInsertColumns   = ").append(this.isInsertColumns()).append("\n");
        buffer.append("       .protInsertRows      = ").append(this.isInsertRows()).append("\n");
        buffer.append("       .protInsertHyperlinks= ").append(this.isInsertHyperlinks()).append("\n");
        buffer.append("       .protDeleteColumns   = ").append(this.isDeleteColumns()).append("\n");
        buffer.append("       .protDeleteRows      = ").append(this.isDeleteRows()).append("\n");
        buffer.append("       .protSelLockedCells  = ").append(this.isSelectLockedCells()).append("\n");
        buffer.append("       .protSort            = ").append(this.isSort()).append("\n");
        buffer.append("       .protAutoFilter      = ").append(this.isAutoFilter()).append("\n");
        buffer.append("       .protPivotTables     = ").append(this.isPivotTables()).append("\n");
        buffer.append("       .protSelUnlockedCells= ").append(this.isSelectUnlockedCells()).append("\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeInt(this._bits);
    }
}

