/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.AreaRef;
import io.keikai.api.model.Sheet;
import io.keikai.ui.sys.UndoableAction;
import java.io.Serializable;

public class AggregatedAction
implements UndoableAction,
Serializable {
    private static final long serialVersionUID = 3941250543039868977L;
    private final UndoableAction[] _actions;
    private final String _label;

    public AggregatedAction(String label, UndoableAction[] actions) {
        this._label = label;
        this._actions = actions;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void doAction() {
        for (int i = 0; i < this._actions.length; ++i) {
            try {
                this._actions[i].doAction();
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isUndoable() {
        for (UndoableAction a : this._actions) {
            if (a.isUndoable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRedoable() {
        for (UndoableAction a : this._actions) {
            if (a.isRedoable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void undoAction() {
        for (int i = this._actions.length - 1; i >= 0; --i) {
            this._actions[i].undoAction();
        }
    }

    @Override
    public AreaRef getUndoSelection() {
        for (int i = 0; i < this._actions.length; ++i) {
            AreaRef sel = this._actions[i].getUndoSelection();
            if (sel == null) continue;
            return sel;
        }
        return null;
    }

    @Override
    public AreaRef getRedoSelection() {
        for (int i = this._actions.length - 1; i >= 0; --i) {
            AreaRef sel = this._actions[i].getRedoSelection();
            if (sel == null) continue;
            return sel;
        }
        return null;
    }

    @Override
    public Sheet getUndoSheet() {
        for (int i = 0; i < this._actions.length; ++i) {
            Sheet sheet = this._actions[i].getUndoSheet();
            if (sheet == null) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public Sheet getRedoSheet() {
        for (int i = this._actions.length - 1; i >= 0; --i) {
            Sheet sheet = this._actions[i].getRedoSheet();
            if (sheet == null) continue;
            return sheet;
        }
        return null;
    }
}

