/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.client.impl.protocol.codec.JetUploadJobMultipartCodec;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.submitjob.memberside.JobMultiPartParameterObject;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class UploadJobMultiPartOperation
extends Operation
implements IdentifiedDataSerializable {
    JobMultiPartParameterObject jobMultiPartParameterObject;

    public UploadJobMultiPartOperation() {
    }

    public UploadJobMultiPartOperation(JetUploadJobMultipartCodec.RequestParameters parameters) {
        this.jobMultiPartParameterObject = new JobMultiPartParameterObject();
        this.jobMultiPartParameterObject.setSessionId(parameters.sessionId);
        this.jobMultiPartParameterObject.setCurrentPartNumber(parameters.currentPartNumber);
        this.jobMultiPartParameterObject.setTotalPartNumber(parameters.totalPartNumber);
        this.jobMultiPartParameterObject.setPartData(parameters.partData);
        this.jobMultiPartParameterObject.setPartSize(parameters.partSize);
        this.jobMultiPartParameterObject.setSha256Hex(parameters.sha256Hex);
    }

    @Override
    public void run() {
        JetServiceBackend jetServiceBackend = this.getJetServiceBackend();
        jetServiceBackend.storeJobMultiPart(this.jobMultiPartParameterObject);
    }

    protected JetServiceBackend getJetServiceBackend() {
        Util.checkJetIsEnabled(this.getNodeEngine());
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not Jet Service";
        return (JetServiceBackend)this.getService();
    }

    @Override
    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 53;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.jobMultiPartParameterObject.getSessionId());
        out.writeInt(this.jobMultiPartParameterObject.getCurrentPartNumber());
        out.writeInt(this.jobMultiPartParameterObject.getTotalPartNumber());
        out.writeByteArray(this.jobMultiPartParameterObject.getPartData());
        out.writeInt(this.jobMultiPartParameterObject.getPartSize());
        out.writeString(this.jobMultiPartParameterObject.getSha256Hex());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.jobMultiPartParameterObject = new JobMultiPartParameterObject();
        this.jobMultiPartParameterObject.setSessionId(UUIDSerializationUtil.readUUID(in));
        this.jobMultiPartParameterObject.setCurrentPartNumber(in.readInt());
        this.jobMultiPartParameterObject.setTotalPartNumber(in.readInt());
        this.jobMultiPartParameterObject.setPartData(in.readByteArray());
        this.jobMultiPartParameterObject.setPartSize(in.readInt());
        this.jobMultiPartParameterObject.setSha256Hex(in.readString());
    }
}

