/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;

public final class StackTraceElementCodec {
    private static final int LINE_NUMBER_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private StackTraceElementCodec() {
    }

    public static void encode(ClientMessage clientMessage, StackTraceElement stackTraceElement) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, stackTraceElement.getLineNumber());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, stackTraceElement.getClassName());
        StringCodec.encode(clientMessage, stackTraceElement.getMethodName());
        CodecUtil.encodeNullable(clientMessage, stackTraceElement.getFileName(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static StackTraceElement decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int lineNumber = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String className = StringCodec.decode(iterator);
        String methodName = StringCodec.decode(iterator);
        String fileName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }
}

