/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

public enum ClientConfigSections {
    HAZELCAST_CLIENT("hazelcast-client", false),
    IMPORT("import", true),
    SECURITY("security", false),
    PROXY_FACTORIES("proxy-factories", false),
    PROPERTIES("properties", false),
    SERIALIZATION("serialization", false),
    NATIVE_MEMORY("native-memory", false),
    LISTENERS("listeners", false),
    NETWORK("network", false),
    LOAD_BALANCER("load-balancer", false),
    NEAR_CACHE("near-cache", true),
    QUERY_CACHES("query-caches", false),
    BACKUP_ACK_TO_CLIENT("backup-ack-to-client-enabled", false),
    INSTANCE_NAME("instance-name", false),
    CONNECTION_STRATEGY("connection-strategy", false),
    USER_CODE_DEPLOYMENT("user-code-deployment", false),
    FLAKE_ID_GENERATOR("flake-id-generator", true),
    RELIABLE_TOPIC("reliable-topic", true),
    LABELS("client-labels", false),
    CLUSTER_NAME("cluster-name", false),
    METRICS("metrics", false),
    INSTANCE_TRACKING("instance-tracking", false),
    SQL("sql", false),
    TPC("tpc", false);

    final boolean multipleOccurrence;
    private final String name;

    private ClientConfigSections(String name, boolean multipleOccurrence) {
        this.name = name;
        this.multipleOccurrence = multipleOccurrence;
    }

    public static boolean canOccurMultipleTimes(String name) {
        for (ClientConfigSections element : ClientConfigSections.values()) {
            if (!name.equals(element.name)) continue;
            return element.multipleOccurrence;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }
}

