/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.jndi;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.Importer;
import org.exolab.castor.dsml.jndi.JNDIConsumer;

public class JNDIImporter
extends Importer {
    private DirContext _ctx;

    public JNDIImporter(DirContext ctx) {
        this._ctx = ctx;
    }

    @Override
    protected Consumer createConsumer() {
        return new JNDIConsumer();
    }

    public void importEntry(SearchResult result, int policy) throws NamingException {
        if (result.getAttributes().size() == 0) {
            if ((policy & 1) != 0) {
                try {
                    this._ctx.lookup(result.getName());
                    this._ctx.unbind(result.getName());
                    this.notify(result.getName(), 3);
                }
                catch (NameNotFoundException except) {
                    this.notify(result.getName(), 0);
                }
            } else {
                this.notify(result.getName(), 0);
            }
        } else {
            try {
                Attribute attr;
                Attributes existing = this._ctx.getAttributes(result.getName());
                ArrayList<ModificationItem> modifs = new ArrayList<ModificationItem>();
                Attributes attrSet = result.getAttributes();
                NamingEnumeration<? extends Attribute> enumeration = attrSet.getAll();
                while (enumeration.hasMore()) {
                    attr = enumeration.next();
                    if (existing.get(attr.getID()) != null) {
                        if ((policy & 8) != 0) continue;
                        if (attr.size() > 0) {
                            modifs.add(new ModificationItem(2, attr));
                            continue;
                        }
                        modifs.add(new ModificationItem(3, attr));
                        continue;
                    }
                    if ((policy & 0x10) != 0 || attr.size() <= 0) continue;
                    modifs.add(new ModificationItem(1, attr));
                }
                if ((policy & 2) != 0) {
                    enumeration = existing.getAll();
                    while (enumeration.hasMore()) {
                        attr = enumeration.next();
                        if (attrSet.get(attr.getID()) != null) continue;
                        modifs.add(new ModificationItem(3, attr));
                    }
                }
                if (!modifs.isEmpty()) {
                    ModificationItem[] array = modifs.toArray(new ModificationItem[modifs.size()]);
                    this._ctx.modifyAttributes(result.getName(), array);
                    this.notify(result.getName(), 2);
                } else {
                    this.notify(result.getName(), 0);
                }
            }
            catch (NameNotFoundException except) {
                if ((policy & 4) == 0) {
                    this._ctx.bind(result.getName(), null, result.getAttributes());
                    this.notify(result.getName(), 1);
                }
                this.notify(result.getName(), 0);
            }
        }
    }

    public void importEntries(NamingEnumeration<SearchResult> results) throws NamingException {
        if (this.getImportDescriptor() == null) {
            this.setImportDescriptor(new ImportDescriptor());
        }
        while (results.hasMore()) {
            SearchResult result = results.next();
            this.importEntry(result, this.getImportDescriptor().getPolicy(result.getName()));
        }
    }

    @Override
    public void importEntries(Enumeration<SearchResult> results) throws ImportExportException {
        if (this.getImportDescriptor() == null) {
            this.setImportDescriptor(new ImportDescriptor());
        }
        try {
            while (results.hasMoreElements()) {
                SearchResult result = results.nextElement();
                this.importEntry(result, this.getImportDescriptor().getPolicy(result.getName()));
            }
        }
        catch (NamingException except) {
            throw new ImportExportException(except);
        }
    }
}

