/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.exp;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.adempiere.process.rpl.IExportProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MEXPProcessorType;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportHelper {
    private static final CLogger log = CLogger.getCLogger(ExportHelper.class);
    private Document outDocument = null;
    private SimpleDateFormat m_customDateFormat = null;
    private int m_AD_Client_ID = -1;
    MReplicationStrategy m_rplStrategy = null;

    public ExportHelper(MClient client, MReplicationStrategy rplStrategy) {
        this.m_AD_Client_ID = client.getAD_Client_ID();
        this.m_rplStrategy = rplStrategy;
    }

    public ExportHelper(Properties ctx, int AD_Client_ID) {
        this.m_AD_Client_ID = AD_Client_ID;
    }

    public String exportRecord(PO po, Integer ReplicationMode, String ReplicationType, Integer ReplicationEvent) throws Exception {
        MClient client = MClient.get((Properties)po.getCtx(), (int)this.m_AD_Client_ID);
        if (log.isLoggable(Level.INFO)) {
            log.info("Client = " + client.toString());
            log.info("po.getAD_Org_ID() = " + po.getAD_Org_ID());
            log.info("po.get_TrxName() = " + po.get_TrxName());
        }
        if (po.get_TrxName() == null || po.get_TrxName().equals("")) {
            po.set_TrxName("exportRecord");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Table = " + po.get_TableName());
        }
        if (po.get_KeyColumns().length < 1) {
            throw new Exception(Msg.getMsg((Properties)po.getCtx(), (String)"ExportNoneColumnKeyNotSupported"));
        }
        String version = "3.2.0";
        MEXPFormat exportFormat = null;
        exportFormat = MEXPFormat.getFormatByAD_Client_IDAD_Table_IDAndVersion((Properties)po.getCtx(), (int)this.m_AD_Client_ID, (int)po.get_Table_ID(), (String)version, (String)po.get_TrxName());
        if (log.isLoggable(Level.FINE)) {
            log.fine("exportFormat = " + String.valueOf(exportFormat));
        }
        if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
            MClient systemClient = MClient.get((Properties)po.getCtx(), (int)0);
            if (log.isLoggable(Level.INFO)) {
                log.info(systemClient.toString());
            }
            if ((exportFormat = MEXPFormat.getFormatByAD_Client_IDAD_Table_IDAndVersion((Properties)po.getCtx(), (int)0, (int)po.get_Table_ID(), (String)version, (String)po.get_TrxName())) == null || exportFormat.getEXP_Format_ID() == 0) {
                throw new Exception(Msg.getMsg((Properties)po.getCtx(), (String)"EXPFormatNotFound"));
            }
        }
        this.outDocument = this.createNewDocument();
        HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
        Element rootElement = this.outDocument.createElement(exportFormat.getValue());
        if (exportFormat.getDescription() != null && !"".equals(exportFormat.getDescription())) {
            rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
        }
        rootElement.setAttribute("AD_Client_Value", client.getValue());
        rootElement.setAttribute("Version", exportFormat.getVersion());
        rootElement.setAttribute("ReplicationMode", ReplicationMode.toString());
        rootElement.setAttribute("ReplicationType", ReplicationType);
        rootElement.setAttribute("ReplicationEvent", ReplicationEvent.toString());
        this.outDocument.appendChild(rootElement);
        this.generateExportFormat(rootElement, exportFormat, po, po.get_ID(), variableMap);
        MEXPProcessor mExportProcessor = null;
        mExportProcessor = new MEXPProcessor(po.getCtx(), this.m_rplStrategy.getEXP_Processor_ID(), po.get_TrxName());
        if (log.isLoggable(Level.FINE)) {
            log.fine("ExportProcessor = " + String.valueOf(mExportProcessor));
        }
        int EXP_ProcessorType_ID = 0;
        EXP_ProcessorType_ID = mExportProcessor.getEXP_Processor_Type_ID();
        MEXPProcessorType expProcessor_Type = new MEXPProcessorType(po.getCtx(), EXP_ProcessorType_ID, po.get_TrxName());
        String javaClass = expProcessor_Type.getJavaClass();
        try {
            Class<?> clazz = Class.forName(javaClass);
            IExportProcessor exportProcessor = (IExportProcessor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            exportProcessor.process(po.getCtx(), mExportProcessor, this.outDocument, Trx.get((String)po.get_TrxName(), (boolean)false));
        }
        catch (Exception e) {
            log.severe(e.toString());
            throw e;
        }
        return this.outDocument.toString();
    }

    public Document exportRecord(MEXPFormat exportFormat, String where, Integer ReplicationMode, String ReplicationType, Integer ReplicationEvent) throws Exception {
        MClient client = MClient.get((Properties)exportFormat.getCtx(), (int)this.m_AD_Client_ID);
        MTable table = MTable.get((Properties)exportFormat.getCtx(), (int)exportFormat.getAD_Table_ID());
        if (log.isLoggable(Level.INFO)) {
            log.info("Table = " + String.valueOf(table));
        }
        List records = new Query(exportFormat.getCtx(), table.getTableName(), exportFormat.getWhereClause(), exportFormat.get_TrxName()).setOnlyActiveRecords(true).list();
        for (PO po : records) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Client = " + client.toString());
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("po.getAD_Org_ID() = " + po.getAD_Org_ID());
                log.finest("po.get_TrxName() = " + po.get_TrxName());
            }
            if (po.get_TrxName() == null || po.get_TrxName().equals("")) {
                po.set_TrxName("exportRecord");
            }
            if (po.get_KeyColumns().length < 1) {
                throw new Exception(Msg.getMsg((Properties)po.getCtx(), (String)"ExportNoneColumnKeyNotSupported"));
            }
            this.outDocument = this.createNewDocument();
            HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
            Element rootElement = this.outDocument.createElement(exportFormat.getValue());
            if (exportFormat.getDescription() != null && !"".equals(exportFormat.getDescription())) {
                rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
            }
            rootElement.setAttribute("AD_Client_Value", client.getValue());
            rootElement.setAttribute("Version", exportFormat.getVersion());
            rootElement.setAttribute("ReplicationMode", ReplicationMode.toString());
            rootElement.setAttribute("ReplicationType", ReplicationType);
            rootElement.setAttribute("ReplicationEvent", ReplicationEvent.toString());
            this.outDocument.appendChild(rootElement);
            this.generateExportFormat(rootElement, exportFormat, po, po.get_ID(), variableMap);
        }
        return this.outDocument;
    }

    private void generateExportFormat(Element rootElement, MEXPFormat exportFormat, PO masterPO, int masterID, HashMap<String, Integer> variableMap) throws SQLException, Exception {
        List formatLines = exportFormat.getFormatLines();
        for (MEXPFormatLine formatLine : formatLines) {
            StringBuilder whereClause;
            MTable tableEmbedded;
            MEXPFormat embeddedFormat;
            if (formatLine.getType().equals("E")) {
                Text newText;
                Element newElement = this.outDocument.createElement(formatLine.getValue());
                if (log.isLoggable(Level.INFO)) {
                    log.info("Format Line Search key: " + formatLine.getValue());
                }
                if (formatLine.getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                MColumn column = MColumn.get((Properties)masterPO.getCtx(), (int)formatLine.getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    log.info("This is Virtual Column!");
                }
                Object value = masterPO.get_Value(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else {
                    formatLine.isMandatory();
                }
                if (column.getAD_Reference_ID() == 15) {
                    if (valueString != null) {
                        if (formatLine.getDateFormat() != null && !"".equals(formatLine.getDateFormat())) {
                            this.m_customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                            valueString = this.m_customDateFormat.format(Timestamp.valueOf(valueString));
                            newElement.setAttribute("DateFormat", this.m_customDateFormat.toPattern());
                        } else {
                            newElement.setAttribute("DateFormat", valueString);
                        }
                    }
                } else if (column.getAD_Reference_ID() == 16 && valueString != null) {
                    if (formatLine.getDateFormat() != null && !"".equals(formatLine.getDateFormat())) {
                        this.m_customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                        valueString = this.m_customDateFormat.format(Timestamp.valueOf(valueString));
                        newElement.setAttribute("DateFormat", this.m_customDateFormat.toPattern());
                    } else {
                        newElement.setAttribute("DateFormat", valueString);
                    }
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + String.valueOf(value));
                }
                if (valueString != null && !"".equals(valueString) && !"null".equals(valueString)) {
                    newText = this.outDocument.createTextNode(valueString);
                    newElement.appendChild(newText);
                    rootElement.appendChild(newElement);
                    continue;
                }
                if (!formatLine.isMandatory()) continue;
                newText = this.outDocument.createTextNode("");
                newElement.appendChild(newText);
                rootElement.appendChild(newElement);
                continue;
            }
            if (formatLine.getType().equals("A")) {
                if (formatLine.getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                MColumn column = MColumn.get((Properties)masterPO.getCtx(), (int)formatLine.getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    log.info("This is Virtual Column!");
                }
                Object value = masterPO.get_Value(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else if (formatLine.isMandatory()) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPFieldMandatory"));
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + String.valueOf(value));
                }
                if (valueString == null || "".equals(valueString) || "null".equals(valueString)) continue;
                rootElement.setAttribute(formatLine.getValue(), valueString);
                continue;
            }
            if (formatLine.getType().equals("M")) {
                int embeddedFormat_ID = formatLine.getEXP_EmbeddedFormat_ID();
                embeddedFormat = MEXPFormat.get((Properties)masterPO.getCtx(), (int)embeddedFormat_ID, (String)masterPO.get_TrxName());
                tableEmbedded = MTable.get((Properties)masterPO.getCtx(), (int)embeddedFormat.getAD_Table_ID());
                if (log.isLoggable(Level.INFO)) {
                    log.info("Table Embedded = " + String.valueOf(tableEmbedded));
                }
                whereClause = new StringBuilder(masterPO.get_KeyColumns()[0] + "=?");
                if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                    whereClause.append(" AND ").append(embeddedFormat.getWhereClause());
                }
                List instances = new Query(masterPO.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), masterPO.get_TrxName()).setClient_ID().setParameters(new Object[]{masterID}).list();
                for (PO instance : instances) {
                    Element embeddedElement = this.outDocument.createElement(formatLine.getValue());
                    if (formatLine.getDescription() != null && !"".equals(formatLine.getDescription())) {
                        embeddedElement.appendChild(this.outDocument.createComment(formatLine.getDescription()));
                    }
                    this.generateExportFormat(embeddedElement, embeddedFormat, instance, instance.get_ID(), variableMap);
                    rootElement.appendChild(embeddedElement);
                }
                continue;
            }
            if (formatLine.getType().equals("R")) {
                int embeddedFormat_ID = formatLine.getEXP_EmbeddedFormat_ID();
                embeddedFormat = MEXPFormat.get((Properties)masterPO.getCtx(), (int)embeddedFormat_ID, (String)masterPO.get_TrxName());
                tableEmbedded = MTable.get((Properties)masterPO.getCtx(), (int)embeddedFormat.getAD_Table_ID());
                if (log.isLoggable(Level.INFO)) {
                    log.info("Table Embedded = " + String.valueOf(tableEmbedded));
                }
                whereClause = new StringBuilder(tableEmbedded.getTableName() + "_ID =?");
                if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                    whereClause.append(" AND ").append(embeddedFormat.getWhereClause());
                }
                Object columnName = "";
                if (formatLine.getAD_Reference_ID() == 18 || formatLine.getAD_Reference_ID() == 30) {
                    MColumn column = MColumn.get((Properties)masterPO.getCtx(), (int)formatLine.getAD_Column_ID());
                    columnName = column.getColumnName();
                } else {
                    columnName = tableEmbedded.getTableName() + "_ID";
                }
                Object value = masterPO.get_Value((String)columnName);
                if (value == null) continue;
                List instances = new Query(masterPO.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), masterPO.get_TrxName()).setClient_ID().setParameters(new Object[]{value}).list();
                for (PO instance : instances) {
                    Element embeddedElement = this.outDocument.createElement(formatLine.getValue());
                    if (formatLine.getDescription() != null && !"".equals(formatLine.getDescription())) {
                        embeddedElement.appendChild(this.outDocument.createComment(formatLine.getDescription()));
                    }
                    this.generateExportFormat(embeddedElement, embeddedFormat, instance, instance.get_ID(), variableMap);
                    rootElement.appendChild(embeddedElement);
                }
                continue;
            }
            throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPUnknownLineType"));
        }
    }

    private void increaseVariable(HashMap<String, Integer> variableMap, String variableName) {
        if (variableName != null && !"".equals(variableName)) {
            Integer var = variableMap.get(variableName);
            if (var == null) {
                var = 0;
            }
            int intValue = var;
            variableMap.put(variableName, ++intValue);
        }
    }

    Document createNewDocument() throws ParserConfigurationException {
        Document result = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        result = documentBuilder.newDocument();
        return result;
    }
}

