/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVerticalType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.util.Units;
import org.zkoss.poi.xslf.model.TextBodyPropertyFetcher;
import org.zkoss.poi.xslf.usermodel.Placeholder;
import org.zkoss.poi.xslf.usermodel.RenderableShape;
import org.zkoss.poi.xslf.usermodel.TextAutofit;
import org.zkoss.poi.xslf.usermodel.TextDirection;
import org.zkoss.poi.xslf.usermodel.TextFragment;
import org.zkoss.poi.xslf.usermodel.VerticalAlignment;
import org.zkoss.poi.xslf.usermodel.XSLFShape;
import org.zkoss.poi.xslf.usermodel.XSLFSheet;
import org.zkoss.poi.xslf.usermodel.XSLFSimpleShape;
import org.zkoss.poi.xslf.usermodel.XSLFTextParagraph;

public abstract class XSLFTextShape
extends XSLFSimpleShape
implements Iterable<XSLFTextParagraph> {
    private final List<XSLFTextParagraph> _paragraphs = new ArrayList<XSLFTextParagraph>();
    private boolean _isTextBroken;

    XSLFTextShape(XmlObject shape, XSLFSheet sheet) {
        super(shape, sheet);
        CTTextBody txBody = this.getTextBody(false);
        if (txBody != null) {
            for (CTTextParagraph p : txBody.getPList()) {
                this._paragraphs.add(new XSLFTextParagraph(p, this));
            }
        }
    }

    @Override
    public Iterator<XSLFTextParagraph> iterator() {
        return this._paragraphs.iterator();
    }

    public String getText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextParagraph p : this._paragraphs) {
            if (out.length() > 0) {
                out.append('\n');
            }
            out.append(p.getText());
        }
        return out.toString();
    }

    public void clearText() {
        this._paragraphs.clear();
        CTTextBody txBody = this.getTextBody(true);
        txBody.setPArray(null);
    }

    public void setText(String text) {
        this.clearText();
        this.addNewTextParagraph().addNewTextRun().setText(text);
    }

    public List<XSLFTextParagraph> getTextParagraphs() {
        return this._paragraphs;
    }

    public XSLFTextParagraph addNewTextParagraph() {
        CTTextBody txBody = this.getTextBody(true);
        CTTextParagraph p = txBody.addNewP();
        XSLFTextParagraph paragraph = new XSLFTextParagraph(p, this);
        this._paragraphs.add(paragraph);
        return paragraph;
    }

    public void setVerticalAlignment(VerticalAlignment anchor) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (anchor == null) {
                if (bodyPr.isSetAnchor()) {
                    bodyPr.unsetAnchor();
                }
            } else {
                bodyPr.setAnchor(STTextAnchoringType.Enum.forInt((int)(anchor.ordinal() + 1)));
            }
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        TextBodyPropertyFetcher<VerticalAlignment> fetcher = new TextBodyPropertyFetcher<VerticalAlignment>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetAnchor()) {
                    int val = props.getAnchor().intValue();
                    this.setValue(VerticalAlignment.values()[val - 1]);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? VerticalAlignment.TOP : (VerticalAlignment)((Object)fetcher.getValue());
    }

    public void setTextDirection(TextDirection orientation) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (orientation == null) {
                if (bodyPr.isSetVert()) {
                    bodyPr.unsetVert();
                }
            } else {
                bodyPr.setVert(STTextVerticalType.Enum.forInt((int)(orientation.ordinal() + 1)));
            }
        }
    }

    public TextDirection getTextDirection() {
        STTextVerticalType.Enum val;
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null && (val = bodyPr.getVert()) != null) {
            return TextDirection.values()[val.intValue() - 1];
        }
        return TextDirection.HORIZONTAL;
    }

    public double getBottomInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetBIns()) {
                    double val = Units.toPoints(props.getBIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 3.6 : (Double)fetcher.getValue();
    }

    public double getLeftInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetLIns()) {
                    double val = Units.toPoints(props.getLIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 7.2 : (Double)fetcher.getValue();
    }

    public double getRightInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetRIns()) {
                    double val = Units.toPoints(props.getRIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 7.2 : (Double)fetcher.getValue();
    }

    public double getTopInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetTIns()) {
                    double val = Units.toPoints(props.getTIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 3.6 : (Double)fetcher.getValue();
    }

    public void setBottomInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetBIns();
            } else {
                bodyPr.setBIns(Units.toEMU(margin));
            }
        }
    }

    public void setLeftInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetLIns();
            } else {
                bodyPr.setLIns(Units.toEMU(margin));
            }
        }
    }

    public void setRightInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetRIns();
            } else {
                bodyPr.setRIns(Units.toEMU(margin));
            }
        }
    }

    public void setTopInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetTIns();
            } else {
                bodyPr.setTIns(Units.toEMU(margin));
            }
        }
    }

    public boolean getWordWrap() {
        TextBodyPropertyFetcher<Boolean> fetcher = new TextBodyPropertyFetcher<Boolean>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetWrap()) {
                    this.setValue(props.getWrap() == STTextWrappingType.SQUARE);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? true : (Boolean)fetcher.getValue();
    }

    public void setWordWrap(boolean wrap) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            bodyPr.setWrap(wrap ? STTextWrappingType.SQUARE : STTextWrappingType.NONE);
        }
    }

    public void setTextAutofit(TextAutofit value) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (bodyPr.isSetSpAutoFit()) {
                bodyPr.unsetSpAutoFit();
            }
            if (bodyPr.isSetNoAutofit()) {
                bodyPr.unsetNoAutofit();
            }
            if (bodyPr.isSetNormAutofit()) {
                bodyPr.unsetNormAutofit();
            }
            switch (value) {
                case NONE: {
                    bodyPr.addNewNoAutofit();
                    break;
                }
                case NORMAL: {
                    bodyPr.addNewNormAutofit();
                    break;
                }
                case SHAPE: {
                    bodyPr.addNewSpAutoFit();
                }
            }
        }
    }

    public TextAutofit getTextAutofit() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (bodyPr.isSetNoAutofit()) {
                return TextAutofit.NONE;
            }
            if (bodyPr.isSetNormAutofit()) {
                return TextAutofit.NORMAL;
            }
            if (bodyPr.isSetSpAutoFit()) {
                return TextAutofit.SHAPE;
            }
        }
        return TextAutofit.NORMAL;
    }

    protected CTTextBodyProperties getTextBodyPr() {
        CTTextBody textBody = this.getTextBody(false);
        return textBody == null ? null : textBody.getBodyPr();
    }

    protected abstract CTTextBody getTextBody(boolean var1);

    public Placeholder getTextType() {
        XmlObject[] obj = this.getXmlObject().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr/p:ph");
        if (obj.length == 1) {
            CTPlaceholder ph = (CTPlaceholder)obj[0];
            int val = ph.getType().intValue();
            return Placeholder.values()[val - 1];
        }
        return null;
    }

    public void setPlaceholder(Placeholder placeholder) {
        CTShape sh = (CTShape)this.getXmlObject();
        CTApplicationNonVisualDrawingProps nv = sh.getNvSpPr().getNvPr();
        if (placeholder == null) {
            if (nv.isSetPh()) {
                nv.unsetPh();
            }
        } else {
            nv.addNewPh().setType(STPlaceholderType.Enum.forInt((int)(placeholder.ordinal() + 1)));
        }
    }

    public double getTextHeight() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D graphics = img.createGraphics();
        this.breakText(graphics);
        return this.drawParagraphs(graphics, 0.0, 0.0);
    }

    public Rectangle2D resizeToFitText() {
        Rectangle2D anchor = this.getAnchor();
        if (anchor.getWidth() == 0.0) {
            throw new POIXMLException("Anchor of the shape was not set.");
        }
        double height = this.getTextHeight();
        anchor.setRect(anchor.getX(), anchor.getY(), anchor.getWidth(), height += 1.0);
        this.setAnchor(anchor);
        return anchor;
    }

    private void breakText(Graphics2D graphics) {
        if (!this._isTextBroken) {
            for (XSLFTextParagraph p : this._paragraphs) {
                p.breakText(graphics);
            }
            this._isTextBroken = true;
        }
    }

    @Override
    public void drawContent(Graphics2D graphics) {
        this.breakText(graphics);
        RenderableShape rShape = new RenderableShape(this);
        Rectangle2D anchor = rShape.getAnchor(graphics);
        double x = anchor.getX() + this.getLeftInset();
        double y = anchor.getY();
        double textHeight = this.getTextHeight();
        switch (this.getVerticalAlignment()) {
            case TOP: {
                y += this.getTopInset();
                break;
            }
            case BOTTOM: {
                y += anchor.getHeight() - textHeight - this.getBottomInset();
                break;
            }
            default: {
                double delta = anchor.getHeight() - textHeight - this.getTopInset() - this.getBottomInset();
                y += this.getTopInset() + delta / 2.0;
            }
        }
        this.drawParagraphs(graphics, x, y);
    }

    private double drawParagraphs(Graphics2D graphics, double x, double y) {
        double y0 = y;
        for (int i = 0; i < this._paragraphs.size(); ++i) {
            XSLFTextParagraph p = this._paragraphs.get(i);
            List<TextFragment> lines = p.getTextLines();
            if (i > 0 && lines.size() > 0) {
                double spaceBefore = p.getSpaceBefore();
                y = spaceBefore > 0.0 ? (y += spaceBefore * 0.01 * (double)lines.get(0).getHeight()) : (y += -spaceBefore);
            }
            y += p.draw(graphics, x, y);
            if (i >= this._paragraphs.size() - 1) continue;
            double spaceAfter = p.getSpaceAfter();
            if (spaceAfter > 0.0) {
                y += spaceAfter * 0.01 * (double)lines.get(lines.size() - 1).getHeight();
                continue;
            }
            y += -spaceAfter;
        }
        return y - y0;
    }

    @Override
    void copy(XSLFShape sh) {
        VerticalAlignment vAlign;
        double bottomInset;
        double topInset;
        double rightInset;
        double leftInset;
        super.copy(sh);
        XSLFTextShape tsh = (XSLFTextShape)sh;
        boolean srcWordWrap = tsh.getWordWrap();
        if (srcWordWrap != this.getWordWrap()) {
            this.setWordWrap(srcWordWrap);
        }
        if ((leftInset = tsh.getLeftInset()) != this.getLeftInset()) {
            this.setLeftInset(leftInset);
        }
        if ((rightInset = tsh.getRightInset()) != this.getRightInset()) {
            this.setRightInset(rightInset);
        }
        if ((topInset = tsh.getTopInset()) != this.getTopInset()) {
            this.setTopInset(topInset);
        }
        if ((bottomInset = tsh.getBottomInset()) != this.getBottomInset()) {
            this.setBottomInset(bottomInset);
        }
        if ((vAlign = tsh.getVerticalAlignment()) != this.getVerticalAlignment()) {
            this.setVerticalAlignment(vAlign);
        }
        List<XSLFTextParagraph> srcP = tsh.getTextParagraphs();
        List<XSLFTextParagraph> tgtP = this.getTextParagraphs();
        for (int i = 0; i < srcP.size(); ++i) {
            XSLFTextParagraph p1 = srcP.get(i);
            XSLFTextParagraph p2 = tgtP.get(i);
            p2.copy(p1);
        }
    }
}

