/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.usermodel.charts;

import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellValue;
import org.zkoss.poi.ss.usermodel.FormulaEvaluator;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public class DataSources {
    private static final POILogger logger = POILogFactory.getLogger(DataSources.class);

    private DataSources() {
    }

    public static <T> ChartDataSource<T> fromArray(T[] elements) {
        return new ArrayDataSource<T>(elements);
    }

    public static ChartDataSource<Number> fromNumericCellRange(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return new AbstractCellRangeDataSource<Number>(sheet, cellRangeAddress){

            @Override
            public Number getPointAt(int index) {
                CellValue cellValue = this.getCellValueAt(index);
                if (cellValue != null && cellValue.getCellType() == 0) {
                    return cellValue.getNumberValue();
                }
                if (cellValue != null && cellValue.getCellType() == 5) {
                    return 0.0;
                }
                return null;
            }

            @Override
            public boolean isNumeric() {
                return true;
            }
        };
    }

    public static ChartDataSource<String> fromStringCellRange(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return new AbstractCellRangeDataSource<String>(sheet, cellRangeAddress){

            @Override
            public String getPointAt(int index) {
                CellValue cellValue = this.getCellValueAt(index);
                if (cellValue != null && cellValue.getCellType() == 1) {
                    return cellValue.getStringValue();
                }
                if (cellValue != null && cellValue.getCellType() == 5) {
                    return cellValue.formatAsString();
                }
                return null;
            }

            @Override
            public boolean isNumeric() {
                return false;
            }
        };
    }

    public static ChartTextSource fromString(String element) {
        return new LiteralTextSource(element);
    }

    public static ChartTextSource fromCellRange(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return new CellRangeTextSource(sheet, cellRangeAddress);
    }

    private static class LiteralTextSource
    implements ChartTextSource {
        private String element;

        public LiteralTextSource(String element) {
            this.element = element;
        }

        @Override
        public boolean isReference() {
            return false;
        }

        public boolean isNumeric() {
            return false;
        }

        @Override
        public String getFormulaString() {
            throw new UnsupportedOperationException("Literal data source can not be expressed by reference.");
        }

        @Override
        public void renameSheet(String oldname, String newname) {
        }

        @Override
        public String getTextString() {
            return this.element;
        }
    }

    private static class CellRangeTextSource
    implements ChartTextSource {
        private final Sheet sheet;
        private final CellRangeAddress cellRangeAddress;
        private final int numOfCells;
        private FormulaEvaluator evaluator;

        protected CellRangeTextSource(Sheet sheet, CellRangeAddress cellRangeAddress) {
            this.sheet = sheet;
            this.cellRangeAddress = cellRangeAddress.copy();
            this.numOfCells = this.cellRangeAddress.getNumberOfCells();
            this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getFormulaString() {
            return this.cellRangeAddress.formatAsString(this.sheet.getSheetName(), true);
        }

        protected CellValue getCellValueAt(int index) {
            if (index < 0 || index >= this.numOfCells) {
                throw new IndexOutOfBoundsException("Index must be between 0 and " + (this.numOfCells - 1) + " (inclusive), given: " + index);
            }
            int firstRow = this.cellRangeAddress.getFirstRow();
            int firstCol = this.cellRangeAddress.getFirstColumn();
            int lastCol = this.cellRangeAddress.getLastColumn();
            int width = lastCol - firstCol + 1;
            int rowIndex = firstRow + index / width;
            int cellIndex = firstCol + index % width;
            Row row = this.sheet.getRow(rowIndex);
            Cell cell = row.getCell(cellIndex);
            try {
                return row == null ? null : this.evaluator.evaluate(cell);
            }
            catch (RuntimeException e) {
                logger.log(5, e);
                return CellValue.getError(cell.getErrorCellValue());
            }
        }

        @Override
        public void renameSheet(String oldname, String newname) {
        }

        @Override
        public String getTextString() {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.numOfCells; ++j) {
                CellValue cellValue = this.getCellValueAt(j);
                if (cellValue == null) continue;
                sb.append(cellValue.getStringValue());
            }
            return sb.length() == 0 ? null : sb.toString();
        }
    }

    private static abstract class AbstractCellRangeDataSource<T>
    implements ChartDataSource<T> {
        private final Sheet sheet;
        private final CellRangeAddress cellRangeAddress;
        private final int numOfCells;
        private FormulaEvaluator evaluator;

        protected AbstractCellRangeDataSource(Sheet sheet, CellRangeAddress cellRangeAddress) {
            this.sheet = sheet;
            this.cellRangeAddress = cellRangeAddress.copy();
            this.numOfCells = this.cellRangeAddress.getNumberOfCells();
            this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }

        @Override
        public int getPointCount() {
            return this.numOfCells;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getFormulaString() {
            return this.cellRangeAddress.formatAsString(this.sheet.getSheetName(), true);
        }

        protected CellValue getCellValueAt(int index) {
            if (index < 0 || index >= this.numOfCells) {
                throw new IndexOutOfBoundsException("Index must be between 0 and " + (this.numOfCells - 1) + " (inclusive), given: " + index);
            }
            int firstRow = this.cellRangeAddress.getFirstRow();
            int firstCol = this.cellRangeAddress.getFirstColumn();
            int lastCol = this.cellRangeAddress.getLastColumn();
            int width = lastCol - firstCol + 1;
            int rowIndex = firstRow + index / width;
            int cellIndex = firstCol + index % width;
            Row row = this.sheet.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            Cell cell = row.getCell(cellIndex);
            if (cell == null) {
                return null;
            }
            try {
                return this.evaluator.evaluate(cell);
            }
            catch (RuntimeException e) {
                logger.log(5, e);
                return CellValue.getError(cell.getErrorCellValue());
            }
        }

        @Override
        public void renameSheet(String oldname, String newname) {
        }
    }

    public static class ArrayDataSource<T>
    implements ChartDataSource<T> {
        private final T[] elements;

        public ArrayDataSource(T[] elements) {
            this.elements = elements;
        }

        @Override
        public int getPointCount() {
            return this.elements.length;
        }

        @Override
        public T getPointAt(int index) {
            return this.elements[index];
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean isNumeric() {
            Class<?> arrayComponentType = this.elements.getClass().getComponentType();
            return Number.class.isAssignableFrom(arrayComponentType);
        }

        @Override
        public String getFormulaString() {
            throw new UnsupportedOperationException("Literal data source can not be expressed by reference.");
        }

        @Override
        public void renameSheet(String oldname, String newname) {
        }
    }
}

