/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.EnhancedProtection;
import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class FeatHdrRecord
extends StandardRecord {
    public static final int SHAREDFEATURES_ISFPROTECTION = 2;
    public static final int SHAREDFEATURES_ISFFEC2 = 3;
    public static final int SHAREDFEATURES_ISFFACTOID = 4;
    public static final int SHAREDFEATURES_ISFLIST = 5;
    public static final short sid = 2151;
    private FtrHeader futureHeader;
    private int isf_sharedFeatureType;
    private byte reserved = 1;
    private int cbHdrData;
    private byte[] rgbHdrData;
    private Object shared;

    public FeatHdrRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2151);
    }

    @Override
    public short getSid() {
        return 2151;
    }

    public FeatHdrRecord(int sharedFutureType) {
        this();
        this.isf_sharedFeatureType = sharedFutureType;
        switch (this.isf_sharedFeatureType) {
            case 2: {
                this.shared = new EnhancedProtection();
                this.cbHdrData = -1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown shardFutureType: " + sharedFutureType);
            }
        }
    }

    public FeatHdrRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.isf_sharedFeatureType = in.readShort();
        this.reserved = in.readByte();
        this.cbHdrData = in.readInt();
        switch (this.isf_sharedFeatureType) {
            case 2: {
                this.shared = this.cbHdrData == -1 ? new EnhancedProtection(in) : new EnhancedProtection();
                break;
            }
            default: {
                this.rgbHdrData = in.readRemainder();
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FEATURE HEADER]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .isf        = ").append(Integer.toHexString(this.isf_sharedFeatureType)).append("\n");
        buffer.append("    .reserved   = ").append(HexDump.byteToHex(this.reserved)).append("\n");
        buffer.append("    .cbHdrData  = ").append(Integer.toHexString(this.cbHdrData)).append("\n");
        switch (this.isf_sharedFeatureType) {
            case 2: {
                buffer.append(this.shared.toString());
                break;
            }
            default: {
                buffer.append("  rgbHdrData=").append(HexDump.toHex(this.rgbHdrData)).append("\n");
            }
        }
        buffer.append("[/FEATURE HEADER]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeShort(this.isf_sharedFeatureType);
        out.writeByte(this.reserved);
        out.writeInt(this.cbHdrData);
        switch (this.isf_sharedFeatureType) {
            case 2: {
                ((EnhancedProtection)this.shared).serialize(out);
                break;
            }
            default: {
                out.write(this.rgbHdrData);
            }
        }
    }

    @Override
    protected int getDataSize() {
        int sz = 19;
        switch (this.isf_sharedFeatureType) {
            case 2: {
                sz += 4;
                break;
            }
            default: {
                sz += this.rgbHdrData.length;
            }
        }
        return sz;
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    public boolean isEnhancedProtection() {
        return this.isf_sharedFeatureType == 2;
    }

    public EnhancedProtection getEnhancedProtection() {
        return this.isEnhancedProtection() ? (EnhancedProtection)this.shared : null;
    }
}

