/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.zkoss.poi.hslf.model.textproperties.TextPFException9;
import org.zkoss.poi.hslf.record.RecordAtom;
import org.zkoss.poi.util.LittleEndian;

public final class StyleTextProp9Atom
extends RecordAtom {
    private final TextPFException9[] autoNumberSchemes;
    private byte[] header;
    private byte[] data;
    private short version;
    private short recordId;
    private int length;

    protected StyleTextProp9Atom(byte[] source, int start, int len) {
        LinkedList<TextPFException9> schemes = new LinkedList<TextPFException9>();
        this.header = new byte[8];
        System.arraycopy(source, start, this.header, 0, 8);
        this.version = LittleEndian.getShort(this.header, 0);
        this.recordId = LittleEndian.getShort(this.header, 2);
        this.length = LittleEndian.getInt(this.header, 4);
        this.data = new byte[len - 8];
        System.arraycopy(source, start + 8, this.data, 0, len - 8);
        int i = 0;
        while (i < this.data.length) {
            TextPFException9 item = new TextPFException9(this.data, i);
            schemes.add(item);
            i += item.getRecordLength();
            int textSiException = LittleEndian.getInt(this.data, i += 4);
            i += 4;
            if (0 != (textSiException & 0x40)) {
                i += 2;
            }
            if (i < this.data.length) continue;
            break;
        }
        this.autoNumberSchemes = schemes.toArray(new TextPFException9[schemes.size()]);
    }

    @Override
    public long getRecordType() {
        return this.recordId;
    }

    public short getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public TextPFException9[] getAutoNumberTypes() {
        return this.autoNumberSchemes;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this.header);
        out.write(this.data);
    }

    public void setTextSize(int size) {
        LittleEndian.putInt(this.data, 0, size);
    }

    public void reset(int size) {
        this.data = new byte[10];
        LittleEndian.putInt(this.data, 0, size);
        LittleEndian.putInt(this.data, 4, 1);
        LittleEndian.putShort(this.data, 8, (short)0);
        LittleEndian.putInt(this.header, 4, this.data.length);
    }
}

