/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.extractor;

import java.io.FileOutputStream;
import java.io.IOException;
import org.zkoss.poi.hslf.HSLFSlideShow;
import org.zkoss.poi.hslf.usermodel.PictureData;
import org.zkoss.poi.hslf.usermodel.SlideShow;

public final class ImageExtractor {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Usage:");
            System.err.println("\tImageExtractor <file>");
            return;
        }
        SlideShow ppt = new SlideShow(new HSLFSlideShow(args[0]));
        PictureData[] pdata = ppt.getPictureData();
        block8: for (int i = 0; i < pdata.length; ++i) {
            String ext;
            PictureData pict = pdata[i];
            byte[] data = pict.getData();
            int type = pict.getType();
            switch (type) {
                case 5: {
                    ext = ".jpg";
                    break;
                }
                case 6: {
                    ext = ".png";
                    break;
                }
                case 3: {
                    ext = ".wmf";
                    break;
                }
                case 2: {
                    ext = ".emf";
                    break;
                }
                case 4: {
                    ext = ".pict";
                    break;
                }
                case 7: {
                    ext = ".dib";
                    break;
                }
                default: {
                    continue block8;
                }
            }
            FileOutputStream out = new FileOutputStream("pict_" + i + ext);
            out.write(data);
            out.close();
        }
    }
}

