/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import org.zkoss.poi.ss.formula.SheetRefEvaluator;
import org.zkoss.poi.ss.formula.eval.AreaEval;
import org.zkoss.poi.ss.formula.eval.AreaEvalBase;
import org.zkoss.poi.ss.formula.eval.HyperlinkEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.AreaI;
import org.zkoss.poi.ss.usermodel.Hyperlink;
import org.zkoss.poi.ss.util.CellReference;

public final class LazyAreaEval
extends AreaEvalBase
implements HyperlinkEval {
    private final SheetRefEvaluator _evaluator;
    private Hyperlink _hyperlink;

    LazyAreaEval(AreaI ptg, SheetRefEvaluator evaluator) {
        super(ptg);
        this._evaluator = evaluator;
    }

    public LazyAreaEval(int firstRowIndex, int firstColumnIndex, int lastRowIndex, int lastColumnIndex, boolean firstRowRel, boolean firstColRel, boolean lastRowRel, boolean lastColRel, SheetRefEvaluator evaluator) {
        super(firstRowIndex, firstColumnIndex, lastRowIndex, lastColumnIndex, firstRowRel, firstColRel, lastRowRel, lastColRel);
        this._evaluator = evaluator;
    }

    @Override
    public ValueEval getRelativeValue(int relativeRowIndex, int relativeColumnIndex) {
        int rowIx = relativeRowIndex + this.getFirstRow();
        int colIx = relativeColumnIndex + this.getFirstColumn();
        return this._evaluator.getEvalForCell(rowIx, colIx);
    }

    @Override
    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        AreaI.OffsetArea area = new AreaI.OffsetArea(this.getFirstRow(), this.getFirstColumn(), relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        return new LazyAreaEval(area, this._evaluator);
    }

    @Override
    public LazyAreaEval getRow(int rowIndex) {
        if (rowIndex >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid rowIndex " + rowIndex + ".  Allowable range is (0.." + this.getHeight() + ").");
        }
        int absRowIx = this.getFirstRow() + rowIndex;
        return new LazyAreaEval(absRowIx, this.getFirstColumn(), absRowIx, this.getLastColumn(), this.isFirstRowRelative(), this.isFirstColRelative(), this.isLastRowRelative(), this.isLastColRelative(), this._evaluator);
    }

    @Override
    public LazyAreaEval getColumn(int columnIndex) {
        if (columnIndex >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid columnIndex " + columnIndex + ".  Allowable range is (0.." + this.getWidth() + ").");
        }
        int absColIx = this.getFirstColumn() + columnIndex;
        return new LazyAreaEval(this.getFirstRow(), absColIx, this.getLastRow(), absColIx, this.isFirstRowRelative(), this.isFirstColRelative(), this.isLastRowRelative(), this.isLastColRelative(), this._evaluator);
    }

    public String getSheetName() {
        return this._evaluator.getSheetName();
    }

    public String getLastSheetName() {
        return this._evaluator.getLastSheetName();
    }

    public String getBookName() {
        return this._evaluator.getBookName();
    }

    public String toString() {
        CellReference crA = new CellReference(this.getFirstRow(), this.getFirstColumn(), !this.isFirstRowRelative(), !this.isFirstColRelative());
        CellReference crB = new CellReference(this.getLastRow(), this.getLastColumn(), !this.isLastRowRelative(), !this.isLastColRelative());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        String bookName = this._evaluator.getBookName();
        if (bookName != null) {
            sb.append('[').append(bookName).append(']');
        }
        sb.append(this._evaluator.getSheetName());
        if (!this._evaluator.getSheetName().equals(this._evaluator.getLastSheetName())) {
            sb.append(':').append(this._evaluator.getLastSheetName());
        }
        sb.append('!');
        sb.append(crA.formatAsString());
        sb.append(':');
        sb.append(crB.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isSubTotal(int rowIndex, int columnIndex) {
        return this._evaluator.isSubTotal(this.getFirstRow() + rowIndex, this.getFirstColumn() + columnIndex);
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    @Override
    public Hyperlink getHyperlink() {
        return this._hyperlink;
    }

    @Override
    public int getDepth() {
        return this._evaluator.getSheetCount();
    }

    @Override
    public boolean isHidden(int rowIndex, int columnIndex) {
        return this._evaluator.isHidden(this._evaluator.getSheetIndex(), this.getFirstRow() + rowIndex, this.getFirstColumn() + columnIndex);
    }

    @Override
    public SheetRefEvaluator getRefEvaluator() {
        return this._evaluator;
    }
}

