/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;

public class HideHeaderAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = 1589502605376615645L;
    boolean[] _oldHiddens;
    final Type _type;
    final boolean _hidden;

    public HideHeaderAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Type type, boolean hidden) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._type = type;
        this._hidden = hidden;
    }

    @Override
    public void doAction() {
        if (this.isSheetProtected()) {
            return;
        }
        if (this._type == Type.ROW) {
            this._oldHiddens = new boolean[this._lastRow - this._row + 1];
            for (int i = this._row; i <= this._lastRow; ++i) {
                this._oldHiddens[i - this._row] = this._sheet.isRowHidden(i);
            }
            Range r = Ranges.range(this._sheet, this._row, 0, this._lastRow, 0).toRowRange();
            if (this._hidden) {
                CellOperationUtil.hide(r);
            } else {
                CellOperationUtil.unhide(r);
            }
        } else {
            this._oldHiddens = new boolean[this._lastColumn - this._column + 1];
            for (int i = this._column; i <= this._lastColumn; ++i) {
                this._oldHiddens[i - this._column] = this._sheet.isColumnHidden(i);
            }
            Range r = Ranges.range(this._sheet, 0, this._column, 0, this._lastColumn).toColumnRange();
            if (this._hidden) {
                CellOperationUtil.hide(r);
            } else {
                CellOperationUtil.unhide(r);
            }
        }
    }

    @Override
    public boolean isUndoable() {
        return this._oldHiddens != null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public boolean isRedoable() {
        return this._oldHiddens == null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public void undoAction() {
        if (this.isSheetProtected()) {
            return;
        }
        if (this._oldHiddens != null) {
            if (this._type == Type.ROW) {
                for (int i = this._row; i <= this._lastRow; ++i) {
                    Range r = Ranges.range(this._sheet, i, 0, i, 0).toRowRange();
                    if (this._oldHiddens[i - this._row]) {
                        CellOperationUtil.hide(r);
                        continue;
                    }
                    CellOperationUtil.unhide(r);
                }
            } else {
                for (int i = this._column; i <= this._lastColumn; ++i) {
                    Range r = Ranges.range(this._sheet, 0, i, 0, i).toColumnRange();
                    if (this._oldHiddens[i - this._column]) {
                        CellOperationUtil.hide(r);
                        continue;
                    }
                    CellOperationUtil.unhide(r);
                }
            }
            this._oldHiddens = null;
        }
    }

    @Override
    protected boolean isSheetProtected() {
        Range range = Ranges.range(this._sheet);
        return !(!super.isSheetProtected() || this._type == Type.COLUMN && range.getSheetProtection().isFormatColumnsAllowed() || this._type == Type.ROW && range.getSheetProtection().isFormatRowsAllowed());
    }

    public static enum Type {
        ROW,
        COLUMN;

    }
}

