/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import io.keikai.api.Range;
import io.keikai.api.RangeRunner;
import io.keikai.api.SheetAnchor;
import io.keikai.api.model.Book;
import io.keikai.api.model.Chart;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.model.SSheet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.image.AImage;

public class SheetOperationUtil {
    public static void toggleAutoFilter(Range range) {
        if (range.isProtected() && !range.getSheetProtection().isAutoFilterAllowed()) {
            return;
        }
        range.enableAutoFilter(!range.isAutoFilterEnabled());
    }

    public static void resetAutoFilter(Range range) {
        if (range.isProtected() && !range.getSheetProtection().isAutoFilterAllowed()) {
            return;
        }
        range.resetAutoFilter();
    }

    public static void applyAutoFilter(Range range) {
        if (range.isProtected() && !range.getSheetProtection().isAutoFilterAllowed()) {
            return;
        }
        range.applyAutoFilter();
    }

    public static Picture addPicture(Range range, AImage image) {
        return SheetOperationUtil.addPicture(range, image.getByteData(), SheetOperationUtil.getPictureFormat(image), image.getWidth(), image.getHeight());
    }

    public static Picture addPicture(Range range, byte[] binary, Picture.Format format, int widthPx, int heightPx) {
        SheetAnchor anchor = SheetOperationUtil.toFilledAnchor(range.getSheet(), range.getRow(), range.getColumn(), widthPx, heightPx);
        return SheetOperationUtil.addPicture(range, anchor, binary, format);
    }

    public static Picture addPicture(Range range, SheetAnchor anchor, byte[] binary, Picture.Format format) {
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            return null;
        }
        return range.addPicture(anchor, binary, format);
    }

    public static Picture.Format getPictureFormat(AImage image) {
        String format = image.getFormat();
        if ("dib".equalsIgnoreCase(format)) {
            return Picture.Format.DIB;
        }
        if ("emf".equalsIgnoreCase(format)) {
            return Picture.Format.EMF;
        }
        if ("wmf".equalsIgnoreCase(format)) {
            return Picture.Format.WMF;
        }
        if ("jpeg".equalsIgnoreCase(format)) {
            return Picture.Format.JPEG;
        }
        if ("pict".equalsIgnoreCase(format)) {
            return Picture.Format.PICT;
        }
        if ("png".equalsIgnoreCase(format)) {
            return Picture.Format.PNG;
        }
        return null;
    }

    public static void movePicture(Range range, Picture picture, int rowIndex, int columnIndex) {
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            return;
        }
        if (SheetOperationUtil.hasPicture(range, picture)) {
            SheetAnchor fromAnchor = picture.getAnchor();
            int rowOffset = fromAnchor.getLastRow() - fromAnchor.getRow();
            int columnOffset = fromAnchor.getLastColumn() - fromAnchor.getColumn();
            rowIndex = rowIndex < 0 ? 0 : rowIndex;
            columnIndex = columnIndex < 0 ? 0 : columnIndex;
            SheetAnchor toAnchor = new SheetAnchor(rowIndex, columnIndex, fromAnchor.getXOffset(), fromAnchor.getYOffset(), rowIndex + rowOffset, columnIndex + columnOffset, fromAnchor.getLastXOffset(), fromAnchor.getLastYOffset());
            range.movePicture(toAnchor, picture);
        }
    }

    public static void deletePicture(Range range, Picture picture) {
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            return;
        }
        if (SheetOperationUtil.hasPicture(range, picture)) {
            range.deletePicture(picture);
        }
    }

    public static boolean hasPicture(Range range, Picture picture) {
        for (Picture p : range.getSheet().getPictures()) {
            if (!p.getId().equals(picture.getId())) continue;
            return true;
        }
        return false;
    }

    public static Chart addChart(Range range, Chart.Type type, Chart.Grouping grouping, Chart.LegendPosition pos) {
        SheetAnchor anchor = SheetOperationUtil.toChartAnchor(range);
        return SheetOperationUtil.addChart(range, anchor, type, grouping, pos);
    }

    public static Chart addChart(Range range, SheetAnchor anchor, Chart.Type type, Chart.Grouping grouping, Chart.LegendPosition pos) {
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            return null;
        }
        return range.addChart(anchor, type, grouping, pos);
    }

    public static SheetAnchor toChartAnchor(Range range) {
        int row = range.getRow();
        int col = range.getColumn();
        int lRow = range.getLastRow();
        int lCol = range.getLastColumn();
        int w = lCol - col + 1;
        return new SheetAnchor(row, lCol + 2, row == lRow ? row + 7 : lRow + 1, col == lCol ? lCol + 7 + w : lCol + 2 + w);
    }

    public static void moveChart(Range range, Chart chart, int rowIndex, int columnIndex) {
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            return;
        }
        if (SheetOperationUtil.hasChart(range, chart)) {
            SheetAnchor fromAnchor = chart.getAnchor();
            int rowOffset = fromAnchor.getLastRow() - fromAnchor.getRow();
            int columnOffset = fromAnchor.getLastColumn() - fromAnchor.getColumn();
            rowIndex = rowIndex < 0 ? 0 : rowIndex;
            columnIndex = columnIndex < 0 ? 0 : columnIndex;
            SheetAnchor toAnchor = new SheetAnchor(rowIndex, columnIndex, fromAnchor.getXOffset(), fromAnchor.getYOffset(), rowIndex + rowOffset, columnIndex + columnOffset, fromAnchor.getLastXOffset(), fromAnchor.getLastYOffset());
            range.moveChart(toAnchor, chart);
        }
    }

    public static void deleteChart(Range range, Chart chart) {
        if (range.isProtected() && !range.getSheetProtection().isObjectsEditable()) {
            return;
        }
        if (SheetOperationUtil.hasChart(range, chart)) {
            range.deleteChart(chart);
        }
    }

    public static boolean hasChart(Range range, Chart chart) {
        for (Chart c : range.getSheet().getCharts()) {
            if (!c.getId().equals(chart.getId())) continue;
            return true;
        }
        return false;
    }

    public static void protectSheet(Range range, String password, String newpasswrod) {
        range.protectSheet(newpasswrod);
    }

    public static void protectSheet(Range range, String password, boolean allowSelectingLockedCells, boolean allowSelectingUnlockedCells, boolean allowFormattingCells, boolean allowFormattingColumns, boolean allowFormattingRows, boolean allowInsertColumns, boolean allowInsertRows, boolean allowInsertingHyperlinks, boolean allowDeletingColumns, boolean allowDeletingRows, boolean allowSorting, boolean allowFiltering, boolean allowUsingPivotTables, boolean drawingObjects, boolean scenarios) {
        range.protectSheet(password, allowSelectingLockedCells, allowSelectingUnlockedCells, allowFormattingCells, allowFormattingColumns, allowFormattingRows, allowInsertColumns, allowInsertRows, allowInsertingHyperlinks, allowDeletingColumns, allowDeletingRows, allowSorting, allowFiltering, allowUsingPivotTables, drawingObjects, scenarios);
    }

    public static boolean unprotectSheet(Range range, String password) {
        return range.unprotectSheet(password);
    }

    public static void displaySheetGridlines(Range range, boolean enable) {
        range.setDisplaySheetGridlines(enable);
    }

    public static void addSheet(Range range, final String prefix) {
        range.sync(new RangeRunner(){

            @Override
            public void run(Range range) {
                String name;
                Book book = range.getBook();
                int numSheet = book.getNumberOfSheets();
                while (book.getSheet(name = prefix + ++numSheet) != null) {
                }
                range.createSheet(name);
            }
        });
    }

    public static void createSheet(Range range, final String name) {
        range.sync(new RangeRunner(){

            @Override
            public void run(Range range) {
                Book book = range.getBook();
                if (book.getSheet(name) != null) {
                    return;
                }
                range.createSheet(name);
            }
        });
    }

    public static void renameSheet(Range range, final String newname) {
        range.sync(new RangeRunner(){

            @Override
            public void run(Range range) {
                if (range.getSheetName().equals(newname)) {
                    return;
                }
                Book book = range.getBook();
                if (book.getSheet(newname) != null) {
                    return;
                }
                range.setSheetName(newname);
            }
        });
    }

    public static void setSheetOrder(Range range, int pos) {
        range.setSheetOrder(pos);
    }

    public static void deleteSheet(Range range) {
        range.sync(new RangeRunner(){

            @Override
            public void run(Range range) {
                int num = range.getBook().getNumberOfSheets();
                if (num <= 1) {
                    return;
                }
                range.deleteSheet();
            }
        });
    }

    public static void CopySheet(Range range) {
        range.sync(new RangeRunner(){

            @Override
            public void run(Range range) {
                String prefix = range.getSheetName();
                int num = 1;
                String name = null;
                Pattern pattern = Pattern.compile("(.*) \\(([0-9]+)\\)$");
                Matcher matcher = pattern.matcher(prefix);
                if (matcher.find()) {
                    prefix = matcher.group(1);
                    num = Integer.parseInt(matcher.group(2));
                }
                int length = range.getBook().getNumberOfSheets();
                for (int i = 0; i <= length; ++i) {
                    String n = prefix + " (" + ++num + ")";
                    if (range.getBook().getSheet(n) != null) continue;
                    name = n;
                    break;
                }
                range.cloneSheet(name);
            }
        });
    }

    public static SheetAnchor toFilledAnchor(Sheet sheet, int row, int column, int widthPx, int heightPx) {
        int hPx;
        int wPx;
        int lRow = 0;
        int lColumn = 0;
        int lX = 0;
        int lY = 0;
        SSheet ws = ((SheetImpl)sheet).getNative();
        int i = column;
        while (true) {
            if (!ws.getColumn(i).isHidden() && (widthPx -= (wPx = sheet.getColumnWidth(i))) <= 0) break;
            ++i;
        }
        lColumn = i;
        lX = wPx + widthPx;
        i = row;
        while (true) {
            if (!ws.getRow(i).isHidden() && (heightPx -= (hPx = sheet.getRowHeight(i))) <= 0) break;
            ++i;
        }
        lRow = i;
        lY = hPx + heightPx;
        return new SheetAnchor(row, column, 0, 0, lRow, lColumn, lX, lY);
    }
}

