
(function () {


zss.DataPanel = zk.$extends(zk.Object, {
	cacheMap: null, 
	$init: function (sheet) {
		this.$supers(zss.DataPanel, '$init', []);
		var wgt = this._wgt = sheet._wgt,
			dataPanel = sheet.$n('dp'),
			
			
			
			focus = this.focustag = sheet.inlineEditor.getInputNode();

		this.cacheMap = {}; 
		this.id = dataPanel.id;
		this.sheet = sheet;
		this.comp = dataPanel;
		this.comp.ctrl = this;
		this.padcomp =  sheet.$n('datapad');

		wgt.domListen_(focus, 'onBlur', '_doDataPanelBlur');
		wgt.domListen_(focus, 'onFocus', '_doDataPanelFocus');

		this.width = sheet.custColWidth.getStartPixel(wgt.getMaxColumns());
		this.height = sheet.custRowHeight.getStartPixel(wgt.getMaxRows());

		this.paddingl = this.paddingt = 0;
		var pdl = this.paddingl + sheet.leftWidth,
			pdt = sheet.topHeight;

		jq(dataPanel).css({'width': jq.px0(this.width), 'height': jq.px0(this.height)});
	},
	cleanup: function() {
		var focus = this.focustag,
			wgt = this.sheet._wgt;
		wgt.domUnlisten_(focus, 'onBlur', '_doDataPanelBlur');
		wgt.domUnlisten_(focus, 'onFocus', '_doDataPanelFocus');
		
		this.invalid = true;
		this.cacheMap = this.focustag = null;

		if (this.comp) this.comp.ctrl = null;
		this._wgt = this.comp = this.padcomp = this.sheet = null;
	},
	reset: function (width, height) {
		var wgt = this._wgt,
			l = this.paddingl = wgt.getLeftPanelWidth(),
			t = this.paddingt = wgt.getTopPanelHeight() + 1; 
		this.width = width;
		this.height = height;
		jq(this.comp).css({'padding-left': jq.px0(l), 'padding-top': jq.px0(t),'width': jq.px0(width), 'height': jq.px0(height)});
	},
	
	updateHeight: function (diff) {
		this.height += diff;
		jq(this.comp).css('height', jq.px0(this.height));
	},
	
	updateWidth: function (diff) {
		this.width += diff;
		jq(this.comp).css('width', jq.px0(this.width));
	},
	_fixSize: function (block) {
		var self = this,
			wgt = this._wgt,
			sheet = this.sheet,
			custColWidth = sheet.custColWidth,
			custRowHeight = sheet.custRowHeight;

		
		
		self.width = sheet.custColWidth.getStartPixel(wgt.getMaxColumns());
		self.height = sheet.custRowHeight.getStartPixel(wgt.getMaxRows());
		self.paddingl = custColWidth.getStartPixel(block.range.left);
		self.paddingt = custRowHeight.getStartPixel(block.range.top);
		
		var width = self.width - self.paddingl,
			height = self.height,
			pdl = self.paddingl + sheet.leftWidth,
			pdt = sheet.topHeight + 1; 
		
		jq(self.comp).css({'padding-left': jq.px0(pdl), 'padding-top': jq.px0(pdt), 'width': jq.px0(width)});
		jq(self.comp).css({'width': jq.px0(width)});
		jq(self.comp).css({'height': jq.px0(height)}); 
		jq(self.padcomp).css('height', jq.px0(self.paddingt));
		sheet.tp._updateLeftPadding(pdl);
		sheet.lp._updateTopPadding(self.paddingt);
	},
	
	isFocusOnFrozen: function () {
		var sheet = this.sheet,
			fzr = sheet.frozenRow,
			fzc = sheet.frozenCol,
			pos = sheet.getLastFocus();

		return fzc > -1 && pos.column <= fzc
			|| fzr > -1 && pos.row <= fzr;
	},
	
	startEditing: function (evt, val, type, pos, noServer) { 
		var sheet = this.sheet;
		if (sheet.config.readonly) 
			return false;
		
		var row, col;
		if (pos) { 
			row = pos.row;
			col = pos.col;
		}else{ 
			row = sheet.getLastFocus().row,
			col = sheet.getLastFocus().column;
		}
		var type = type || 'inlineEditing',
			cell = sheet.getCell(row, col);
		if (this._wgt.isProtect() && cell && cell.isLocked()) {
			sheet.showInfo(msgzss.cannotEditProtected, true);
			return false;
		}
		
		
		if (!val) val = null;
		sheet.state = zss.SSheetCtrl.START_EDIT;
		
		
		
		
		
		if ('inlineEditing' == type) {
			sheet.dp.moveFocus(row, col, true, true);
		} else { 
			this._openEditbox(null, true); 
		}
		
		
		if (!noServer) {
			sheet.fire('onStartEditing', {row: row, col: col, value: val, type: type});
			sheet._wgt.fire('onStartEditing',
					{token: "", sheetId: sheet.serverSheetId, row: row, col: col, clienttxt: val, type: type}, null, 25);
		}
		return true;
	},
	_isProtect: function (tRow, lCol, bRow, rCol) {
		var shtProtect = this._wgt.isProtect(),
			data = this._wgt._cacheCtrl.getSelectedSheet();
		for (var r = tRow; r <= bRow; r++) {
			for (var c = lCol; c <= rCol; c++) {
				var cell = data.getRow(r).getCell(c);
				if (shtProtect && cell && cell.lock) {
					return true;
				}
			}
		}
		return false;
	},
	
	_speedCopy: function (value, type) { 
		var sheet = this.sheet,
			pos = sheet.getLastFocus(),
			top = pos.row,
			left = pos.column,
			ci = left,
			right = left,
			rows = value.split('\n'),
			rlen = rows.length,
			bottom = top + rlen - 1,
			vals = [],
			val = null,
			type = type || 'inlineEditing';
		for(var r = 0; r < rlen; ++r) {
			var row = rows[r],
				cols = row.split('\t'),
				clen = cols.length,
				rmax = left + clen - 1;
			if (right < rmax)
				right = rmax;
			vals.push(cols);
		}
		var lastcols = vals[rlen-1]; 
		if (lastcols.length == 1 && lastcols[0].length == 0) { 
			--rlen;
			if (rlen > 0)
				--bottom;
		}
		if (this._isProtect(top, left, bottom, right)) {
			sheet.showInfo(msgzss.cannotEditProtected, true);
			sheet._doCellSelection(left, top, right, bottom);
			return;
		}
		var clenmax = right - left + 1;
		for(var r = 0; r < rlen; ++r) {
			var cols = vals[r],
				clen = cols.length,
				ri = top+r;
			for(var c = 0; c < clenmax; ++c) {
				ci = left + c;
				val = c >= clen ? null : cols[c];
				if (sheet.state != zss.SSheetCtrl.START_EDIT) {
					sheet.state = zss.SSheetCtrl.START_EDIT;
					sheet._wgt.fire('onStartEditing',
							{token: "", sheetId: sheet.serverSheetId, row: ri, col: ci, clienttxt: val, type: type}, null, 25);
				}
				sheet.state = zss.SSheetCtrl.FOCUSED;
				sheet._wgt.fire('onStopEditing',
						{token: "", sheetId: sheet.serverSheetId, row: ri, col: ci, value: val, type: type}, {toServer: true}, 25);
			}
		}
		return {left:left,top:top,right:right,bottom:bottom};
	},
	
	_speedInput: function (value, type) {
		var sheet = this.sheet,
			pos = sheet.getLastFocus(),
			top = pos.row,
			left = pos.column,
			ri = top,
			ci = left,
			rows = value.split(zkS._enterChar),
			val = '',
			type = type || 'inlineEditing';
		for(var r = 0, rlen = rows.length; r < rlen; ++r) {
			var row = rows[r],
				cols = row.split('\t');
			ri = top+r;
			ci = left;
			for(var c = 0, clen = cols.length; c < clen; ++c) {
				ci = left + c;
				val = cols[c];
				if (r == (rlen-1) && c == (clen-1)) 
					break;
				if (sheet.state != zss.SSheetCtrl.START_EDIT) {
					sheet.state = zss.SSheetCtrl.START_EDIT;
					sheet._wgt.fire('onStartEditing',
							{token: "", sheetId: sheet.serverSheetId, row: ri, col: ci, clienttxt: val, type: type}, null, 25);
				}
				sheet.state = zss.SSheetCtrl.FOCUSED;
				sheet._wgt.fire('onStopEditing',
						{token: "", sheetId: sheet.serverSheetId, row: ri, col: ci, value: val, type: type}, {toServer: true}, 25);
			}
		}
		if (left != ci || top != ri) 
			this.moveFocus(ri, ci, true, true);
		if (ci != left || (val && val.length > 0)) {
			if (sheet.state != zss.SSheetCtrl.START_EDIT) {
				sheet.state = zss.SSheetCtrl.START_EDIT;
				
				sheet._wgt.fire('onStartEditing',
						{token: "", sheetId: sheet.serverSheetId, row: ri, col: ci, clienttxt: val != null ? val : '', type: type}, null, 25);
			}
			this._openEditbox(val);
		}
	},
	
	_startEditing: function (value, server) {
		var sheet = this.sheet,
			cell = sheet.getFocusedCell();

		
		if (cell != null) {
			var editor = sheet.inlineEditor;
			if(sheet.state == zss.SSheetCtrl.START_EDIT) {
				if (!server)
					value = sheet._clienttxt;
				sheet._clienttxt = '';
				this._speedInput(value);
				editor._startEditing();
			} else if (server && sheet.state == zss.SSheetCtrl.EDITING && editor.comp.value != value) {
				var p = sheet.getLastFocus();
				editor.edit(cell.comp, p.row, p.column, value);
			}	
		}
	},
	
	retryEditing: function (val, row, column) {
		this.startEditing(null, val, 'inlineEditing', {row:row, col:column});
		this._openEditbox(val);
	},
	
	_openEditbox: function (initval, noFocus) {
		var sheet = this.sheet,
			cell = sheet.getFocusedCell();
			
		if (cell != null) {
			if( sheet.state == zss.SSheetCtrl.START_EDIT) {
				var editor = sheet.inlineEditor,
					pos = sheet.getLastFocus(),
					value = !initval && initval != "" ?
							
							sheet.isPercentCell(cell.r, cell.c) ?
									
									(parseFloat(cell.edit)*100)+"%" : cell.edit : initval; 
				editor.edit(cell.comp, pos.row, pos.column, value ? value : '', noFocus);
				sheet.state = zss.SSheetCtrl.EDITING;
			}
		}
	},
	
	getEditor: function (type) {
		var sheet = this.sheet;
		if (type) {
			return type == 'formulabarEditing' ? sheet.formulabarEditor : sheet.inlineEditor;
		} else {
			var inlineEditor = sheet.inlineEditor;
			if (inlineEditor.isEditing() || !sheet.formulabarEditor) {
				return inlineEditor;
			}
			return sheet.formulabarEditor;
		}
	},
	
	cancelEditing: function (type) {
		var sheet = this.sheet;
		if (sheet.state >= zss.SSheetCtrl.FOCUSED) {
			this.getEditor(type).cancel();
			sheet.fire('onStopEditing'); 
			sheet.state = zss.SSheetCtrl.FOCUSED;
			this.reFocus(true);
		}
	},
	
	stopEditing: function (type) {
		var sheet = this.sheet,
			inlineEditing = sheet.inlineEditor.isEditing(),
			editingType = inlineEditing ? 'inlineEditing' : 'formulabarEditing';
		if (sheet.state == zss.SSheetCtrl.EDITING) {

			sheet.state = zss.SSheetCtrl.STOP_EDIT;

			var data = this._wgt._cacheCtrl.getSelectedSheet(),
				editor = inlineEditing ? this.sheet.inlineEditor : this.sheet.formulabarEditor,
				value = editor.getValue(),
				sheetId = editor.sheetId,
				row = editor.row, 
				col = editor.col, 
				cell = sheet.getCell(row, col),
				edit = cell ? cell.edit : null;

			if (sheetId && sheetId != sheet.serverSheetId) {
				var sheetBar = sheet._wgt._sheetBar,
					sheetSelector = sheetBar ? sheetBar.getSheetSelector(): null;
				if (sheetSelector) {
					sheetSelector.doSelectSheet(sheetId);
				}
			}

			
			if (edit != value || (edit && edit.charAt(0) == '=' && cell && cell.cellType == 1 && edit.length > 1)) { 
				var token = "";
				if (type == "movedown") {
					token = zkS.addCallback(function(){
						if (sheet.invalid) return;
						sheet.state = zss.SSheetCtrl.FOCUSED;
						if (!sheet._skipMove) 
							sheet.dp.moveDown(null, row, col);
					});
				} else if (type == "moveright") {
					token = zkS.addCallback(function(){
						if (sheet.invalid) return;
						sheet.state = zss.SSheetCtrl.FOCUSED;
						if (!sheet._skipMove) 
							sheet.dp.moveRight(null, row, col);
					});
				} else if (type == "moveleft") {
					token = zkS.addCallback (function(){
						if (sheet.invalid) return;
						sheet.state = zss.SSheetCtrl.FOCUSED;
						if (!sheet._skipMove) 
							sheet.dp.moveLeft(null, row, col);
					});
				} else if (type == "refocus") {
					token = zkS.addCallback(function(){
						if (sheet.invalid) return;
						sheet.state = zss.SSheetCtrl.FOCUSED;
						sheet.dp.reFocus(true);
					});
				} else if (type == "lostfocus") {
					
					
					
					
					
					
					
					sheet.asyncCheckFormula = true; 
					token = zkS.addCallback(function(){
						sheet.asyncCheckFormula = false; 
						if (!sheet.invalid) {
							var osheetState = sheet.state; 
							sheet.dp._doFocusLost();
							
							
							
							
							if (sheet.sheetTabFn && osheetState == zss.SSheetCtrl.STOP_EDIT) {
								sheet.sheetTabFn();
							}
						}
						sheet.sheetTabFn = null; 
					});
				}
				
				sheet.fire('onStopEditing', {row: row, col: col, value: value});
				sheet._wgt.fire('onStopEditing', 
						{token: token, sheetId: sheet.serverSheetId, row: row, col: col, value: value, type: editingType}, {toServer: true}, 25);
			} else {
				sheet.fire('onStopEditing', {row: row, col: col, value: value});
				this._stopEditing();
				if (type == "movedown") {
					if (sheet.invalid) return;
					sheet.state = zss.SSheetCtrl.FOCUSED;
					this.moveDown();
				} else if (type == "moveright") {
					if (sheet.invalid) return;
					sheet.state = zss.SSheetCtrl.FOCUSED;
					this.moveRight();
				} else if (type == "moveleft") {
					if (sheet.invalid) return;
					sheet.state = zss.SSheetCtrl.FOCUSED;
					this.moveLeft();
				} else if (type == "refocus") {
					if (sheet.invalid) return;
					sheet.state = zss.SSheetCtrl.FOCUSED;
					this.reFocus(true);
				} else if (type == "lostfocus") {
					if (sheet.invalid) return;
					this._doFocusLost();
				}
			}
		}
	},
	
	_stopEditing: function () {
		var sheet = this.sheet;
		if (sheet.state == zss.SSheetCtrl.STOP_EDIT) {
			sheet.inlineEditor.stop();
		}
	},
	
	moveFocus: function(row, col, scroll, selection, noevt, noslevt, forceStopEditing) { 
		var sheet = this.sheet,
			lastFocus = sheet.getLastFocus();

		if (sheet && !sheet.editingFormulaInfo) {
			
			if(lastFocus.row != row || lastFocus.column != col || forceStopEditing) { 
				this.stopEditing("refocus");
			}
		} else { 
			
			
			
				var info = sheet.editingFormulaInfo;
				if (info) {
					info.moveCell = true;
					
					
					sheet.shallIgnoreBlur = true;
				}
			
		}
		var fzr = sheet.frozenRow,
			fzc = sheet.frozenCol,
			local = this,
			fn = function () {
				
				if(!sheet.getCell(row, col)){
					sheet.sp.scrollToVisible(row,col);
					setTimeout(function(){
						local._moveFocus(row, col, scroll, selection, noevt, noslevt);	
					},25);
				}else{
					local._moveFocus(row, col, scroll, selection, noevt, noslevt);
				}
			},
			block = sheet.activeBlock,
		
		
			lr = (row <= fzr ? block.range.top : row),
			lc = (col <= fzc ? block.range.left : col),
			r = block.loadCell(lr, lc, 5, fn);
		if(r)
			fn();
	},
	
	_moveFocus: function (row, col, scroll, selection, noevt, noslevt) {
		var sheet = this.sheet,
			cell = sheet.getCell(row, col);
		
		if (!cell || !cell.isSelectable())
			return false;	

		var cellcmp = cell.comp,
			ml = cell.merl,
			mt = cell.mert;
		if (zkS.t(ml) && (ml != col || mt != row))
			return this._moveFocus(mt, ml, scroll, selection, noevt, noslevt);
				
		sheet.moveCellFocus(row, col);
		if (!noevt) sheet._sendOnCellFocus(row, col); 
		if (selection) {
			sheet.moveCellSelection(col, row, col, row);
			var ls = sheet.getLastSelection(); 
			if (!noslevt) sheet._sendOnCellSelection(zss.SEL.CELL, ls.left, ls.top, ls.right, ls.bottom);
		}
		
		var sheet = this.sheet;
		this._gainFocus(true, noevt, sheet.state < zss.SSheetCtrl.FOCUSED ? false : true);
		
		if (scroll)
			sheet.sp.scrollToVisible(null, null, cell);	
		return true;
	},
	
	reFocus: function (scroll) {
		var pos = this.sheet.getLastFocus();
		this.moveFocus(pos.row, pos.column, scroll, true);
	},
	
	gainFocus: function (trigger) {
		if (!this.sheet.isSwitchingSheet) {
			this.stopEditing("refocus");
		}
		this._gainFocus(trigger);
	},
	
	_gainFocus: function (trigger, noevt, noslloc) {
		var sheet = this.sheet,
			focustag = this.focustag,
			pos = sheet.getLastFocus(),
			row = pos.row,
			col = pos.column;

		if (sheet.state == zss.SSheetCtrl.NOFOCUS && !noevt)
			sheet._sendOnCellFocus(row, col); 
		
		if (sheet.state < zss.SSheetCtrl.FOCUSED)
			sheet.state = zss.SSheetCtrl.FOCUSED;
		
		if (!noslloc) {
			sheet.moveCellFocus(row, col);
			var ls = sheet.selArea.lastRange;
			sheet.moveCellSelection(ls.left, ls.top, ls.right, ls.bottom, null, !trigger);
		}
		
		var lhl = sheet.hlArea.lastRange;
		sheet.moveHighlight(lhl.left, lhl.top, lhl.right, lhl.bottom);
		sheet.animateHighlight(true);

		if (trigger && sheet.state == zss.SSheetCtrl.FOCUSED){ 
			this.deferSelectFocustag();
		}
	},
	
	deferSelectFocustag: function () {
		var self = this;
		if (this.selectFocustagId) {
			return;
		}
		this.selectFocustagId =
			setTimeout(function () {
				self.selectFocustag();
				delete self.selectFocustagId;
			}, 0);
	},
	
	selectFocustag: function () {
	    
		this.sheet.inlineEditor.select();
	},
	
	getInputNode: function () {
		return this.sheet.$n('fo');
	},
	selectInputNode: function () {
		var inputNode = this.getInputNode();
		inputNode.focus();
		inputNode.select();
	},
	
	_doFocusLost: function() {
		var sheet = this.sheet;
		sheet.state = zss.SSheetCtrl.NOFOCUS;
		sheet.hideCellFocus();
		if (!sheet._wgt._keepCellSelection) sheet.hideCellSelection(); 
		sheet.animateHighlight(false);
		sheet._wgt.fire('onBlur');
	},
	
	selectCell: function(row, col, forcemove) {
		var sheet = this.sheet;
		if(sheet.maxRows <= row || sheet.maxCols <= col) return;

		if ((forcemove || sheet.state >= zss.SSheetCtrl.FOCUSED) && row >-1 && col > -1) {
			
			this.moveFocus(row, col, true, true);
		} else {
			
			
			sheet.moveCellFocus(row, col);
			sheet.moveCellSelection(col, row, col, row);			
			this._gainFocus(true, false, true);
		}
	},
	
	movePageup: function (evt) {
		var sheet = this.sheet;
		if (zkS.isEvtKey(evt, "s")) {
			sheet.shiftSelection("pgup");
			return;
		}
		var pos = sheet.getLastFocus(),
			row = pos.row,
			col = pos.column;
		if (row < 0 || col < 0) return;
		if (row >= 0) {
			var oldTop = zss.SSheetCtrl._getVisibleRange(sheet).top,
				activeBlock = sheet.activeBlock,
				frozenRow = sheet.frozenRow,
				rowOffset = row > frozenRow ? row - oldTop: 0,
				prevrow,
				newTop;
			
			sheet.sp.scrollToVisible(oldTop, -1, null, zss.SCROLL_DIR.VERTICAL, zss.SCROLL_POS.BOTTOM);
			activeBlock.loadForVisible();

			newTop = zss.SSheetCtrl._getVisibleRange(sheet).top;
			prevrow = newTop + rowOffset;
			
			
			sheet.sp.scrollToVisible(newTop, -1, null, zss.SCROLL_DIR.VERTICAL, zss.SCROLL_POS.TOP);

			
			if (sheet._wgt.isProtect() && !sheet._wgt.allowSelectLockedCells) {
				return;
			}

			if (prevrow < 0)
				prevrow = 0;
			var custRowHeight = sheet.custRowHeight,
				newrow = prevrow > 0 ? 
						custRowHeight.getDecUnhidden(prevrow, 0) : 
						custRowHeight.getIncUnhidden(prevrow, row); 
			if (newrow < 0 && prevrow > 0) 
				newrow = custRowHeight.getIncUnhidden(prevrow, row); 
			row = newrow;
		}
		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	movePagedown: function (evt) {
		var sheet = this.sheet;
		if (zkS.isEvtKey(evt,"s")){
			sheet.shiftSelection("pgdn");
			return;
		}
		var	pos = sheet.getLastFocus(),
			row = pos.row,
			col = pos.column;
		if(row < 0 || col < 0) return;
		
		if (row < sheet.maxRows - 1) {
			var oldRange = zss.SSheetCtrl._getVisibleRange(sheet),
				activeBlock = sheet.activeBlock,
				rowOffset = row > sheet.frozenRow ? row - oldRange.top : 0,
				nextrow;

			
			sheet.sp.scrollToVisible(oldRange.bottom, -1, null, zss.SCROLL_DIR.VERTICAL, zss.SCROLL_POS.TOP);
			activeBlock.loadForVisible();

			
			if (sheet._wgt.isProtect() && !sheet._wgt.allowSelectLockedCells) {
				return;
			}
			
			nextrow = zss.SSheetCtrl._getVisibleRange(sheet).top + rowOffset;

			if (nextrow > sheet.maxRows - 1) {
				return;
			}
			var custRowHeight = sheet.custRowHeight,
				newrow = nextrow < (sheet.maxRows - 1) ? 
					custRowHeight.getIncUnhidden(nextrow, sheet.maxRows - 1): 
					custRowHeight.getDecUnhidden(nextrow, row); 
			if (newrow < 0 && nextrow < (sheet.maxRows -1)) 
				newrow = custRowHeight.getDecUnhidden(nextrow, row); 
			row = newrow;
		}
		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	moveEnd: function (evt) {
		var sheet = this.sheet;
		if (zkS.isEvtKey(evt, "s")) {
			sheet.shiftSelection("end");
			return;
		}
		var	pos = sheet.getLastFocus(),
			row = pos.row,
			col = pos.column;
		if (row < 0 || col < 0) return;

		if (!sheet._wgt.isProtect() || sheet._wgt.allowSelectLockedCells) {
			var nextcol = sheet.maxCols - 1,
				custColWidth = sheet.custColWidth;
			col = custColWidth.getDecUnhidden(nextcol, nextcol > col ? col : 0); 
		} else {
			var newpos = this._getShiftPos(row, col, 'end');
			
			if (newpos == null) { 
				return;
			}
			row = newpos.row;
			col = newpos.col;
		}

		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	moveHome: function (evt) {
		var sheet = this.sheet;
		if (zkS.isEvtKey(evt, "s")) {
			sheet.shiftSelection("home");
			return;
		}
		var pos = sheet.getLastFocus(),
			row = pos.row,
			col = pos.column;
		if (row < 0 || col < 0) return;
		
		if (!sheet._wgt.isProtect() || sheet._wgt.allowSelectLockedCells) {
			var prevcol = 0,
				custColWidth = sheet.custColWidth;
			col = custColWidth.getIncUnhidden(prevcol, col < (sheet.maxCols - 1) ? col : (sheet.maxCols - 1)); 
		} else {
			var newpos = this._getShiftPos(row, col, 'home');
			
			if (newpos == null) {
				return;
			}
			row = newpos.row;
			col = newpos.col;
		}
		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	moveUp: function (evt) {
		var sheet = this.sheet,
			ctrlkey = evt && !evt.altKey && evt.ctrlKey; 
		if (zkS.isEvtKey(evt,"s")) {
			sheet.shiftSelection("up");
			return;
		}
		var pos = sheet.getLastFocus(),
			row = pos.row,
			col = pos.column;
		if (row < 0 || col < 0) return;
		
		
		if (ctrlkey) {
			this._fireCtrlArrow(sheet, row, col, "up");
			return;
		}
		if (!sheet._wgt.isProtect() || sheet._wgt.allowSelectLockedCells) {
			if (row > 0) {
				var prevrow = row - 1,
					custRowHeight = sheet.custRowHeight,
					newrow = prevrow > 0 ? 
							custRowHeight.getDecUnhidden(prevrow, 0) : 
							custRowHeight.getIncUnhidden(prevrow, row); 
				if (newrow >= 0)
					row = newrow;
			}
		} else {
			var newpos = this._getShiftPos(row, col, 'up');
			
			if (newpos == null) { 
				return;
			}
			row = newpos.row;
			col = newpos.col;
		}
		
		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	moveDown: function(evt, r, c) {
		var sheet = this.sheet,
			ctrlkey = evt && !evt.altKey && evt.ctrlKey; 
		if (zkS.isEvtKey(evt, "s")) {
			sheet.shiftSelection("down");
			return;
		}
		var pos = sheet.getLastFocus(),
			row = r ? r : pos.row,
			col = c ? c : pos.column;
		if (row < 0 || col < 0) return;
		
		var cell = sheet.getCell(row, col);
		if (cell) {
			var mb = cell.merb;
			if (zkS.t(mb))
				row = mb;
		}

		
		if (ctrlkey) {
			this._fireCtrlArrow(sheet, row, col, "down");
			return;
		}
		if (!sheet._wgt.isProtect() || sheet._wgt.allowSelectLockedCells) {
			if (row < sheet.maxRows - 1) {
				var nextrow = row + 1,
					custRowHeight = sheet.custRowHeight,
					newrow = nextrow < (sheet.maxRows - 1) ? 
						custRowHeight.getIncUnhidden(nextrow, sheet.maxRows - 1): 
						custRowHeight.getDecUnhidden(nextrow, row); 
				if (newrow >= 0)
					row = newrow;
			}
		} else {
			var newpos = this._getShiftPos(row, col, 'down');
			
			if (newpos == null) { 
				return;
			}
			row = newpos.row;
			col = newpos.col;
		}

		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	moveLeft: function(evt, r, c) {
		var sheet = this.sheet,
			ctrlkey = evt && !evt.altKey && evt.ctrlKey; 
		if (zkS.isEvtKey(evt,"s")) {
			sheet.shiftSelection("left");
			return;
		}
		var pos = sheet.getLastFocus(),
			row = r ? r : pos.row,
			col = c ? c : pos.column;
		if (row < 0 || col < 0) return;
		
		if (ctrlkey) {
			this._fireCtrlArrow(sheet, row, col, "left");
			return;
		}
		if (!sheet._wgt.isProtect() || sheet._wgt.allowSelectLockedCells) {
			if (col > 0) {
				var prevcol = col - 1,
				custColWidth = sheet.custColWidth,
				newcol = prevcol > 0 ? 
						custColWidth.getDecUnhidden(prevcol, 0) : 
						custColWidth.getIncUnhidden(prevcol, col); 
				if (newcol >= 0)
					col = newcol;
			}
		} else {
			var newpos = this._getShiftPos(row, col, 'left');
			
			if (newpos == null) { 
				return;
			}
			row = newpos.row;
			col = newpos.col;
		}
		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	moveRight: function(evt, r, c) {
		var sheet = this.sheet,
			ctrlkey = evt && !evt.altKey && evt.ctrlKey; 
		if (zkS.isEvtKey(evt, "s")) {
			sheet.shiftSelection("right");
			return;
		}
		var pos = sheet.getLastFocus(),
			row = r ? r : pos.row,
			col = c ? c : pos.column;
		if(row < 0 || col < 0) return;

		var cell = sheet.getCell(row, col);
		if (cell) {
			var mr = cell.merr;
			if(zkS.t(mr))
				col = mr;
		}
		
		
		if (ctrlkey) {
			this._fireCtrlArrow(sheet, row, col, "right");
			return;
		}
		if (!sheet._wgt.isProtect() || sheet._wgt.allowSelectLockedCells) {
			if (col < sheet.maxCols - 1) {
				var nextcol = col + 1,
					custColWidth = sheet.custColWidth,
					newcol = nextcol < (sheet.maxCols - 1) ? 
						custColWidth.getIncUnhidden(nextcol, sheet.maxCols - 1): 
						custColWidth.getDecUnhidden(nextcol, col); 
				if (newcol >= 0)
					col = newcol;
			}
		} else {
			var newpos = this._getShiftPos(row, col, 'right');
			
			if (newpos == null) { 
				return;
			}
			row = newpos.row;
			col = newpos.col;
		}
		this.moveFocus(row, col, true, true, null, null, true); 
	},
	
	_getShiftPos: function(row, col, key) {
		var sheet = this.sheet,
			newPos = {row: row, col: col},
			fn = function() {return newPos};
		if (key == 'up') {
			fn = this._shiftUp;
		} else if (key == 'down') {
			fn = this._shiftDown;
		} else if (key == 'left') {
			fn = this._shiftLeft;
		} else if (key == 'right') {
			fn = this._shiftRight;
		} else if (key == 'home') {
			
			newPos = {row: 0, col: -1};
			fn = this._shiftRight;
		} else if (key == 'end') {
			
			fn = this._shiftLeft;
			newPos = {row: sheet.maxRows - 1, col: sheet.maxCols};
		}
		var count = 1000; 
		do {
			
			if (--count == 0) {
				this._fireShiftPos(sheet, row, col, key);
				return null;
			}
			newPos = fn.call(this, newPos);
		} while (this.sheet.isCellLocked(newPos.row, newPos.col) || 
			sheet.custRowHeight.isHidden(newPos.row) || sheet.custColWidth.isHidden(newPos.col));

		return newPos;
	},
	
	_shiftUp: function (pos) {
		var newpos = {row: pos.row - 1, col: pos.col},
			sheet = this.sheet;
		if (newpos.row < 0) {
			newpos.row = sheet.maxRows - 1;
			newpos.col = newpos.col > 0 ? newpos.col - 1 : sheet.maxCols - 1;
		}
		return newpos;
	},
	
	_shiftDown: function (pos) {
		var newpos = {row: pos.row + 1, col: pos.col},
			sheet = this.sheet;
		if (newpos.row >= sheet.maxRows) {
			newpos.row = 0;
			newpos.col = newpos.col < sheet.maxCols - 1 ? newpos.col + 1 : 0;
		}
		return newpos;
	},
	
	_shiftLeft: function (pos) {
		var newpos = {row: pos.row, col: pos.col - 1},
			sheet = this.sheet;
		if (newpos.col < 0) {
			newpos.col = sheet.maxCols - 1;
			newpos.row = newpos.row > 0 ? newpos.row - 1 : sheet.maxRows - 1;
		}
		return newpos;
	},
	
	_shiftRight: function (pos) {
		var newpos = {row: pos.row, col: pos.col + 1},
			sheet = this.sheet;
		if (newpos.col >= sheet.maxCols) {
			newpos.col = 0;
			newpos.row = newpos.row < sheet.maxRows - 1 ? newpos.row + 1 : 0;
		}
		return newpos;
	},
	
	_fireCtrlArrow: function (sheet, row, col, dir) {
		sheet._wgt.fire('onZSSCtrlArrow',
				{sheetId: sheet.serverSheetId, row: row, col: col, dir: dir}, {toServer: true});
	},
	
	_fireShiftPos: function (sheet, row, col, dir) {
		sheet._wgt.fire('onZSSShiftPos',
				{sheetId: sheet.serverSheetId, row: row, col: col, dir: dir}, {toServer: true});
	}		
});
})();