/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range;

import io.keikai.range.SExporter;
import io.keikai.range.SExporterFactory;
import io.keikai.range.impl.imexp.ExcelExportFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;

public class SExporters {
    private static final Log _logger = Log.lookup((String)SExporters.class.getName());
    private static HashMap<String, SExporterFactory> _factories = new LinkedHashMap<String, SExporterFactory>();

    public static final synchronized SExporter getExporter() {
        return SExporters.getExporter("excel");
    }

    public static final synchronized SExporter getExporter(String name) {
        SExporterFactory factory = _factories.get(name);
        if (factory != null) {
            return factory.createExporter();
        }
        throw new IllegalStateException("can find any exporter named " + name);
    }

    public static final synchronized void register(String name, SExporterFactory factory) {
        _factories.put(name, factory);
    }

    static {
        SExporters.register("excel", new ExcelExportFactory(ExcelExportFactory.Type.XLSX));
        SExporters.register("xlsx", new ExcelExportFactory(ExcelExportFactory.Type.XLSX));
        SExporters.register("xls", new ExcelExportFactory(ExcelExportFactory.Type.XLS));
        String clzs = Library.getProperty((String)"io.keikaiex.model.default.ExporterFactory.class");
        if (clzs != null) {
            try {
                String[] exporters;
                for (String exporter : exporters = clzs.split(",")) {
                    String[] keyValue = exporter.split("=");
                    try {
                        SExporters.register(keyValue[0], (SExporterFactory)Class.forName(keyValue[1]).newInstance());
                    }
                    catch (ClassNotFoundException e) {
                        _logger.warning("Can't find class for " + keyValue[0] + ":" + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

