/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model;

import io.keikai.model.SPictureData;
import io.keikai.model.SSheet;
import io.keikai.model.ViewAnchor;

public interface SPicture {
    public SSheet getSheet();

    public String getId();

    public Format getFormat();

    public byte[] getData();

    public ViewAnchor getAnchor();

    public void setAnchor(ViewAnchor var1);

    public SPictureData getPictureData();

    public static enum Format {
        DIB,
        EMF,
        GIF,
        JPG,
        PICT,
        PNG,
        WMF;


        public String getFileExtension() {
            return this.name().toLowerCase();
        }

        public static Format valueOfFileExtension(String fileExtension) {
            if (fileExtension.equalsIgnoreCase("dib")) {
                return DIB;
            }
            if (fileExtension.equalsIgnoreCase("emf")) {
                return EMF;
            }
            if (fileExtension.equalsIgnoreCase("gif")) {
                return GIF;
            }
            if (fileExtension.equalsIgnoreCase("jpg") || fileExtension.equalsIgnoreCase("jpeg")) {
                return JPG;
            }
            if (fileExtension.equalsIgnoreCase("pct") || fileExtension.equalsIgnoreCase("pict") || fileExtension.equalsIgnoreCase("pic")) {
                return PICT;
            }
            if (fileExtension.equalsIgnoreCase("png")) {
                return PNG;
            }
            if (fileExtension.equalsIgnoreCase("wmf")) {
                return WMF;
            }
            return null;
        }
    }
}

