/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.CellVisitor;
import io.keikai.api.Range;
import io.keikai.api.model.Sheet;
import io.keikai.model.SCell;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.ui.impl.undo.CellRichTextAction;
import io.keikai.ui.sys.UndoableAction;
import java.util.List;

public class ActionHelper {
    public static void collectRichTextStyleActions(Range range, final CellOperationUtil.CellStyleApplier applier, final List<UndoableAction> actions) {
        range.visit(new CellVisitor(){

            @Override
            public boolean visit(Range cellRange) {
                int row = cellRange.getRow();
                int column = cellRange.getColumn();
                Sheet sheet = cellRange.getSheet();
                SCell cell = sheet.getInternalSheet().getCell(row, column);
                if (!((AbstractCellAdv)cell).isRichTextValue()) {
                    return true;
                }
                CellRichTextAction action = new CellRichTextAction("", sheet, row, column, row, column, applier);
                actions.add(action);
                return true;
            }

            @Override
            public boolean ignoreIfNotExist(int row, int column) {
                return true;
            }

            @Override
            public boolean createIfNotExist(int row, int column) {
                return false;
            }
        });
    }
}

