/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.math.BigInteger;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.zkoss.poi.ss.usermodel.Comment;
import org.zkoss.poi.ss.usermodel.RichTextString;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.xssf.model.CommentsTable;
import org.zkoss.poi.xssf.usermodel.XSSFRichTextString;
import schemasMicrosoftComVml.CTShape;

public class XSSFComment
implements Comment {
    private final CTComment _comment;
    private final CommentsTable _comments;
    private final CTShape _vmlShape;
    private XSSFRichTextString _str;

    public XSSFComment(CommentsTable comments, CTComment comment, CTShape vmlShape) {
        this._comment = comment;
        this._comments = comments;
        this._vmlShape = vmlShape;
    }

    @Override
    public String getAuthor() {
        return this._comments.getAuthor((int)this._comment.getAuthorId());
    }

    @Override
    public void setAuthor(String author) {
        if (author == null) {
            author = "";
        }
        this._comment.setAuthorId((long)this._comments.findAuthor(author));
    }

    @Override
    public int getColumn() {
        return new CellReference(this._comment.getRef()).getCol();
    }

    @Override
    public int getRow() {
        return new CellReference(this._comment.getRef()).getRow();
    }

    @Override
    public boolean isVisible() {
        boolean visible = false;
        if (this._vmlShape != null) {
            String style = this._vmlShape.getStyle();
            visible = style != null && style.indexOf("visibility:visible") != -1;
        }
        return visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this._vmlShape != null) {
            String style = visible ? "position:absolute;visibility:visible" : "position:absolute;visibility:hidden";
            this._vmlShape.setStyle(style);
        }
    }

    @Override
    public void setColumn(int col) {
        String oldRef = this._comment.getRef();
        CellReference ref = new CellReference(this.getRow(), col);
        this._comment.setRef(ref.formatAsString());
        this._comments.referenceUpdated(oldRef, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setColumnArray(new BigInteger[]{new BigInteger(String.valueOf(col))});
            this._vmlShape.getClientDataList().toString();
        }
    }

    @Override
    public void setRow(int row) {
        String oldRef = this._comment.getRef();
        String newRef = new CellReference(row, this.getColumn()).formatAsString();
        this._comment.setRef(newRef);
        this._comments.referenceUpdated(oldRef, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setRowArray(0, new BigInteger(String.valueOf(row)));
            this._vmlShape.getClientDataList().toString();
        }
    }

    @Override
    public XSSFRichTextString getString() {
        CTRst rst;
        if (this._str == null && (rst = this._comment.getText()) != null) {
            this._str = new XSSFRichTextString(this._comment.getText());
        }
        return this._str;
    }

    @Override
    public void setString(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this._str = (XSSFRichTextString)string;
        this._comment.setText(this._str.getCTRst());
    }

    public void setString(String string) {
        this.setString(new XSSFRichTextString(string));
    }

    protected CTComment getCTComment() {
        return this._comment;
    }

    protected CTShape getCTShape() {
        return this._vmlShape;
    }
}

