/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hwpf.usermodel;

import java.util.Calendar;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndian;

public final class DateAndTime
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private static final BitField _minutes = BitFieldFactory.getInstance(63);
    private static final BitField _hours = BitFieldFactory.getInstance(1984);
    private static final BitField _dom = BitFieldFactory.getInstance(63488);
    private short _info2;
    private static final BitField _months = BitFieldFactory.getInstance(15);
    private static final BitField _years = BitFieldFactory.getInstance(8176);
    private static final BitField _weekday = BitFieldFactory.getInstance(57344);

    public DateAndTime() {
    }

    public DateAndTime(byte[] buf, int offset) {
        this._info = LittleEndian.getShort(buf, offset);
        this._info2 = LittleEndian.getShort(buf, offset + 2);
    }

    public Calendar getDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(_years.getValue(this._info2) + 1900, _months.getValue(this._info2) - 1, _dom.getValue(this._info), _hours.getValue(this._info), _minutes.getValue(this._info), 0);
        cal.set(14, 0);
        return cal;
    }

    public void serialize(byte[] buf, int offset) {
        LittleEndian.putShort(buf, offset, this._info);
        LittleEndian.putShort(buf, offset + 2, this._info2);
    }

    public boolean equals(Object o) {
        DateAndTime dttm = (DateAndTime)o;
        return this._info == dttm._info && this._info2 == dttm._info2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[DTTM] EMPTY";
        }
        return "[DTTM] " + this.getDate();
    }
}

