/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.model;

import org.zkoss.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.formula.FormulaParseException;
import org.zkoss.poi.ss.formula.FormulaParser;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderer;
import org.zkoss.poi.ss.formula.ptg.Ptg;

public final class HSSFFormulaParser {
    private static FormulaParsingWorkbook createParsingWorkbook(HSSFWorkbook book) {
        return HSSFEvaluationWorkbook.create(book);
    }

    private HSSFFormulaParser() {
    }

    public static Ptg[] parse(String formula, HSSFWorkbook workbook) throws FormulaParseException {
        return HSSFFormulaParser.parse(formula, workbook, 0);
    }

    public static Ptg[] parse(String formula, HSSFWorkbook workbook, int formulaType) throws FormulaParseException {
        return HSSFFormulaParser.parse(formula, workbook, formulaType, -1);
    }

    public static Ptg[] parse(String formula, HSSFWorkbook workbook, int formulaType, int sheetIndex) throws FormulaParseException {
        return FormulaParser.parse(formula, HSSFFormulaParser.createParsingWorkbook(workbook), formulaType, sheetIndex);
    }

    public static String toFormulaString(HSSFWorkbook book, Ptg[] ptgs) {
        return FormulaRenderer.toFormulaString(HSSFEvaluationWorkbook.create(book), ptgs);
    }
}

