/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.record;

public enum TextAutoNumberSchemeEnum {
    ANM_AlphaLcPeriod(0),
    ANM_AlphaUcPeriod(1),
    ANM_ArabicParenRight(2),
    ANM_ArabicPeriod(3),
    ANM_RomanLcParenBoth(4),
    ANM_RomanLcParenRight(5),
    ANM_RomanLcPeriod(6),
    ANM_RomanUcPeriod(7),
    ANM_AlphaLcParenBoth(8),
    ANM_AlphaLcParenRight(9),
    ANM_AlphaUcParenBoth(10),
    ANM_AlphaUcParenRight(11),
    ANM_ArabicParenBoth(12),
    ANM_ArabicPlain(13),
    ANM_RomanUcParenBoth(14),
    ANM_RomanUcParenRight(15),
    ANM_ChsPlain(16),
    ANM_ChsPeriod(17),
    ANM_CircleNumDBPlain(18),
    ANM_CircleNumWDBWhitePlain(19),
    ANM_CircleNumWDBBlackPlain(20),
    ANM_ChtPlain(21),
    ANM_ChtPeriod(22),
    ANM_Arabic1Minus(23),
    ANM_Arabic2Minus(24),
    ANM_Hebrew2Minus(25),
    ANM_JpnKorPlain(26),
    ANM_JpnKorPeriod(27),
    ANM_ArabicDbPlain(28),
    ANM_ArabicDbPeriod(29),
    ANM_ThaiAlphaPeriod(30),
    ANM_ThaiAlphaParenRight(31),
    ANM_ThaiAlphaParenBoth(32),
    ANM_ThaiNumPeriod(33),
    ANM_ThaiNumParenRight(34),
    ANM_ThaiNumParenBoth(35),
    ANM_HindiAlphaPeriod(36),
    ANM_HindiNumPeriod(37),
    ANM_JpnChsDBPeriod(38),
    ANM_HindiNumParenRight(39),
    ANM_HindiAlpha1Period(40);

    private final short value;

    private TextAutoNumberSchemeEnum(short code) {
        this.value = code;
    }

    private short getValue() {
        return this.value;
    }

    public String getDescription() {
        return TextAutoNumberSchemeEnum.getDescription(this);
    }

    public static String getDescription(TextAutoNumberSchemeEnum code) {
        switch (code) {
            case ANM_AlphaLcPeriod: {
                return "Lowercase Latin character followed by a period. Example: a., b., c., ...";
            }
            case ANM_AlphaUcPeriod: {
                return "Uppercase Latin character followed by a period. Example: A., B., C., ...";
            }
            case ANM_ArabicParenRight: {
                return "Arabic numeral followed by a closing parenthesis. Example: 1), 2), 3), ...";
            }
            case ANM_ArabicPeriod: {
                return "Arabic numeral followed by a period. Example: 1., 2., 3., ...";
            }
            case ANM_RomanLcParenBoth: {
                return "Lowercase Roman numeral enclosed in parentheses. Example: (i), (ii), (iii), ...";
            }
            case ANM_RomanLcParenRight: {
                return "Lowercase Roman numeral followed by a closing parenthesis. Example: i), ii), iii), ...";
            }
            case ANM_RomanLcPeriod: {
                return "Lowercase Roman numeral followed by a period. Example: i., ii., iii., ...";
            }
            case ANM_RomanUcPeriod: {
                return "Uppercase Roman numeral followed by a period. Example: I., II., III., ...";
            }
            case ANM_AlphaLcParenBoth: {
                return "Lowercase alphabetic character enclosed in parentheses. Example: (a), (b), (c), ...";
            }
            case ANM_AlphaLcParenRight: {
                return "Lowercase alphabetic character followed by a closing parenthesis. Example: a), b), c), ...";
            }
            case ANM_AlphaUcParenBoth: {
                return "Uppercase alphabetic character enclosed in parentheses. Example: (A), (B), (C), ...";
            }
            case ANM_AlphaUcParenRight: {
                return "Uppercase alphabetic character followed by a closing parenthesis. Example: A), B), C), ...";
            }
            case ANM_ArabicParenBoth: {
                return "Arabic numeral enclosed in parentheses. Example: (1), (2), (3), ...";
            }
            case ANM_ArabicPlain: {
                return "Arabic numeral. Example: 1, 2, 3, ...";
            }
            case ANM_RomanUcParenBoth: {
                return "Uppercase Roman numeral enclosed in parentheses. Example: (I), (II), (III), ...";
            }
            case ANM_RomanUcParenRight: {
                return "Uppercase Roman numeral followed by a closing parenthesis. Example: I), II), III), ...";
            }
            case ANM_ChsPlain: {
                return "Simplified Chinese.";
            }
            case ANM_ChsPeriod: {
                return "Simplified Chinese with single-byte period.";
            }
            case ANM_CircleNumDBPlain: {
                return "Double byte circle numbers.";
            }
            case ANM_CircleNumWDBWhitePlain: {
                return "Wingdings white circle numbers.";
            }
            case ANM_CircleNumWDBBlackPlain: {
                return "Wingdings black circle numbers.";
            }
            case ANM_ChtPlain: {
                return "Traditional Chinese.";
            }
            case ANM_ChtPeriod: {
                return "Traditional Chinese with single-byte period.";
            }
            case ANM_Arabic1Minus: {
                return "Bidi Arabic 1 (AraAlpha) with ANSI minus symbol.";
            }
            case ANM_Arabic2Minus: {
                return "Bidi Arabic 2 (AraAbjad) with ANSI minus symbol.";
            }
            case ANM_Hebrew2Minus: {
                return "Bidi Hebrew 2 with ANSI minus symbol.";
            }
            case ANM_JpnKorPlain: {
                return "Japanese/Korean.";
            }
            case ANM_JpnKorPeriod: {
                return "Japanese/Korean with single-byte period.";
            }
            case ANM_ArabicDbPlain: {
                return "Double-byte Arabic numbers.";
            }
            case ANM_ArabicDbPeriod: {
                return "Double-byte Arabic numbers with double-byte period.";
            }
            case ANM_ThaiAlphaPeriod: {
                return "Thai alphabetic character followed by a period.";
            }
            case ANM_ThaiAlphaParenRight: {
                return "Thai alphabetic character followed by a closing parenthesis.";
            }
            case ANM_ThaiAlphaParenBoth: {
                return "Thai alphabetic character enclosed by parentheses.";
            }
            case ANM_ThaiNumPeriod: {
                return "Thai numeral followed by a period.";
            }
            case ANM_ThaiNumParenRight: {
                return "Thai numeral followed by a closing parenthesis.";
            }
            case ANM_ThaiNumParenBoth: {
                return "Thai numeral enclosed in parentheses.";
            }
            case ANM_HindiAlphaPeriod: {
                return "Hindi alphabetic character followed by a period.";
            }
            case ANM_HindiNumPeriod: {
                return "Hindi numeric character followed by a period.";
            }
            case ANM_JpnChsDBPeriod: {
                return "Japanese with double-byte period.";
            }
            case ANM_HindiNumParenRight: {
                return "Hindi numeric character followed by a closing parenthesis.";
            }
            case ANM_HindiAlpha1Period: {
                return "Hindi alphabetic character followed by a period.";
            }
        }
        return "Unknown Numbered Scheme";
    }

    public static TextAutoNumberSchemeEnum valueOf(short autoNumberScheme) {
        for (TextAutoNumberSchemeEnum item : TextAutoNumberSchemeEnum.values()) {
            if (autoNumberScheme != item.getValue()) continue;
            return item;
        }
        return null;
    }
}

