/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.zkoss.poi.hslf.record.InteractiveInfoAtom;
import org.zkoss.poi.hslf.record.Record;
import org.zkoss.poi.hslf.record.RecordContainer;
import org.zkoss.poi.util.LittleEndian;

public class InteractiveInfo
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 4082L;
    private InteractiveInfoAtom infoAtom;

    public InteractiveInfoAtom getInteractiveInfoAtom() {
        return this.infoAtom;
    }

    protected InteractiveInfo(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (!(this._children[0] instanceof InteractiveInfoAtom)) {
            throw new IllegalStateException("First child record wasn't a InteractiveInfoAtom, was of type " + this._children[0].getRecordType());
        }
        this.infoAtom = (InteractiveInfoAtom)this._children[0];
    }

    public InteractiveInfo() {
        this._children = new Record[1];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)_type);
        this.infoAtom = new InteractiveInfoAtom();
        this._children[0] = this.infoAtom;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

