/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget.general;

import java.awt.Image;
import org.netbeans.api.visual.laf.LookFeel;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class IconNodeWidget
extends Widget {
    private ImageWidget imageWidget;
    private LabelWidget labelWidget;

    public IconNodeWidget(Scene scene) {
        this(scene, TextOrientation.BOTTOM_CENTER);
    }

    public IconNodeWidget(Scene scene, TextOrientation orientation) {
        super(scene);
        LookFeel lookFeel = this.getScene().getLookFeel();
        switch (orientation) {
            case BOTTOM_CENTER: {
                this.setLayout(LayoutFactory.createVerticalFlowLayout(LayoutFactory.SerialAlignment.CENTER, -lookFeel.getMargin() + 1));
                break;
            }
            case RIGHT_CENTER: {
                this.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.CENTER, -lookFeel.getMargin() + 1));
            }
        }
        this.imageWidget = new ImageWidget(scene);
        this.addChild(this.imageWidget);
        this.labelWidget = new LabelWidget(scene);
        this.labelWidget.setFont(scene.getDefaultFont().deriveFont(14.0f));
        this.addChild(this.labelWidget);
        this.setState(ObjectState.createNormal());
    }

    @Override
    public void notifyStateChanged(ObjectState previousState, ObjectState state) {
        LookFeel lookFeel = this.getScene().getLookFeel();
        this.labelWidget.setBorder(lookFeel.getBorder(state));
        this.labelWidget.setForeground(lookFeel.getForeground(state));
    }

    public final void setImage(Image image) {
        this.imageWidget.setImage(image);
    }

    public final void setLabel(String label) {
        this.labelWidget.setLabel(label);
    }

    public final ImageWidget getImageWidget() {
        return this.imageWidget;
    }

    public final LabelWidget getLabelWidget() {
        return this.labelWidget;
    }

    public static enum TextOrientation {
        BOTTOM_CENTER,
        RIGHT_CENTER;

    }
}

