/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.panel.InfoPanel;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListSubModel;

public class InfoListSubModel
implements ListSubModel<ValueNamePair> {
    private Lookup lookup;
    private GridField gridField;
    private String tableName;
    private String keyColumnName;
    private String whereClause;
    private static final int AUTO_COMPLETE_QUERY_TIMEOUT = 1;

    public InfoListSubModel(Lookup lookup, GridField gridField, String tableName, String keyColumnName) {
        this.lookup = lookup;
        this.gridField = gridField;
        this.tableName = tableName;
        this.keyColumnName = keyColumnName;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public ListModel<ValueNamePair> getSubModel(Object value, int nRows) {
        ListModelList model = new ListModelList();
        if (value != null && !Util.isEmpty((String)value.toString(), (boolean)true)) {
            int rowCount;
            String queryText = value.toString().trim();
            StringBuilder queryBuilder = new StringBuilder(queryText);
            queryBuilder.append("?autocomplete={");
            queryBuilder.append("timeout:").append(1).append(",").append("pagesize:").append(nRows);
            if (this.lookup instanceof MLookup) {
                MLookup mlookup = (MLookup)this.lookup;
                List displayColumns = mlookup.getLookupInfo().lookupDisplayColumnNames;
                if (displayColumns != null && displayColumns.size() > 0) {
                    queryBuilder.append(",").append("searchcolumn:").append((String)displayColumns.get(0));
                }
            }
            queryBuilder.append("}");
            queryText = queryBuilder.toString();
            InfoPanel ip = InfoManager.create(this.lookup, this.gridField, this.tableName, this.keyColumnName, queryText, false, this.getWhereClause());
            if (ip != null && ip.loadedOK() && (rowCount = ip.getRowCount()) > 0) {
                NamePair[] namePairs;
                ArrayList<String> added = new ArrayList<String>();
                ArrayList<Object> keys = new ArrayList<Object>();
                int i = 0;
                while (i < rowCount) {
                    Object key = ip.getRowKeyAt(i);
                    if (key != null && (key instanceof Integer && (Integer)key > 0 || key instanceof String && key.toString().length() > 0) && !keys.contains(key)) {
                        keys.add(key);
                    }
                    if (nRows > 0 && keys.size() >= nRows) break;
                    ++i;
                }
                NamePair[] namePairArray = namePairs = this.lookup.getDirect(keys.toArray());
                int n = namePairs.length;
                int n2 = 0;
                while (n2 < n) {
                    NamePair np = namePairArray[n2];
                    String name = np.getName();
                    if (!added.contains(name)) {
                        added.add(name);
                        ValueNamePair pair = new ValueNamePair(np.getID(), name);
                        model.add((Object)pair);
                        if (nRows > 0 && added.size() >= nRows) break;
                    }
                    ++n2;
                }
            }
        }
        return model;
    }
}

