/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.MenuItem;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.desktop.FavouriteController;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeItemAction;
import org.adempiere.webui.util.TreeNodeAction;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MMenu;
import org.compiere.model.MPreference;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MTreeNode;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListModels;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.impl.LabelElement;
import org.zkoss.zul.impl.LabelImageElement;

public class MenuSearchController
implements EventListener<Event> {
    private static final int INITIAL_LOADING_SIZE = 50;
    public static final String M_TREE_NODE_ATTR = "MTreeNode";
    private static final String Z_ICON_STAR_O = "z-icon-star-o";
    private static final String Z_ICON_STAR = "z-icon-star";
    private static final String ON_SEARCH_ECHO_EVENT = "onSearchEcho";
    private static final String ON_LOAD_MORE_EVENT = "onLoadMore";
    private static final String ONSELECT_TIMESTAMP_ATTR = "onselect.timestamp";
    private static final String STAR_BUTTON_NAME = "Star";
    private static final String NEW_BUTTON_NAME = "New";
    private Tree tree;
    private org.adempiere.webui.component.Listbox listbox;
    private ListModelList<MenuItem> model;
    private Vlayout layout;
    private ListModelList<MenuItem> fullModel;
    private boolean inStarEvent;
    private String highlightText = null;
    private List<String> recentMenuItemIds = new ArrayList<String>();
    private static final String ON_POST_SELECT_TREEITEM_EVENT = "onPostSelectTreeitem";

    public MenuSearchController(Tree tree) {
        this.tree = tree;
    }

    private List<String> loadRecentItems() {
        ArrayList<String> recents = new ArrayList<String>();
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
        int AD_Org_ID = 0;
        String attribute = AD_Role_ID + "|RecentMenuItems";
        Query query = new Query(Env.getCtx(), "AD_Preference", "PreferenceFor=? AND Attribute=? AND AD_Org_ID=? AND AD_User_ID=? AND AD_Window_ID=?", null);
        MPreference preference = (MPreference)query.setClient_ID().setParameters(new Object[]{"W", attribute, AD_Org_ID, AD_User_ID, 105}).first();
        if (preference != null) {
            String[] recentItems;
            String[] stringArray = recentItems = preference.getValue().split("[,]");
            int n = recentItems.length;
            int n2 = 0;
            while (n2 < n) {
                String recentItem = stringArray[n2];
                recents.add(recentItem);
                ++n2;
            }
        }
        return recents;
    }

    public void updateRecentItems() {
        List<String> recents = this.loadRecentItems();
        if (!recents.equals(this.recentMenuItemIds)) {
            this.recentMenuItemIds = recents;
            this.sortMenuItemModel();
            this.moveRecentItems();
            if (this.fullModel != null) {
                this.updateListboxModel(this.model);
            }
        }
    }

    public void refreshModel() {
        this.recentMenuItemIds = this.loadRecentItems();
        final ArrayList list = new ArrayList();
        if (this.tree.getModel() == null) {
            TreeUtils.traverse(this.tree, new TreeItemAction(){

                @Override
                public void run(Treeitem treeItem) {
                    if (treeItem.isVisible()) {
                        MenuSearchController.this.addTreeItem((List<MenuItem>)list, treeItem);
                    }
                }
            });
        } else {
            TreeUtils.traverse((TreeModel<Object>)this.tree.getModel(), new TreeNodeAction(){

                @Override
                public void run(DefaultTreeNode<?> treeNode) {
                    MenuSearchController.this.addTreeItem((List<MenuItem>)list, treeNode);
                }
            });
        }
        this.model = new ListModelList(list, true);
        this.sortMenuItemModel();
        this.moveRecentItems();
    }

    private void sortMenuItemModel() {
        this.model.sort((Comparator)new Comparator<MenuItem>(){

            @Override
            public int compare(MenuItem o1, MenuItem o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        }, true);
    }

    /*
     * WARNING - void declaration
     */
    private void moveRecentItems() {
        if (this.recentMenuItemIds.size() > 0) {
            ArrayList<MenuItem> recents = new ArrayList<MenuItem>();
            block0: for (String id : this.recentMenuItemIds) {
                int i = 0;
                while (i < this.model.getSize()) {
                    Object object = ((MenuItem)this.model.get(i)).getData();
                    if (object instanceof Treeitem) {
                        void ti;
                        Treeitem cfr_ignored_0 = (Treeitem)object;
                        Treeitem cfr_ignored_1 = (Treeitem)object;
                        Object object2 = ti.getValue();
                        if (object2 instanceof String) {
                            void tis;
                            String cfr_ignored_2 = (String)object2;
                            String cfr_ignored_3 = (String)object2;
                            if (tis.equals(id)) {
                                recents.add((MenuItem)this.model.get(i));
                                continue block0;
                            }
                        }
                    }
                    ++i;
                }
            }
            if (recents.size() > 0) {
                for (MenuItem mi : recents) {
                    this.model.remove((Object)mi);
                }
                int i = recents.size() - 1;
                while (i >= 0) {
                    this.model.add(0, (Object)((MenuItem)recents.get(i)));
                    --i;
                }
            }
        }
    }

    private void addTreeItem(List<MenuItem> list, DefaultTreeNode<?> treeNode) {
        MTreeNode mNode = (MTreeNode)treeNode.getData();
        if (!mNode.isLeaf()) {
            return;
        }
        MenuItem item = new MenuItem();
        item.setLabel(mNode.getName());
        item.setDescription(mNode.getDescription());
        item.setImage(mNode.getImagePath());
        item.setData(treeNode);
        list.add(item);
    }

    private boolean isFolder(Treeitem treeItem) {
        List list = treeItem.getChildren();
        for (Component c : list) {
            if (!(c instanceof Treechildren) || ((Treechildren)c).getChildren().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addTreeItem(List<MenuItem> list, Treeitem treeItem) {
        if (this.isFolder(treeItem)) {
            return;
        }
        MenuItem item = new MenuItem();
        item.setLabel(this.getLabel(treeItem));
        item.setDescription(treeItem.getTooltiptext());
        String image = this.getImage(treeItem);
        if (image == null || image.length() == 0) {
            image = ThemeManager.getThemeResource("images/Folder16.png");
        }
        item.setImage(image);
        item.setData(treeItem);
        list.add(item);
        item.setType((String)treeItem.getAttribute("menu.type"));
    }

    private String getLabel(Treeitem treeItem) {
        String label = treeItem.getLabel();
        if ((label == null || label.trim().length() == 0) && treeItem.getTreerow().getFirstChild().getFirstChild() != null && treeItem.getTreerow().getFirstChild().getFirstChild() instanceof LabelElement) {
            LabelElement element = (LabelElement)treeItem.getTreerow().getFirstChild().getFirstChild();
            label = element.getLabel();
        }
        return label;
    }

    private String getImage(Treeitem treeItem) {
        String image = treeItem.getImage();
        if ((image == null || image.trim().length() == 0) && treeItem.getTreerow().getFirstChild().getFirstChild() != null && treeItem.getTreerow().getFirstChild().getFirstChild() instanceof LabelImageElement) {
            LabelImageElement element = (LabelImageElement)treeItem.getTreerow().getFirstChild().getFirstChild();
            image = ThemeManager.isUseFontIconForImage() && element.getIconSclass() != null ? element.getIconSclass() : element.getImage();
        }
        return image != null ? image.intern() : null;
    }

    public void create(Component parent) {
        this.refreshModel();
        this.layout = new Vlayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.layout, "100%");
        parent.appendChild((Component)this.layout);
        this.listbox = new org.adempiere.webui.component.Listbox();
        this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"FindZeroRecords")));
        this.listbox.setStyle("border: none");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.listbox, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, "true");
        this.layout.appendChild((Component)this.listbox);
        this.listbox.setItemRenderer(new MenuItemRenderer());
        this.listbox.addEventListener("onSelect", this);
        this.listbox.addEventListener(ON_POST_SELECT_TREEITEM_EVENT, this);
        ListHead listhead = new ListHead();
        this.listbox.appendChild((Component)listhead);
        Listheader listheader = new Listheader();
        listhead.appendChild((Component)listheader);
        listheader = new Listheader();
        listheader.setAlign("center");
        listheader.setValign("middle");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)listheader, "28px");
        listhead.appendChild((Component)listheader);
        listheader = new Listheader();
        listheader.setAlign("center");
        listheader.setValign("middle");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)listheader, "28px");
        listhead.appendChild((Component)listheader);
        this.layout.addEventListener(ON_SEARCH_ECHO_EVENT, (EventListener)this);
        this.layout.addEventListener(ON_LOAD_MORE_EVENT, (EventListener)this);
        this.updateListboxModel(this.model);
        FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getSession());
        controller.addDeletedCallback((Callback<Integer>)((Callback)t -> this.onDeletedCallback((Integer)t)));
        controller.addInsertedCallback((Callback<MTreeNode>)((Callback)t -> this.onInsertedCallback((MTreeNode)t)));
    }

    public void onEvent(Event event) throws Exception {
        if ("onSelect".equals(event.getName())) {
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return;
            }
            this.onSelect(selected, Boolean.FALSE);
        } else if (event.getName().equals(ON_POST_SELECT_TREEITEM_EVENT)) {
            this.onPostSelectTreeitem((Boolean)event.getData());
        } else if ("onClick".equals(event.getName())) {
            if (event.getTarget() instanceof ListItem) {
                ListItem item = (ListItem)event.getTarget();
                Long onSelect = (Long)item.getAttribute(ONSELECT_TIMESTAMP_ATTR);
                if (onSelect == null) {
                    this.onSelect(item, Boolean.FALSE);
                } else if (System.currentTimeMillis() - onSelect > 1000L) {
                    this.onSelect(item, Boolean.FALSE);
                }
            } else if (event.getTarget() instanceof ToolBarButton) {
                ToolBarButton btn = (ToolBarButton)event.getTarget();
                if (NEW_BUTTON_NAME.equals(btn.getName())) {
                    ListItem item = null;
                    Component parent = event.getTarget();
                    while (parent != null) {
                        if (parent instanceof ListItem) {
                            item = (ListItem)parent;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (item != null) {
                        this.onSelect(item, Boolean.TRUE);
                    }
                } else if (STAR_BUTTON_NAME.equals(btn.getName())) {
                    this.inStarEvent = true;
                    FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getSession());
                    if (Z_ICON_STAR_O.equals(btn.getIconSclass())) {
                        btn.setIconSclass(Z_ICON_STAR);
                        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"RemoveFromFavourites"));
                        controller.addNode((MTreeNode)btn.getAttribute(M_TREE_NODE_ATTR));
                    } else if (Z_ICON_STAR.equals(btn.getIconSclass())) {
                        btn.setIconSclass(Z_ICON_STAR_O);
                        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AddToFavourites"));
                        controller.removeNode(((MTreeNode)btn.getAttribute(M_TREE_NODE_ATTR)).getNode_ID());
                    }
                    this.inStarEvent = false;
                }
            }
        } else if (event.getName().equals(ON_SEARCH_ECHO_EVENT)) {
            this.onSearchEcho((String)event.getData());
        } else if (event.getName().equals(ON_LOAD_MORE_EVENT)) {
            this.loadMore();
        }
    }

    private void onInsertedCallback(MTreeNode node) {
        if (this.inStarEvent) {
            return;
        }
        ListModel t = this.listbox.getModel();
        this.listbox.setModel(null);
        this.listbox.setModel(t);
    }

    private void onDeletedCallback(Integer nodeId) {
        if (this.inStarEvent) {
            return;
        }
        ListModel t = this.listbox.getModel();
        this.listbox.setModel(null);
        this.listbox.setModel(t);
    }

    private void onSelect(ListItem selected, Boolean newRecord) {
        MenuItem item = (MenuItem)selected.getValue();
        if (item == null) {
            return;
        }
        if ("...".equals(item.getType())) {
            selected.setAttribute(ONSELECT_TIMESTAMP_ATTR, System.currentTimeMillis());
            Clients.showBusy((Component)selected, null);
            Events.echoEvent((String)ON_LOAD_MORE_EVENT, (Component)this.layout, null);
        } else {
            Treeitem ti;
            MMenu menu;
            if (newRecord.booleanValue() && MToolBarButtonRestrict.isNewButtonRestricted((int)(menu = MMenu.get((int)Integer.parseInt((String)(ti = (Treeitem)item.getData()).getValue()))).getAD_Window_ID())) {
                newRecord = false;
            }
            this.selectTreeitem(item.getData(), newRecord);
            selected.setAttribute(ONSELECT_TIMESTAMP_ATTR, System.currentTimeMillis());
        }
    }

    private void loadMore() {
        ListModel listModel = this.listbox.getModel();
        ListModelList lml = (ListModelList)listModel;
        lml.remove(lml.size() - 1);
        List subList = this.fullModel.subList(50, this.fullModel.size());
        lml.addAll((Collection)subList);
        this.fullModel = null;
        this.listbox.setSelectedIndex(50);
        Clients.scrollIntoView((Component)this.listbox.getSelectedItem());
    }

    private void selectTreeitem(Object node, Boolean newRecord) {
        if (Executions.getCurrent().getAttribute(this.listbox.getUuid() + ".selectTreeitem") != null) {
            return;
        }
        Treeitem treeItem = null;
        if (node == null) {
            return;
        }
        if (node instanceof Treeitem) {
            treeItem = (Treeitem)node;
        } else {
            DefaultTreeNode sNode = (DefaultTreeNode)node;
            int[] path = this.tree.getModel().getPath((Object)sNode);
            treeItem = this.tree.renderItemByPath(path);
            this.tree.setSelectedItem(treeItem);
        }
        if (treeItem != null) {
            Executions.getCurrent().setAttribute(this.listbox.getUuid() + ".selectTreeitem", (Object)Boolean.TRUE);
            this.select(treeItem);
            Events.postEvent((String)ON_POST_SELECT_TREEITEM_EVENT, (Component)this.listbox, (Object)newRecord);
        }
    }

    private void select(Treeitem selectedItem) {
        Treeitem parent = selectedItem.getParentItem();
        while (parent != null) {
            if (!parent.isOpen()) {
                parent.setOpen(true);
            }
            parent = parent.getParentItem();
        }
        selectedItem.getTree().setSelectedItem(selectedItem);
    }

    private void onPostSelectTreeitem(Boolean newRecord) {
        Event event = null;
        event = this.tree.getSelectedItem().getTreerow().getFirstChild().getFirstChild() instanceof A ? new Event("onClick", this.tree.getSelectedItem().getTreerow().getFirstChild().getFirstChild(), (Object)newRecord) : new Event("onClick", (Component)this.tree.getSelectedItem().getTreerow(), (Object)newRecord);
        Events.postEvent((Event)event);
    }

    public void search(String value) {
        this.listbox.setModel(null);
        Events.echoEvent((String)ON_SEARCH_ECHO_EVENT, (Component)this.layout, (String)value);
    }

    public void onSearchEcho(String value) {
        ListModelList newModel = null;
        if (Util.isEmpty((String)value)) {
            newModel = this.model;
        } else {
            ListSubModel subModel = (ListSubModel)ListModels.toListSubModel(this.model, (Comparator)new MenuListComparator(value), (int)this.model.size());
            newModel = (ListModelList)subModel.getSubModel(null, -1);
        }
        this.updateListboxModel(newModel);
    }

    private void updateListboxModel(ListModelList<MenuItem> newModel) {
        this.fullModel = null;
        if (newModel.size() > 50) {
            List list = newModel.getInnerList();
            List subList = list.subList(0, 50);
            this.fullModel = newModel;
            newModel = new ListModelList((Object[])subList.toArray(new MenuItem[0]));
            MenuItem more = new MenuItem();
            more.setLabel("...");
            more.setType("...");
            newModel.add((Object)more);
        }
        this.listbox.setModel((ListModel)newModel);
    }

    public MenuItem selectPrior() {
        int i = this.listbox.getSelectedIndex();
        if (i > 0) {
            this.listbox.setSelectedIndex(i - 1);
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return null;
            }
            Clients.scrollIntoView((Component)selected);
            MenuItem item = (MenuItem)selected.getValue();
            return item;
        }
        return null;
    }

    public MenuItem selectNext() {
        int i = this.listbox.getSelectedIndex();
        if (i < 0 && this.listbox.getItemCount() > 0) {
            this.listbox.setSelectedIndex(0);
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return null;
            }
            MenuItem item = (MenuItem)selected.getValue();
            return item;
        }
        if (i + 1 < this.listbox.getItemCount()) {
            this.listbox.setSelectedIndex(i + 1);
            ListItem selected = this.listbox.getSelectedItem();
            if (selected == null) {
                return null;
            }
            MenuItem item = (MenuItem)selected.getValue();
            if (item == null) {
                return null;
            }
            if ("...".equals(item.getType())) {
                this.onSelect(selected, Boolean.FALSE);
            }
            Clients.scrollIntoView((Component)selected);
            return item;
        }
        return null;
    }

    public boolean onOk(Textbox textbox) {
        String text = textbox.getText();
        if (Util.isEmpty((String)text)) {
            return false;
        }
        text = text.toLowerCase();
        ListItem exact = null;
        ListItem firstStart = null;
        int count = this.listbox.getItemCount();
        int i = 0;
        while (i < count) {
            ListItem item = this.listbox.getItemAtIndex(i);
            MenuItem menuItem = (MenuItem)item.getValue();
            String label = menuItem.getLabel();
            if (!Util.isEmpty((String)label)) {
                if (label.equalsIgnoreCase(text)) {
                    exact = item;
                    break;
                }
                if (firstStart == null && label.toLowerCase().startsWith(text) && text.length() >= 3) {
                    firstStart = item;
                }
            }
            ++i;
        }
        if (exact != null) {
            MenuItem menuItem = (MenuItem)exact.getValue();
            textbox.setText(menuItem.getLabel());
            this.onSelect(exact, false);
            return true;
        }
        if (firstStart != null) {
            MenuItem menuItem = (MenuItem)firstStart.getValue();
            textbox.setText(menuItem.getLabel());
            this.onSelect(firstStart, false);
            return true;
        }
        return false;
    }

    public void setHighlightText(String s) {
        this.highlightText = s;
    }

    private class MenuItemRenderer
    implements ListitemRenderer<MenuItem>,
    ListitemRendererExt {
        private static final String REMOVE_FROM_FAVOURITES_MSG = "RemoveFromFavourites";
        private static final String ADD_TO_FAVOURITES_MSG = "AddToFavourites";

        private MenuItemRenderer() {
        }

        public Listitem newListitem(Listbox listbox) {
            return new ListItem();
        }

        public Listcell newListcell(Listitem item) {
            return new Listcell(item.getLabel());
        }

        public int getControls() {
            return 1;
        }

        public void render(Listitem item, MenuItem data, int index) throws Exception {
            Treeitem value;
            boolean isWindow;
            Listcell cell = new Listcell(data.getLabel(), data.getImage());
            if (ThemeManager.isUseFontIconForImage() && data.getImage() != null && data.getImage().startsWith("z-icon")) {
                cell.setImage(null);
                cell.setIconSclass(data.getImage());
            }
            if (!Util.isEmpty((String)MenuSearchController.this.highlightText, (boolean)true) && data.getLabel().toLowerCase().contains(MenuSearchController.this.highlightText.toLowerCase())) {
                cell.setLabel(" ");
                String label = data.getLabel();
                String matchString = MenuSearchController.this.highlightText.toLowerCase();
                int match = label.toLowerCase().indexOf(matchString);
                while (match >= 0) {
                    if (match > 0) {
                        cell.appendChild((Component)new Label(label.substring(0, match)));
                        l = new Label(label.substring(match, match + matchString.length()));
                        LayoutUtils.addSclass("highlight", (HtmlBasedComponent)l);
                        cell.appendChild((Component)l);
                        label = label.substring(match + matchString.length());
                    } else {
                        l = new Label(label.substring(0, matchString.length()));
                        LayoutUtils.addSclass("highlight", (HtmlBasedComponent)l);
                        cell.appendChild((Component)l);
                        label = label.substring(matchString.length());
                    }
                    match = label.toLowerCase().indexOf(matchString);
                }
                if (label.length() > 0) {
                    cell.appendChild((Component)new Label(label));
                }
            }
            item.appendChild((Component)cell);
            cell.setTooltip(data.getDescription());
            item.setValue((Object)data);
            item.addEventListener("onClick", (EventListener)MenuSearchController.this);
            cell = new Listcell();
            cell.setSclass("menu-search-list-toolbar-cell");
            item.appendChild((Component)cell);
            boolean bl = isWindow = data.getType() != null && data.getType().equals("window");
            if (isWindow) {
                ToolBarButton newBtn = new ToolBarButton();
                if (ThemeManager.isUseFontIconForImage()) {
                    newBtn.setIconSclass("z-icon-New");
                } else {
                    newBtn.setImage(ThemeManager.getThemeResource("images/New16.png"));
                }
                newBtn.addEventListener("onClick", MenuSearchController.this);
                newBtn.setSclass("fav-new-btn");
                newBtn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)MenuSearchController.NEW_BUTTON_NAME)));
                newBtn.setName(MenuSearchController.NEW_BUTTON_NAME);
                cell.appendChild((Component)newBtn);
            }
            cell = new Listcell();
            cell.setSclass("menu-search-list-toolbar-cell");
            item.appendChild((Component)cell);
            MTreeNode node = null;
            if (data.getData() instanceof MTreeNode) {
                node = (MTreeNode)data.getData();
            } else if (data.getData() instanceof Treeitem && (value = (Treeitem)data.getData()) != null) {
                node = (MTreeNode)value.getAttribute(MenuSearchController.M_TREE_NODE_ATTR);
            }
            if (node != null) {
                FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getSession());
                ToolBarButton starBtn = new ToolBarButton();
                starBtn.setAttribute(MenuSearchController.M_TREE_NODE_ATTR, node);
                starBtn.setName(MenuSearchController.STAR_BUTTON_NAME);
                if (controller.hasNode(node.getNode_ID())) {
                    starBtn.setIconSclass(MenuSearchController.Z_ICON_STAR);
                    starBtn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)REMOVE_FROM_FAVOURITES_MSG));
                } else {
                    starBtn.setIconSclass(MenuSearchController.Z_ICON_STAR_O);
                    starBtn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)ADD_TO_FAVOURITES_MSG));
                }
                cell.appendChild((Component)starBtn);
                starBtn.addEventListener("onClick", MenuSearchController.this);
                starBtn.setSclass("fav-new-btn");
            }
        }
    }

    private class MenuListComparator
    implements Comparator<MenuItem> {
        private String compare;

        private MenuListComparator(String compare) {
            this.compare = Util.deleteAccents((String)compare.toLowerCase().trim());
        }

        @Override
        public int compare(MenuItem o1, MenuItem o2) {
            String label2 = Util.deleteAccents((String)o2.getLabel().toLowerCase());
            boolean match = false;
            match = this.compare.length() < 3 ? label2.startsWith(this.compare) : label2.contains(this.compare);
            return match ? 0 : -1;
        }
    }
}

