/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.report;

import com.google.common.net.MediaType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.print.ReportEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.IReportRendererConfiguration;
import org.idempiere.print.renderer.PSReportRendererConfiguration;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.osgi.service.component.annotations.Component;
import org.zkoss.util.media.AMedia;

@Component(service={IReportViewerRenderer.class}, immediate=true)
public class PSReportViewerRenderer
implements IReportViewerRenderer {
    @Override
    public String getId() {
        return "PS";
    }

    @Override
    public String getExportLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FilePS");
    }

    @Override
    public String getContentType() {
        return MediaType.POSTSCRIPT.toString();
    }

    @Override
    public String getFileExtension() {
        return "ps";
    }

    @Override
    public boolean isExport() {
        return true;
    }

    @Override
    public boolean isPreview(boolean roleCanExport) {
        return false;
    }

    @Override
    public AMedia renderMedia(ZkReportViewer viewer, boolean export) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ReportEngine m_reportEngine = viewer.getReportEngine();
        m_reportEngine.createPS((OutputStream)baos);
        IReportRenderer renderer = Core.getReportRenderer((String)this.getId());
        PSReportRendererConfiguration config = new PSReportRendererConfiguration().setOutputStream((OutputStream)baos);
        renderer.renderReport(m_reportEngine, (IReportRendererConfiguration)config);
        byte[] data = baos.toByteArray();
        return new AMedia(m_reportEngine.getName() + "." + this.getFileExtension(), this.getFileExtension(), this.getContentType(), data);
    }
}

