/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.h3;
import org.apache.ecs.xhtml.h4;
import org.apache.ecs.xhtml.h5;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;

public class HelpWindow
extends Window {
    private static final long serialVersionUID = -7353411576541612026L;
    private GridWindow gridWindow;
    private String winpref;

    public HelpWindow(GridWindow gridWindow) {
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Help"));
        this.gridWindow = gridWindow;
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        this.setAttribute("mode", "embedded");
        this.setSclass("help-window");
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        Div div = new Div();
        centerPane.appendChild((Component)div);
        div.setStyle("width: 100%; height: 100%; overflow: auto;");
        Html html = new Html();
        div.appendChild((Component)html);
        WebDoc doc = WebDoc.create((boolean)true);
        table table2 = new table("0", "0", "0", "100%", null);
        doc.getBody().addElement((Element)table2);
        tr tr2 = new tr();
        table2.addElement((Element)tr2);
        td td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement((Element)this.getHeader());
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement((Element)this.getContent());
        html.setContent(doc.toString());
    }

    private table getHeader() {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-header");
        tr tr2 = new tr();
        table2.addElement((Element)tr2);
        td td2 = new td();
        td2.setClass("help-window-title");
        tr2.addElement((Element)td2);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("ddHHmmss");
        String dt = sdf.format(cal.getTime());
        this.winpref = "Win" + dt;
        td2.addElement((Element)new a().setName(this.winpref));
        StringBuilder title = new StringBuilder(Msg.getMsg((Properties)Env.getCtx(), (String)"Window")).append(": ").append(this.gridWindow.getName());
        h3 h32 = new h3(title.toString());
        td2.addElement((Element)h32);
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement("&nbsp;");
        if (this.gridWindow.getDescription().length() != 0) {
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            td2.setClass("help-window-description");
            tr2.addElement((Element)td2);
            td2.addElement((Element)new p().addElement(this.gridWindow.getDescription()));
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement("&nbsp;");
        }
        if (this.gridWindow.getHelp().length() != 0) {
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            td2.setClass("help-window-help");
            tr2.addElement((Element)td2);
            td2.addElement((Element)new p().addElement(this.gridWindow.getHelp()));
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement("&nbsp;");
        }
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        td2.setClass("help-window-tabs");
        tr2.addElement((Element)td2);
        td2.addElement((Element)new a().setName(this.winpref + "Tabs"));
        h4 h42 = new h4(Msg.getMsg((Properties)Env.getCtx(), (String)"Tabs"));
        td2.addElement((Element)h42);
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement("&nbsp;");
        return table2;
    }

    private table getContent() {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-content");
        tr tr2 = new tr();
        tr2.setVAlign("top");
        table2.addElement((Element)tr2);
        td td2 = new td();
        td2.setWidth("20%");
        tr2.addElement((Element)td2);
        td2.addElement((Element)this.getLeftContent());
        td2 = new td();
        td2.setWidth("80%");
        tr2.addElement((Element)td2);
        td2.addElement((Element)this.getRightContent());
        return table2;
    }

    private table getLeftContent() {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-content-l");
        int size = this.gridWindow.getTabCount();
        int i = 0;
        while (i < size) {
            tr tr2 = new tr();
            table2.addElement((Element)tr2);
            td td2 = new td();
            tr2.addElement((Element)td2);
            GridTab tab = this.gridWindow.getTab(i);
            td2.addElement((Element)new a("#" + this.winpref + "Tab" + i).addElement(tab.getName()));
            ++i;
        }
        return table2;
    }

    private table getRightContent() {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-content-r");
        int size = this.gridWindow.getTabCount();
        int i = 0;
        while (i < size) {
            GridTab tab = this.gridWindow.getTab(i);
            tr tr2 = new tr();
            table2.addElement((Element)tr2);
            td td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement((Element)this.getTabBox(tab, i));
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement((Element)this.getFieldsBox(tab, i));
            int j = 0;
            while (j < tab.getFieldCount()) {
                String hdr;
                GridField field = tab.getField(j);
                if (field.isDisplayed(false) && (hdr = field.getHeader()) != null && hdr.length() > 0) {
                    tr2 = new tr();
                    table2.addElement((Element)tr2);
                    td2 = new td();
                    tr2.addElement((Element)td2);
                    td2.addElement((Element)this.getFieldBox(field, i, j));
                }
                ++j;
            }
            ++i;
        }
        return table2;
    }

    private table getTabBox(GridTab tab, int tabIndex) {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-tab");
        tr tr2 = new tr();
        tr2.setClass("help-window-tab-header");
        table2.addElement((Element)tr2);
        td td2 = new td();
        td2.setClass("help-window-tab-name");
        td2.setWidth("40%");
        tr2.addElement((Element)td2);
        td2.addElement((Element)new a().setName(this.winpref + "Tab" + tabIndex));
        h3 h32 = new h3(Msg.getMsg((Properties)Env.getCtx(), (String)"Tab") + ": " + tab.getName());
        td2.addElement((Element)h32);
        td2.addElement("&nbsp;").addElement("&nbsp;");
        td2.addElement(new a("#" + this.winpref).addElement("..").addAttribute("title", "Up one level"));
        td2 = new td();
        td2.setClass("help-window-tab-description");
        td2.setWidth("60%");
        tr2.addElement((Element)td2);
        if (tab.getDescription().length() != 0) {
            h5 h52 = new h5(tab.getDescription());
            td2.addElement((Element)h52);
        }
        if (tab.getHelp().length() != 0) {
            tr2 = new tr();
            tr2.setClass("help-window-tab-help");
            table2.addElement((Element)tr2);
            td2 = new td();
            td2.setColSpan(2);
            tr2.addElement((Element)td2);
            td2.addElement((Element)new p().addElement(tab.getHelp()));
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            td2.setColSpan(2);
            tr2.addElement((Element)td2);
            td2.addElement("&nbsp;");
        }
        return table2;
    }

    private table getFieldsBox(GridTab tab, int tabIndex) {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-fields");
        tr tr2 = new tr();
        table2.addElement((Element)tr2);
        td td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement((Element)new a().setName(this.winpref + "Fields" + tabIndex));
        h4 h42 = new h4(Msg.getMsg((Properties)Env.getCtx(), (String)"Fields"));
        td2.addElement((Element)h42);
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement("&nbsp;");
        tr2 = new tr();
        tr2.setClass("help-window-fields-link");
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        p p2 = new p();
        td2.addElement((Element)p2);
        if (!tab.isLoadComplete()) {
            this.gridWindow.initTab(tabIndex);
        }
        int j = 0;
        while (j < tab.getFieldCount()) {
            String hdr;
            GridField field = tab.getField(j);
            if (field.isDisplayed(false) && (hdr = field.getHeader()) != null && hdr.length() > 0) {
                if (j > 0) {
                    p2.addElement("&nbsp;");
                }
                p2.addElement((Element)new a("#" + this.winpref + "Field" + tabIndex + "-" + j, hdr));
            }
            ++j;
        }
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement("&nbsp;");
        return table2;
    }

    private table getFieldBox(GridField field, int tabIndex, int fieldIndex) {
        table table2 = new table("0", "0", "0", "100%", null);
        table2.setClass("help-window-field");
        tr tr2 = new tr();
        tr2.setClass("help-window-field-name");
        table2.addElement((Element)tr2);
        td td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement((Element)new a().setName(this.winpref + "Field" + tabIndex + "-" + fieldIndex));
        h4 h42 = new h4(Msg.getMsg((Properties)Env.getCtx(), (String)"Field") + ": " + field.getHeader());
        td2.addElement((Element)h42);
        td2.addElement("&nbsp;").addElement("&nbsp;");
        td2.addElement(new a("#" + this.winpref + "Tab" + tabIndex).addElement("..").addAttribute("title", "Up one level"));
        tr2 = new tr();
        table2.addElement((Element)tr2);
        td2 = new td();
        tr2.addElement((Element)td2);
        td2.addElement("&nbsp;");
        if (field.getDescription().length() != 0) {
            tr2 = new tr();
            tr2.setClass("help-window-field-description");
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement((Element)new p().addElement(field.getDescription()));
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement("&nbsp;");
        }
        if (field.getHelp().length() != 0) {
            tr2 = new tr();
            tr2.setClass("help-window-field-help");
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement((Element)new p().addElement(field.getHelp()));
            tr2 = new tr();
            table2.addElement((Element)tr2);
            td2 = new td();
            tr2.addElement((Element)td2);
            td2.addElement("&nbsp;");
        }
        return table2;
    }
}

