/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.adempiere.pipo2.handler.ReferenceListElementHandler;
import org.adempiere.pipo2.handler.ReferenceTableElementHandler;
import org.compiere.model.MReference;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceElementHandler
extends AbstractElementHandler {
    private ReferenceListElementHandler listHandler = new ReferenceListElementHandler();
    private ReferenceTableElementHandler tableHandler = new ReferenceTableElementHandler();
    private List<Integer> references = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes;
        PoFiller filler;
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MReference mReference = (MReference)this.findPO(ctx, element);
        if (mReference == null) {
            mReference = new MReference(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mReference, element, (AbstractElementHandler)this)).autoFill(excludes = this.defaultExcludeList("AD_Reference"))).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        element.recordId = mReference.getAD_Reference_ID();
        if (!mReference.is_new()) {
            if (!mReference.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Reference", 102);
        String action = null;
        if (!mReference.is_new()) {
            if (this.references.contains(mReference.getAD_Reference_ID())) {
                element.skip = true;
                return;
            }
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_ID(), "AD_Reference", (PO)mReference);
            action = "Update";
        } else {
            action = "New";
        }
        if (mReference.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mReference.getName(), mReference.get_ID(), action);
            this.references.add(mReference.getAD_Reference_ID());
            element.recordId = mReference.getAD_Reference_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mReference.getName(), mReference.get_ID(), action);
        throw new POSaveFailedException("Failed to save Reference " + mReference.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        boolean createElement;
        MReference m_Reference;
        int Reference_id;
        block9: {
            Reference_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Reference_ID");
            if (ctx.packOut.isExported("AD_Reference_ID|" + Reference_id)) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            m_Reference = MReference.get((Properties)ctx.ctx, (int)Reference_id);
            createElement = this.isPackOutElement(ctx, (PO)m_Reference);
            PackOut packOut = ctx.packOut;
            packOut.getCtx().ctx.put("Table_Name", "AD_Reference");
            if (createElement) {
                this.verifyPackOutRequirement((PO)m_Reference);
                this.addTypeName(atts, "table");
                document.startElement("", "", "AD_Reference", atts);
                this.createReferenceBinding(ctx, document, m_Reference);
                try {
                    new CommonTranslationHandler().packOut(packOut, document, null, m_Reference.get_ID());
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.INFO)) break block9;
                    this.log.info(e.toString());
                }
            }
        }
        if ("L".equals(m_Reference.getValidationType())) {
            int[] rls;
            int[] nArray = rls = DB.getIDsEx((String)this.getTrxName(ctx), (String)"SELECT AD_Ref_List_ID FROM AD_Ref_List WHERE AD_Reference_ID=?", (Object[])new Object[]{Reference_id});
            int n = rls.length;
            int n2 = 0;
            while (n2 < n) {
                int rl = nArray[n2];
                this.createReferenceList(ctx, document, rl);
                ++n2;
            }
        } else if ("T".equals(m_Reference.getValidationType())) {
            this.createReferenceTable(ctx, document, Reference_id);
        }
        if (createElement) {
            document.endElement("", "", "AD_Reference");
        }
    }

    private void createReferenceTable(PIPOContext ctx, TransformerHandler document, int reference_id) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Reference_ID", (int)reference_id);
        this.tableHandler.create(ctx, document);
        ctx.ctx.remove("AD_Reference_ID");
    }

    private void createReferenceList(PIPOContext ctx, TransformerHandler document, int AD_Ref_List_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Ref_List_ID", (int)AD_Ref_List_ID);
        this.listHandler.create(ctx, document);
        ctx.ctx.remove("AD_Ref_List_ID");
    }

    private void createReferenceBinding(PIPOContext ctx, TransformerHandler document, MReference m_Reference) {
        List excludes = this.defaultExcludeList("AD_Reference");
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Reference);
        if (m_Reference.getAD_Reference_ID() <= 999999) {
            filler.add("AD_Reference_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Reference_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Reference_ID");
    }
}

