/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.expression.logic;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;
import org.idempiere.expression.logic.SimpleBooleanBaseVisitor;
import org.idempiere.expression.logic.SimpleBooleanParser;

public class EvaluationVisitor
extends SimpleBooleanBaseVisitor<Object> {
    private final Evaluatee evaluatee;
    private static final Pattern jdbcTimestampPattern = Pattern.compile(".*[-].*[-].*[:].*[:].*");

    public EvaluationVisitor(Evaluatee evaluatee) {
        this.evaluatee = evaluatee;
    }

    @Override
    public Object visitParse(SimpleBooleanParser.ParseContext ctx) {
        return super.visit((ParseTree)ctx.expression());
    }

    @Override
    public Object visitDecimalExpression(SimpleBooleanParser.DecimalExpressionContext ctx) {
        return new BigDecimal(ctx.DECIMAL().getText());
    }

    @Override
    public Object visitQuotedCSVText(SimpleBooleanParser.QuotedCSVTextContext ctx) {
        return ctx.QCSVTEXT().getText();
    }

    @Override
    public Object visitQuotedText(SimpleBooleanParser.QuotedTextContext ctx) {
        return ctx.QTEXT().getText().replaceAll("[']", "");
    }

    @Override
    public Object visitDoubleQuotedCSVText(SimpleBooleanParser.DoubleQuotedCSVTextContext ctx) {
        return ctx.DQCSVTEXT().getText();
    }

    @Override
    public Object visitDoubleQuotedText(SimpleBooleanParser.DoubleQuotedTextContext ctx) {
        return ctx.DQTEXT().getText().replaceAll("[\"]", "");
    }

    @Override
    public Object visitText(SimpleBooleanParser.TextContext ctx) {
        return ctx.TEXT().getText();
    }

    @Override
    public Object visitNotExpression(SimpleBooleanParser.NotExpressionContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expression()) == false;
    }

    @Override
    public Object visitParenExpression(SimpleBooleanParser.ParenExpressionContext ctx) {
        return super.visit((ParseTree)ctx.expression());
    }

    @Override
    public Object visitComparatorExpression(SimpleBooleanParser.ComparatorExpressionContext ctx) {
        if (ctx.op.EQ() != null) {
            return this.isEqual(ctx);
        }
        if (ctx.op.LE() != null) {
            Comparable leftValue = this.asComparable(ctx.left);
            Comparable rightValue = this.asComparable(ctx.right);
            if (leftValue == null || rightValue == null) {
                return Boolean.FALSE;
            }
            if (leftValue.compareTo(rightValue) <= 0) {
                return true;
            }
            return false;
        }
        if (ctx.op.GE() != null) {
            Comparable leftValue = this.asComparable(ctx.left);
            Comparable rightValue = this.asComparable(ctx.right);
            if (leftValue == null || rightValue == null) {
                return Boolean.FALSE;
            }
            if (leftValue.compareTo(rightValue) >= 0) {
                return true;
            }
            return false;
        }
        if (ctx.op.LT() != null) {
            Comparable leftValue = this.asComparable(ctx.left);
            Comparable rightValue = this.asComparable(ctx.right);
            if (leftValue == null || rightValue == null) {
                return Boolean.FALSE;
            }
            if (leftValue.compareTo(rightValue) < 0) {
                return true;
            }
            return false;
        }
        if (ctx.op.GT() != null) {
            Comparable leftValue = this.asComparable(ctx.left);
            Comparable rightValue = this.asComparable(ctx.right);
            if (leftValue == null || rightValue == null) {
                return Boolean.FALSE;
            }
            if (leftValue.compareTo(rightValue) > 0) {
                return true;
            }
            return false;
        }
        if (ctx.op.NE() != null) {
            return this.isEqual(ctx) == false;
        }
        if (ctx.op.RE() != null) {
            return this.regularExpressionMatch(ctx);
        }
        throw new RuntimeException("not implemented: comparator operator " + ctx.op.getText());
    }

    private Boolean regularExpressionMatch(SimpleBooleanParser.ComparatorExpressionContext ctx) {
        String left = this.visit((ParseTree)ctx.left).toString();
        String right = this.visit((ParseTree)ctx.right).toString();
        return Pattern.matches(right, left);
    }

    private Boolean isEqual(SimpleBooleanParser.ComparatorExpressionContext ctx) {
        Comparable left = this.asComparable(ctx.left);
        Comparable right = this.asComparable(ctx.right);
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        if (left instanceof String && right instanceof String) {
            String rightText = (String)((Object)right);
            if (ctx.right.start.getType() == 20 || ctx.right.start.getType() == 23) {
                return this.isIn((String)((Object)left), rightText);
            }
            if (ctx.right.start.getType() == 24 && rightText.indexOf(",") > 0) {
                return this.isIn((String)((Object)left), rightText);
            }
        }
        if (left instanceof String && !(right instanceof String)) {
            if (right instanceof BigDecimal) {
                return left.equals(((BigDecimal)right).toPlainString());
            }
            return left.equals(right.toString());
        }
        if (right instanceof String && !(left instanceof String)) {
            if (left instanceof BigDecimal) {
                return ((BigDecimal)left).toPlainString().equals(right);
            }
            return left.toString().equals(right.toString());
        }
        try {
            if (left.compareTo(right) == 0) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return left.toString().equals(right.toString());
        }
    }

    private Boolean isIn(String left, String rightText) {
        ArrayList<String> values = new ArrayList<String>();
        char[] chars = rightText.toCharArray();
        Character quote = null;
        StringBuilder value = new StringBuilder();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ec = cArray[n2];
            if (quote != null && quote.charValue() == ec) {
                quote = null;
            }
            if (ec == '\"') {
                if (quote == null) {
                    quote = Character.valueOf(ec);
                } else {
                    value.append(ec);
                }
            } else if (ec == '\'') {
                if (quote == null) {
                    quote = Character.valueOf(ec);
                } else {
                    value.append(ec);
                }
            } else if (Character.isWhitespace(ec)) {
                if (quote != null) {
                    value.append(ec);
                }
            } else if (ec == ',') {
                if (value.length() > 0) {
                    values.add(value.toString());
                }
                value = new StringBuilder();
            } else {
                value.append(ec);
            }
            ++n2;
        }
        if (value.length() > 0) {
            values.add(value.toString());
        }
        for (String s : values) {
            if (!left.equals(s)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object visitBinaryExpression(SimpleBooleanParser.BinaryExpressionContext ctx) {
        if (ctx.op.AND() != null) {
            if (this.asBoolean(ctx.left) && this.asBoolean(ctx.right)) {
                return true;
            }
            return false;
        }
        if (ctx.op.OR() != null) {
            if (!this.asBoolean(ctx.left) && !this.asBoolean(ctx.right)) {
                return false;
            }
            return true;
        }
        throw new RuntimeException("not implemented: binary operator " + ctx.op.getText());
    }

    @Override
    public Object visitBoolExpression(SimpleBooleanParser.BoolExpressionContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitComparator(SimpleBooleanParser.ComparatorContext ctx) {
        return super.visitComparator(ctx);
    }

    @Override
    public Object visitBool(SimpleBooleanParser.BoolContext ctx) {
        return super.visitBool(ctx);
    }

    @Override
    public Object visitBinary(SimpleBooleanParser.BinaryContext ctx) {
        return super.visitBinary(ctx);
    }

    @Override
    public Object visitContextVariables(SimpleBooleanParser.ContextVariablesContext ctx) {
        String value;
        String context = ctx.getText().substring(1, ctx.getText().length() - 1);
        String defaultValue = "";
        int idx = context.indexOf(":");
        if (idx >= 0) {
            defaultValue = context.substring(idx + 1, context.length());
            context = context.substring(0, idx);
        }
        if (Util.isEmpty(value = this.evaluatee.get_ValueAsString(context)) && !Util.isEmpty(defaultValue)) {
            value = defaultValue;
        }
        if (value == null) {
            value = "";
        }
        if (Util.isEmpty(value, true) && context.endsWith("_ID")) {
            return "0";
        }
        return value;
    }

    private boolean asBoolean(SimpleBooleanParser.ExpressionContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx);
    }

    private Comparable asComparable(SimpleBooleanParser.ExpressionContext ctx) {
        Object value = this.visit((ParseTree)ctx);
        if (value instanceof String) {
            String s = (String)value;
            if (Util.isEmpty(s, true)) {
                return null;
            }
            Matcher matcher = jdbcTimestampPattern.matcher(s);
            if (matcher.matches()) {
                try {
                    return Timestamp.valueOf(s);
                }
                catch (Exception exception) {}
            }
            try {
                return new BigDecimal(s);
            }
            catch (Exception exception) {
            }
        } else {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        return value.toString();
    }
}

