/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.PO;
import org.compiere.model.X_AD_PrintFont;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MPrintFont
extends X_AD_PrintFont
implements ImmutablePOSupport {
    private static final long serialVersionUID = -613305916546183810L;
    private Font m_cacheFont = null;
    private static ImmutableIntPOCache<Integer, MPrintFont> s_fonts = new ImmutableIntPOCache("AD_PrintFont", 20);

    public MPrintFont(Properties ctx, String AD_PrintFont_UU, String trxName) {
        super(ctx, AD_PrintFont_UU, trxName);
        if (Util.isEmpty(AD_PrintFont_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPrintFont(Properties ctx, int AD_PrintFont_ID, String trxName) {
        super(ctx, AD_PrintFont_ID, trxName);
        if (AD_PrintFont_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsDefault(false);
    }

    public MPrintFont(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPrintFont(MPrintFont copy) {
        this(Env.getCtx(), copy);
    }

    public MPrintFont(Properties ctx, MPrintFont copy) {
        this(ctx, copy, null);
    }

    public MPrintFont(Properties ctx, MPrintFont copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_cacheFont = copy.m_cacheFont;
    }

    public Font getFont() {
        if (this.m_cacheFont != null) {
            return this.m_cacheFont;
        }
        String code = this.getCode();
        if (code == null || code.equals(".")) {
            this.m_cacheFont = new Font(null);
        }
        try {
            if (code != null && !code.equals(".")) {
                this.m_cacheFont = Font.decode(code);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MPrintFont.getFont", e);
        }
        if (code == null) {
            this.m_cacheFont = new Font(null);
        }
        return this.m_cacheFont;
    }

    public void setFont(Font font) {
        StringBuilder sb = new StringBuilder();
        sb.append(font.getFamily()).append("-");
        int style2 = font.getStyle();
        if (style2 == 0) {
            sb.append("PLAIN");
        } else if (style2 == 1) {
            sb.append("BOLD");
        } else if (style2 == 2) {
            sb.append("ITALIC");
        } else if (style2 == 3) {
            sb.append("BOLDITALIC");
        }
        sb.append("-").append(font.getSize());
        this.setCode(sb.toString());
    }

    static MPrintFont create(Font font) {
        MPrintFont pf = new MPrintFont(Env.getCtx(), 0, null);
        StringBuilder name = new StringBuilder(font.getName());
        if (font.isBold()) {
            name.append(" bold");
        }
        if (font.isItalic()) {
            name.append(" italic");
        }
        name.append(" ").append(font.getSize());
        pf.setName(name.toString());
        pf.setFont(font);
        pf.saveEx();
        return pf;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPrintFont[");
        sb.append("ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append("PSName=").append(this.getFont().getPSName()).append(this.getFont()).append("]");
        return sb.toString();
    }

    public String toPS() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(this.getFont().getPSName());
        if (this.getFont().isBold()) {
            sb.append(" Bold");
        }
        if (this.getFont().isItalic()) {
            sb.append(" Italic");
        }
        sb.append(" ").append(this.getFont().getSize()).append(" selectfont");
        return sb.toString();
    }

    static void dump(Font font) {
        System.out.println("Family=" + font.getFamily());
        System.out.println("FontName=" + font.getFontName());
        System.out.println("Name=" + font.getName());
        System.out.println("PSName=" + font.getPSName());
        System.out.println("Style=" + font.getStyle());
        System.out.println("Size=" + font.getSize());
        System.out.println("Attributes:");
        Map<TextAttribute, ?> map = font.getAttributes();
        for (TextAttribute key : map.keySet()) {
            Object value = map.get(key);
            System.out.println(" - " + String.valueOf(key) + "=" + String.valueOf(value));
        }
        System.out.println(font);
    }

    public static MPrintFont get(int AD_PrintFont_ID) {
        Integer key = AD_PrintFont_ID;
        MPrintFont pf = (MPrintFont)s_fonts.get(key);
        if (pf == null) {
            pf = new MPrintFont(Env.getCtx(), AD_PrintFont_ID, null);
            if (pf.get_ID() == AD_PrintFont_ID) {
                s_fonts.put(key, pf);
                return pf;
            }
            return null;
        }
        return pf;
    }

    @Override
    public MPrintFont markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    public static void main(String[] args) {
        System.out.println("Available Fonts:");
        String[] family = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i2 = 0;
        while (i2 < family.length) {
            System.out.println(" - " + family[i2]);
            ++i2;
        }
        Adempiere.startup(true);
        MPrintFont pf = new MPrintFont(Env.getCtx(), 100, null);
        MPrintFont.dump(pf.getFont());
        int[] IDs = PO.getAllIDs("AD_PrintFont", null, null);
        int i3 = 0;
        while (i3 < IDs.length) {
            pf = new MPrintFont(Env.getCtx(), IDs[i3], null);
            System.out.println(IDs[i3] + " = " + String.valueOf(pf.getFont()));
            ++i3;
        }
    }
}

