/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_AD_TableValRule;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MTableValRule
extends X_AD_TableValRule
implements ImmutablePOSupport {
    private static final long serialVersionUID = -5156583311055069139L;
    private static ImmutablePOCache<String, MTableValRule> s_cache = new ImmutablePOCache("AD_TableValRule", 20);
    private static CCache<String, List<MTableValRule>> s_cachesession = new CCache("AD_TableValRule", 5);
    private static CLogger s_log = CLogger.getCLogger(MTableValRule.class);

    public MTableValRule(Properties ctx, String AD_TableValRule_UU, String trxName) {
        super(ctx, AD_TableValRule_UU, trxName);
    }

    public MTableValRule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTableValRule(MTableValRule copy) {
        this(Env.getCtx(), copy);
    }

    public MTableValRule(Properties ctx, MTableValRule copy) {
        this(ctx, copy, null);
    }

    public MTableValRule(Properties ctx, MTableValRule copy, String trxName) {
        this(ctx, "", trxName);
        this.copyPO(copy);
    }

    public static MTableValRule get(String AD_TableValRule_UU) {
        return MTableValRule.get(Env.getCtx(), AD_TableValRule_UU);
    }

    public static MTableValRule get(Properties ctx, String AD_TableValRule_UU) {
        return MTableValRule.get(ctx, AD_TableValRule_UU, null);
    }

    public static MTableValRule get(Properties ctx, String AD_TableValRule_UU, String trxName) {
        String key = AD_TableValRule_UU;
        MTableValRule retValue = s_cache.get(ctx, key, e -> new MTableValRule(ctx, (MTableValRule)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTableValRule(ctx, AD_TableValRule_UU, trxName);
        if (retValue.get_UUID() == AD_TableValRule_UU) {
            s_cache.put(key, retValue, e -> new MTableValRule(Env.getCtx(), (MTableValRule)e));
            return retValue;
        }
        return null;
    }

    public static MTableValRule getCopy(Properties ctx, String AD_TableValRule_UU, String trxName) {
        MTableValRule vr = MTableValRule.get(ctx, AD_TableValRule_UU, trxName);
        if (vr != null) {
            vr = new MTableValRule(ctx, vr, trxName);
        }
        return vr;
    }

    public static List<MTableValRule> get(Properties ctx, int AD_Table_ID, int AD_Client_ID, int AD_Role_ID, int AD_User_ID) {
        String keySession = AD_Table_ID + "|" + AD_Client_ID + "|" + AD_Role_ID + "|" + AD_User_ID;
        if (s_cachesession.containsKey(keySession)) {
            return s_cachesession.get(keySession);
        }
        List<MTableValRule> retValue = new Query(ctx, "AD_TableValRule", "AD_Table_ID=? AND AD_Client_ID IN (0,?) AND (AD_Role_ID IS NULL OR AD_Role_ID=?) AND (AD_User_ID IS NULL OR AD_User_ID=?)", null).setOnlyActiveRecords(true).setParameters(AD_Table_ID, AD_Client_ID, AD_Role_ID, AD_User_ID).list();
        s_cachesession.put(keySession, retValue);
        return retValue;
    }

    @Override
    public MTableValRule markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() > 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    @Override
    public String toString() {
        MTable table2 = MTable.get(this.getAD_Table_ID());
        StringBuilder sb = new StringBuilder(table2.getName());
        if (this.getAD_User_ID() > 0) {
            MUser user = MUser.get(this.getAD_User_ID());
            sb.append(" -> User=").append(user.getName());
        }
        if (this.getAD_Role_ID() > 0) {
            MRole role = MRole.get(this.getCtx(), this.getAD_Role_ID());
            sb.append(" -> Role=").append(role.getName());
        }
        return sb.toString();
    }
}

