/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.adempiere.exceptions.DBException;
import org.compiere.model.SystemProperties;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CLogger;
import org.compiere.util.CStatementVO;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Trx;
import org.idempiere.db.util.AutoCommitConnectionBroker;

public class StatementProxy
implements InvocationHandler {
    protected Connection m_conn = null;
    private boolean close = false;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    protected transient Statement p_stmt = null;
    protected CStatementVO p_vo = null;

    public StatementProxy(int resultSetType, int resultSetConcurrency, String trxName) {
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency);
        this.p_vo.setTrxName(trxName);
        this.init();
    }

    public StatementProxy(CStatementVO vo) {
        this.p_vo = vo;
        this.init();
    }

    protected StatementProxy() {
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        Object object;
        String logOperation;
        String logSql;
        block28: {
            String name = method.getName();
            if (name.equals("executeQuery") || name.equals("executeUpdate") || name.equals("execute") || name.equals("addBatch")) {
                if (args != null && args.length > 0 && args[0] != null && args[0] instanceof String) {
                    String sql = (String)args[0];
                    this.p_vo.setSql(DB.getDatabase().convertStatement(sql));
                    args[0] = this.p_vo.getSql();
                }
            } else {
                if (name.equals("close") && (args == null || args.length == 0)) {
                    this.close();
                    return null;
                }
                if (name.equals("getRowSet") && (args == null || args.length == 0)) {
                    return this.getRowSet();
                }
                if (name.equals("isClosed") && (args == null || args.length == 0)) {
                    return this.close;
                }
                if (name.equals("finalize") && (args == null || args.length == 0)) {
                    if (this.p_stmt != null && !this.close) {
                        this.close();
                    }
                    return null;
                }
                if (name.equals("commit") && (args == null || args.length == 0)) {
                    this.commit();
                    return null;
                }
                if (name.equals("getSql") && (args == null || args.length == 0)) {
                    return this.getSql();
                }
                if (name.equals("equals") && args != null && args.length == 1) {
                    return this.equals(args[0]);
                }
            }
            logSql = null;
            logOperation = null;
            if (this.log.isLoggable(Level.FINE) && this.getSql() != null && (name.equals("executeUpdate") || name.equals("execute"))) {
                logSql = this.getSql().toUpperCase();
                if (logSql.startsWith("UPDATE ")) {
                    logSql = logSql.substring("UPDATE ".length()).trim();
                    logOperation = "Update";
                } else if (logSql.startsWith("INSERT INTO ")) {
                    logSql = logSql.substring("INSERT INTO ".length()).trim();
                    logOperation = "Insert";
                } else if (logSql.startsWith("DELETE FROM ")) {
                    logSql = logSql.substring("DELETE FROM ".length()).trim();
                    logOperation = "Delete";
                }
                if (logOperation != null) {
                    int idxspace = logSql.indexOf(32);
                    if (idxspace > 0) {
                        logSql = logSql.substring(0, logSql.indexOf(32));
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(DisplayType.getDateFormat(16).format(new Date(System.currentTimeMillis())) + "," + logOperation + "," + logSql + "," + (this.p_vo.getTrxName() != null ? this.p_vo.getTrxName() : "") + " (begin)");
                    }
                }
            }
            Method m = this.p_stmt.getClass().getMethod(name, method.getParameterTypes());
            String nullTrxName = null;
            try {
                if (SystemProperties.isTraceNullTrxConnection() && this.p_vo.getTrxName() == null) {
                    nullTrxName = Trx.registerNullTrx();
                }
                object = m.invoke((Object)this.p_stmt, args);
                if (nullTrxName == null || this.p_vo.getTrxName() != null) break block28;
            }
            catch (InvocationTargetException e) {
                try {
                    throw DB.getSQLException(e);
                }
                catch (Throwable throwable) {
                    if (nullTrxName != null && this.p_vo.getTrxName() == null) {
                        Trx.unregisterNullTrx(nullTrxName);
                    }
                    if (this.log.isLoggable(Level.FINE) && logSql != null && logOperation != null) {
                        this.log.fine(DisplayType.getDateFormat(16).format(new Date(System.currentTimeMillis())) + "," + logOperation + "," + logSql + "," + (this.p_vo.getTrxName() != null ? this.p_vo.getTrxName() : "") + " (end)");
                    }
                    throw throwable;
                }
            }
            Trx.unregisterNullTrx(nullTrxName);
        }
        if (this.log.isLoggable(Level.FINE) && logSql != null && logOperation != null) {
            this.log.fine(DisplayType.getDateFormat(16).format(new Date(System.currentTimeMillis())) + "," + logOperation + "," + logSql + "," + (this.p_vo.getTrxName() != null ? this.p_vo.getTrxName() : "") + " (end)");
        }
        return object;
    }

    protected void init() {
        try {
            Connection conn = null;
            Trx trx = this.p_vo.getTrxName() == null ? null : Trx.get(this.p_vo.getTrxName(), false);
            conn = trx != null ? trx.getConnection() : (this.m_conn = AutoCommitConnectionBroker.getConnection());
            if (conn == null) {
                throw new DBException("No Connection");
            }
            this.p_stmt = conn.createStatement(this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "CStatement", e);
            throw new DBException(e);
        }
    }

    protected void close() throws SQLException {
        if (this.close) {
            return;
        }
        try {
            DB.close(this.p_stmt);
        }
        finally {
            if (this.m_conn != null) {
                AutoCommitConnectionBroker.releaseConnection(this.m_conn);
            }
            this.m_conn = null;
            this.p_stmt = null;
            this.close = true;
        }
    }

    protected RowSet getRowSet() {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("getRowSet");
        }
        RowSet rowSet = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.p_stmt.executeQuery(this.p_vo.getSql());
                rowSet = CCachedRowSet.getRowSet(rs);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            rs = null;
            DB.close(rowSet);
            rowSet = null;
            throw throwable;
        }
        DB.close(rs);
        rs = null;
        DB.close(rowSet);
        rowSet = null;
        return rowSet;
    }

    private void commit() throws SQLException {
        if (this.m_conn != null && !this.m_conn.getAutoCommit()) {
            this.m_conn.commit();
        }
    }

    public String getSql() {
        if (this.p_vo != null) {
            return this.p_vo.getSql();
        }
        return null;
    }
}

