/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MSMTP;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.SvrProcess;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;

@Process
public class EMailTest
extends SvrProcess {
    protected int p_AD_Client_ID = 0;

    protected void prepare() {
        this.p_AD_Client_ID = this.getRecord_ID();
        if (this.p_AD_Client_ID == 0) {
            this.p_AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
        }
    }

    protected String doIt() throws Exception {
        if (this.getProcessInfo().getTable_ID() == 112) {
            MClient client = MClient.get((Properties)this.getCtx(), (int)this.p_AD_Client_ID);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(client.toString());
            }
            String clientTest = client.testEMail();
            StringBuilder msglog = new StringBuilder().append(client.getName()).append(": ").append(clientTest);
            this.addLog(0, null, null, msglog.toString());
            if (!Ini.isClient()) {
                File file;
                String documentDir = client.getDocumentDir();
                if (documentDir == null || documentDir.length() == 0) {
                    documentDir = ".";
                }
                if ((file = new File(documentDir)).exists() && file.isDirectory()) {
                    this.addLog(0, null, null, "Found Directory: " + documentDir);
                } else {
                    this.addLog(0, null, null, "Not Found Directory: " + documentDir);
                }
            }
            return Util.isEmpty((String)clientTest) ? "OK" : "@Error@ " + clientTest;
        }
        if (this.getProcessInfo().getTable_ID() == 200280) {
            String msg;
            MSMTP smtp;
            MClient client;
            block14: {
                EMail email;
                client = MClient.get((int)this.getAD_Client_ID());
                smtp = new MSMTP(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
                String systemName = MSystem.get((Properties)this.getCtx()).getName();
                StringBuilder subject = new StringBuilder(systemName).append(" EMail Test");
                StringBuilder msgce = new StringBuilder(systemName).append(" EMail Test");
                int mailtextID = MSysConfig.getIntValue((String)"EMAIL_TEST_MAILTEXT_ID", (int)0, (int)this.getAD_Client_ID());
                if (mailtextID > 0) {
                    MMailText mt = new MMailText(this.getCtx(), mailtextID, this.get_TrxName());
                    mt.setPO((PO)client);
                    subject = new StringBuilder(mt.getMailHeader());
                    msgce = new StringBuilder(mt.getMailText(true));
                }
                if ((email = client.createEMail(smtp.getRequestUser(), subject.toString(), msgce.toString())) == null) {
                    StringBuilder msgreturn = new StringBuilder("Could not create EMail: ").append(this.getName());
                    return msgreturn.toString();
                }
                try {
                    Object from = smtp.getUsedByEmailOrDomain();
                    if (!((String)from).contains("@")) {
                        from = "test@" + (String)from;
                    }
                    email.setFrom((String)from);
                    msg = email.sendEx();
                    if (!"OK".equals(msg)) break block14;
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Sent Test EMail to " + client.getRequestEMail());
                    }
                    return "";
                }
                catch (Exception ex) {
                    throw new AdempiereException((Throwable)ex);
                }
            }
            this.log.warning("Could NOT send Test EMail from " + smtp.getSMTPHost() + ":  (" + smtp.getRequestUser() + ") to " + client.getRequestEMail() + ": " + msg);
            return "@Error@" + msg;
        }
        return "@Error@ this process is not intented to be executed from table " + MTable.get((Properties)this.getCtx(), (int)this.getProcessInfo().getTable_ID()).getName();
    }
}

